/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 工作日历表Entity
 * 
 * @author Sunny
 * @version 2024-10-17
 */
public class Workday extends DataEntity<Workday> {

	private static final long serialVersionUID = 1L;
	
	private String name; // 日期名称
	
	private String dateStr; // 日期名称
	
	private Boolean offDay; // 休息日

	public Workday() {
		super();
	}

	public Workday(String id) {
		super(id);
	}

	@Length(min = 1, max = 100, message = "日期名称长度必须介于 1 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 64, message = "日期名称长度必须介于 0 和 64 之间")
	public String getDateStr() {
		return dateStr;
	}

	public void setDateStr(String dateStr) {
		this.dateStr = dateStr;
	}

	@Length(min = 0, max = 2, message = "休息日长度必须介于 0 和 2 之间")
	public Boolean getOffDay() {
		return offDay;
	}

	public void setOffDay(Boolean offDay) {
		this.offDay = offDay;
	}

}