/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.sys.entity.LoginServer;

/**
 * 登录服务DAO接口
 * @author cxt
 * @version 2017-12-07
 */
@MyBatisDao
public interface LoginServerDao extends CrudDao<LoginServer> {
	//根据当前登录账号获取可查询的犬种
	LoginServer getByUserType(@Param("userType")String userType);

	/**
	 * @Description： 通过shortName获得LoginServer
	 * @author: yuanshuai
	 * @date: 2017/12/11 15:29
	 */
    LoginServer getByShortName(@Param("shortName")String shortName);

	/**
	 * @Description： 通过isAlike获得同类的会员中心账号关联的会员站点信息
	 * @author: 柴雪腾
	 * @date: 2017/12/12 15:29
	 */
	LoginServer getByIsAlikeOnMember(@Param("isAlike")String isAlike);

	/**
	 * @Description： 通过memberSite获得LoginServer
	 * @author: yuanshuai
	 * @date: 2017/12/11 15:29
	 */
    LoginServer getByMemberSite(@Param("memberSite")String memberSite);
}