package com.cku.oa.sys.code;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 美容资格证书生成Service
 * @author 柴雪腾
 * @version 2016-12-12
 */
@Service
@Transactional(readOnly = true)
public class SysCodeGroomerService {
	
	@Autowired
	private SysCodeGroomerDao sysCodeGroomerDao;
	

	/**
	 * 根据年份和级别查询 基数
	 * @Author chaixueteng
	 * @2016年12月12日上午10:45:05
	 */
	@Transactional(readOnly = true)
	public SysCodeGroomer getCode(String yearStr, String level) {
		return sysCodeGroomerDao.getCode(yearStr, level);
	}

	/**
	 * 基数加一
	 * @Author chaixueteng
	 * @2016年12月12日下午1:52:40
	 */
	@Transactional(readOnly = true)
	public void updateCode(SysCodeGroomer sysCodeGroomer) {
		sysCodeGroomerDao.updateCode(sysCodeGroomer);
	}
	
}