package com.cku.oa.statistics.web;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.oa.statistics.entity.RegionExport;
import com.cku.oa.statistics.service.RegionExportService;
import com.cku.oa.statistics.service.RegionRevenueService;
import com.cku.oa.statistics.service.ShowOfficeRegionService;
import com.cku.oa.statistics.vo.RegionRevenueVo;
import com.cku.oa.statistics.vo.RegionVo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 大区业务收入统计
 */

@Controller
@RequestMapping(value = "${adminPath}/statistics/region/")
public class RegionRevenueController {

	@Autowired
	private ShowOfficeRegionService showOfficeRegionService;

	@Autowired
	private RegionRevenueService regionRevenueService;

	@Autowired
	private RegionExportService regionExportService;

	@RequestMapping(value = "revenue")
	public String revenue(RegionRevenueVo vo, HttpServletRequest request, HttpServletResponse response, Model model)
			throws ParseException {
		List<RegionVo> regions = showOfficeRegionService.findRegionList();
		model.addAttribute("regions", regions);
		model.addAttribute("regionRevenue", vo);

		if (StringUtils.isEmpty(vo.getStartDate()) && StringUtils.isEmpty(vo.getEndDate())) {
			return "oa/statistics/region/revenue";
		}
		regionRevenueService.revenue(vo, model, regions);
		return "oa/statistics/region/revenue";
	}

	@RequiresPermissions("statistics:region:export")
	@RequestMapping(value = "report/export")
	@ResponseBody
	public Map<String, String> export(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		User user = UserUtils.getUser();
		RegionExport regionExport = new RegionExport();
		regionExport.setCreateDate(new Date());
		regionExport.setUserId(user.getId());
		regionExport.setStartDate(startDate);
		regionExport.setEndDate(endDate);
		String fileName =  DateUtils.formatDateTimeSSS(new Date())  + ".xlsx";
		regionExport.setFileName(fileName);
		regionExportService.save(regionExport);

		// 延迟下载
		regionRevenueService.export(startDate, endDate, regionExport);

		Map<String, String> map = new HashMap<String, String>();
		map.put("code", "OK");
		map.put("fileName", fileName);
		return map;
	}

	@RequestMapping(value = "orderList")
	public String orderList(HttpServletRequest request, HttpServletResponse response, Model model)
			throws ParseException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String chargingItemID = request.getParameter("chargingItemID");
		String province = request.getParameter("province");
		String orderType = request.getParameter("orderType");
		String isShowCoupon = request.getParameter("isShowCoupon");
		RegionRevenueVo vo = new RegionRevenueVo();
		vo.setStartDate(startDate);
		vo.setEndDate(endDate);
		vo.setChargingItemID(chargingItemID);
		vo.setOrderType(orderType);
		vo.setIsShowCoupon(isShowCoupon);
		vo.setProvince(province);
		Page<User> page = new Page<User>(request, response);// 从页面的参数中获取当前的页码等信息
		page.setPageSize(20); // 每页的大小

		List<RegionVo> regions = showOfficeRegionService.findRegionList();
		return regionRevenueService.regionsCountOrder(vo, regions, model, page);
	}

}
