package com.cku.oa.statistics.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.cku.oa.statistics.dao.ShopSalesStatisticsDao;
import com.cku.oa.statistics.entity.ShopSalesStatistics;
import com.cku.core.ZAException;

/**
 * 商城销售统计Service
 * @author chy
 * @version 2017-12-19
 */
@Service
@Transactional(readOnly = true)
public class ShopSalesStatisticsService extends CrudService<ShopSalesStatisticsDao, ShopSalesStatistics> {

	public ShopSalesStatistics get(String id) {
		return super.get(id);
	}
	
	public List<ShopSalesStatistics> findList(ShopSalesStatistics shopSalesStatistics) {
		return super.findList(shopSalesStatistics);
	}
	
	public Page<ShopSalesStatistics> findPage(Page<ShopSalesStatistics> page, ShopSalesStatistics shopSalesStatistics) {
		return super.findPage(page, shopSalesStatistics);
	}
	
	@Transactional(readOnly = false)
	public void save(ShopSalesStatistics shopSalesStatistics) {
		super.save(shopSalesStatistics);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShopSalesStatistics shopSalesStatistics) {
		super.delete(shopSalesStatistics);
	}
	
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importShops(MultipartFile file) throws Exception {
		try {
			ImportExcel ei = new ImportExcel(file,1,0);
			List<ShopSalesStatistics> list = ei.getDataList(ShopSalesStatistics.class);
			Calendar c = new GregorianCalendar(1900,0,-1);  
			Date d = c.getTime(); 
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			for(ShopSalesStatistics ssc :list){
				//跳过无效记录
				if(StringUtils.isBlank(ssc.getCommodityName()) || StringUtils.isBlank(ssc.getStatisticalDate()) || StringUtils.isBlank(ssc.getCommodityType())){
					continue;
				};
				Date _d = DateUtils.addDays(d,Integer.parseInt(ssc.getStatisticalDate()));
			    String s = sdf.format(_d);
			    ssc.setStatisticalDate(s);
			    //ssc.setTotalAmount(ssc.getTotalAmount().replace(",",""));
				if(!"".equals(ssc.getStatisticalDate())){
					List<ShopSalesStatistics> sscFlags = dao.getByStatisticalDate(ssc.getStatisticalDate());
					if (sscFlags.size() > 0) {
						for (ShopSalesStatistics shopSalesStatistics : sscFlags) {
							if(null != shopSalesStatistics && ssc.getCommodityName().equals(shopSalesStatistics.getCommodityName()) && ssc.getCommodityType().equals(shopSalesStatistics.getCommodityType())){
								dao.delete(shopSalesStatistics);
							}
						}
					}
				}
				save(ssc);
			}
		} catch (Exception e) {
			throw new Exception(e);
		}
	}
	
	public List<String> findCommodityNameList() {
		return dao.findCommodityNameList();
	}
	
}