package com.cku.oa.showRefereeDelegate.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.showRefereeDelegate.dao.ShowRefereeDelegateLogDao;
import com.cku.oa.showRefereeDelegate.entity.Referee;
import com.cku.oa.showRefereeDelegate.entity.Show;
import com.cku.oa.showRefereeDelegate.entity.ShowRefereeDelegateLog;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 犬展裁判委派记录Service
 *
 * @author 袁帅
 * @version 2021-03-16
 */
@Service
@Transactional(readOnly = true)
public class ShowRefereeDelegateLogService extends CrudService<ShowRefereeDelegateLogDao, ShowRefereeDelegateLog> {

	@Override
	public ShowRefereeDelegateLog get(String id) {
		return super.get(id);
	}

	@Override
	public List<ShowRefereeDelegateLog> findList(ShowRefereeDelegateLog showRefereeDelegateLog) {
		return super.findList(showRefereeDelegateLog);
	}

	@Override
	public Page<ShowRefereeDelegateLog> findPage(Page<ShowRefereeDelegateLog> page, ShowRefereeDelegateLog showRefereeDelegateLog) {
		return super.findPage(page, showRefereeDelegateLog);
	}

	@Override
	@Transactional(readOnly = false)
	public void save(ShowRefereeDelegateLog showRefereeDelegateLog) {
		super.save(showRefereeDelegateLog);
	}

	@Override
	@Transactional(readOnly = false)
	public void delete(ShowRefereeDelegateLog showRefereeDelegateLog) {
		super.delete(showRefereeDelegateLog);
	}

	/**
	 * 导入模板
	 *
	 * @author yuanshuai
	 * @date 2021/3/17 14:28
	 */
	public void importFileTemplate(HttpServletResponse response) throws IOException {
		List<ShowRefereeDelegateLog> delegateLogList = Lists.newArrayList();
		ShowRefereeDelegateLog delegateLog = new ShowRefereeDelegateLog();
		delegateLog.setMainShowId("202110");
		delegateLog.setCount(6);
		delegateLog.setRegion("华北");
		delegateLog.setStartDate(new Date());
		delegateLog.setEndDate(new Date());
		delegateLog.setCity("石家庄");
		delegateLog.setProvince("河北");
		delegateLog.setReferees("张三,李四,王五,王六,王七,王八（用英文逗号分隔）");
		delegateLogList.add(delegateLog);
		ExportExcel exportExcel = new ExportExcel("犬展委派记录导入模板", ShowRefereeDelegateLog.class, 2);
		exportExcel.setDataList(delegateLogList, 0);
		exportExcel.write(response, "犬展委派记录导入模板.xlsx").dispose();
	}

	/**
	 * 导入数据
	 *
	 * @author yuanshuai
	 * @date 2021/3/17 14:29
	 */
	@Transactional(readOnly = false)
	public void importShowReferee(MultipartFile file) throws IOException, InvalidFormatException, IllegalAccessException, InstantiationException {
		ImportExcel delegateLogIe = new ImportExcel(file, 1, 0);
		List<ShowRefereeDelegateLog> importList = delegateLogIe.getDataList(ShowRefereeDelegateLog.class);
		importList.stream()
				.filter(delegateLog -> !StringUtils.isBlank(delegateLog.getMainShowId()))
				.forEach(delegateLog -> {
					if (checkDuplicateByShow(delegateLog.getMainShowId())) {
						throw new ZAException(ZAErrorCode.ZA_ERROR, delegateLog.getMainShowId() + "犬展已经录入过，请删除后重试");
					}
					int refereeCount = delegateLog.getReferees().split(",").length;
					if (refereeCount != delegateLog.getCount()) {
						throw new ZAException(ZAErrorCode.ZA_ERROR, delegateLog.getMainShowId() + "犬展人次与裁判数量不一致（裁判需用英文逗号分隔）");
					}
					delegateLog.setRegion(DictUtils.getDictValue(delegateLog.getRegion(), "show_region", "0"));
					save(delegateLog);
				});
	}

	public boolean checkDuplicateByShow(String mainShowId){
		if (dao.getCountByMainShowId(mainShowId) > 0) {
			return true;
		}
		return false;
	}
}