package com.cku.oa.show.web;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.show.entity.ShowScoreTitle;
import com.cku.oa.show.service.ShowScoreTitleService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬展积分榜标题Controller
 * @author wj
 * @version 2020-12-15
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showScoreTitle")
public class ShowScoreTitleController extends BaseController {

	@Autowired
	private ShowScoreTitleService showScoreTitleService;

	@ModelAttribute
	public ShowScoreTitle get(@RequestParam(required=false) String id) {
		ShowScoreTitle entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showScoreTitleService.get(id);
		}
		if (entity == null){
			entity = new ShowScoreTitle();
		}
		return entity;
	}

	@RequestMapping(value = {"list", ""})
	public String list(ShowScoreTitle showScoreTitle, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowScoreTitle> page = showScoreTitleService.findPage(new Page<ShowScoreTitle>(request, response), showScoreTitle);
		model.addAttribute("page", page);
		model.addAttribute("years", getYearsF2014());
		return "oa/show/scoreTitle/showScoreTitleList";
	}
	
	private List<String> getYearsF2014(){
		List<String> list = new ArrayList<>();
		int year = LocalDate.now().getYear();
		for(int i = year;i >= 2014;i--) {
			list.add(i+"");
		}
	    return list;
	}

	@RequestMapping(value = "form")
	public String form(ShowScoreTitle showScoreTitle, Model model) {
		if(StringUtils.isBlank(showScoreTitle.getId())){
			showScoreTitle.setYear(DateUtils.getYear());
		}
		model.addAttribute("showScoreTitle", showScoreTitle);
		model.addAttribute("years", getYearsF2014());
		return "oa/show/scoreTitle/showScoreTitleForm";
	}

	@RequestMapping(value = "save")
	public String save(ShowScoreTitle showScoreTitle, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showScoreTitle)){
			return form(showScoreTitle, model);
		}
		showScoreTitleService.save(showScoreTitle);
		addMessage(redirectAttributes, "保存犬展积分榜标题成功");
		return "redirect:"+Global.getAdminPath()+"/show/showScoreTitle/?repage";
	}

	@RequestMapping(value = "delete")
	public String delete(ShowScoreTitle showScoreTitle, RedirectAttributes redirectAttributes) {
		showScoreTitleService.delete(showScoreTitle);
		addMessage(redirectAttributes, "删除犬展积分榜标题成功");
		return "redirect:"+Global.getAdminPath()+"/show/showScoreTitle/?repage";
	}

}