/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.web;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.show.entity.CkuImage;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowHotel;
import com.cku.oa.show.entity.ShowOffice;
import com.cku.oa.show.entity.ShowVenue;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowHotelService;
import com.cku.oa.show.service.ShowJudgeService;
import com.cku.oa.show.service.ShowOfficeService;
import com.cku.oa.show.service.ShowVenueService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 犬展子表Controller
 * @author lgl
 * @version 2016-07-13
 */
@Controller
@RequestMapping(value = "${adminPath}/mainShow/CkuShows")
public class MainShowsController extends BaseController {

	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ShowJudgeService showJudgeService;
	@Autowired
	private ShowVenueService ckuMatchVenueService;
	@Autowired
	private ShowHotelService ckuMatchHotelService;
	@Autowired
	private ShowOfficeService showOfficeService;
	
	private final static String AUTHORITY_PRDFIX = "mainShow:CkuShows:";
	
	@ModelAttribute
	public MainShows get(@RequestParam(required=false) String id) {
		MainShows entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = mainShowsService.get(id);
		}
		if (entity == null){
			entity = new MainShows();
		}
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(MainShows MainShows, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page pageVo = new Page<MainShows>(request, response);
		pageVo.setOrderBy("a.start_time DESC");
		Page<MainShows> page = mainShowsService.findPage(pageVo, MainShows);
		model.addAttribute("page", page);
		return "oa/show/main/mainShowsList";
	}


	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "add")
	public String add(MainShows mainShows, Model model) {
		if(mainShows.getId()!=null){
			mainShows = mainShowsService.get(mainShows.getId());
			String organizer = mainShows.getOrganizer();
			mainShows.setOrganizer(DictUtils.getDictLabel(organizer, "show_organizer", ""));
			//cku_image
			CkuImage ckuImage = mainShowsService.getCkuImageByRemarks(mainShows.getShowLocation());
			if(!Objects.isNull(ckuImage)) {
				mainShows.setImageMinUrl(ckuImage.getImageMinUrl());
				mainShows.setImageMaxUrl( ckuImage.getImageMaxUrl());
			}
		}
		List<ShowVenue> venueList=ckuMatchVenueService.findAllList();
		List<ShowHotel> hotelList=ckuMatchHotelService.findAllList();
		List<ShowOffice> officeList=showOfficeService.findAllList();
		model.addAttribute("mainShows", mainShows);
		model.addAttribute("venueList", venueList);
		model.addAttribute("hotelList", hotelList);
		model.addAttribute("officeList", officeList);
		model.addAttribute("showFeeTemplate", childShowsService.getShowFeeTemplate());
		return "oa/show/main/mainShowsEdit";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "saveMain")
	public String saveMain(MainShows mainShows, Model model, RedirectAttributes redirectAttributes) {
		try {
			mainShowsService.save(mainShows);
			mainShowsService.saveCkuImage(mainShows);
			addMessage(redirectAttributes, "保存犬展成功");
		} catch (Exception e) {
			e.printStackTrace();
			addMessage(redirectAttributes, "保存犬展信息失败:"+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/mainShow/CkuShows/list";
	}
	
	/**
	 * 删除官网犬展图片
	 * @Author chaixueteng
	 * @2017年8月28日上午10:31:02
	 */
	@RequestMapping(value = "deleteCkuImage")
	@ResponseBody
	public Object deleteCkuImage(@RequestParam(required=true) String mainShowId,@RequestParam(required=true) String type) {
		HashMap<String,String> map = new HashMap<String,String>();
		try {
			mainShowsService.deleteCkuImage(mainShowId,type);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

}