package com.cku.oa.show.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.util.Date;

/**
 * Title: ShowScoreBlankExport
 * Description: 赛事成绩空白导出表
 * Company: cab
 *
 * @author yuanshuai
 * @date 2018/4/8 10:28
 */
public class ShowScoreBlankExport {

    @ExcelField(title = "秩序册顺序", align = 2, sort = 1)
    private String id;
    @ExcelField(title = "上场顺序", align = 2, sort = 2)
    private String showOrder;
    @ExcelField(title = "犬展活动日期", align = 2, sort = 3)
    private Date showDate;
    @ExcelField(title = "犬展活动名称", align = 2, sort = 4)
    private String showName;
    @ExcelField(title = "赛制", align = 2, sort = 5)
    private String showRule;
    @ExcelField(title = "犬展编号", align = 2, sort = 6)
    private String showCode;
    @ExcelField(title = "秩序号", align = 2, sort = 7)
    private String orderNum;
    //成绩空白列
    @ExcelField(title = "未参赛/\n成绩取消/\n芯片问题/\n中途放弃参展/\n失格", align = 2, sort = 8)
    private String showScore1;
    //-----------成绩空白列-start------------
    @ExcelField(title = "现场\nCC/评价", align = 2, sort = 9)
    private String showScore2;
    @ExcelField(title = "有效\nCC", align = 2, sort = 10)
    private String showScore3;
    @ExcelField(title = "CACIB/\n单独展年龄组名次", align = 2, sort = 11)
    private String showScore4;
    @ExcelField(title = "CACIB备注", align = 2, sort = 12)
    private String showScore5;
    @ExcelField(title = "WD/RWD/WB/RWB/\nCHD/CHB/VD/VB/\nJD/JB/CD/RCD/CB/RCB", align = 2, sort = 13)
    private String showScore6;
    @ExcelField(title = "BOW", align = 2, sort = 14)
    private String showScore7;
    @ExcelField(title = "BOJ/JBOS", align = 2, sort = 15)
    private String showScore8;
    @ExcelField(title = "大赛JBIG", align = 2, sort = 16)
    private String showScore9;
    @ExcelField(title = "大赛JBIS", align = 2, sort = 17)
    private String showScore10;
    @ExcelField(title = "BOB/BOS/\n单独展\nBOV/\n公主/王子/WD/WB", align = 2, sort = 18)
    private String showScore11;
    @ExcelField(title = "BIG/\n单独展\n挑战WB成功", align = 2, sort = 19)
    private String showScore12;
    @ExcelField(title = "BIS/\n单独展BISS/BOSS", align = 2, sort = 20)
    private String showScore13;
    @ExcelField(title = "本场积分", align = 2, sort = 21)
    private String showScore14;
    //-----------成绩空白列-end------------
    @ExcelField(title = "犬主人", align = 2, sort = 22)
    private String dogOwnerName;
    @ExcelField(title = "参展人", align = 2, sort = 23)
    private String dogOwnerAndHandle;
    @ExcelField(title = "姓名拼音", align = 2, sort = 24)
    private String dogOwnerPinYin;
    @ExcelField(title = "会员号", align = 2, sort = 25)
    private String dogOwnerCode;
    @ExcelField(title = "犬种中文名", align = 2, sort = 26)
    private String dogBreedNameCn;
    @ExcelField(title = "犬种英文名", align = 2, sort = 27)
    private String dogBreedNameEn;
    @ExcelField(title = "FCI代码", align = 2, sort = 28)
    private String dogBreedCode;
    @ExcelField(title = "犬种组", align = 2, sort = 29)
    private String dogBreedGroup;
    @ExcelField(title = "犬名", align = 2, sort = 30)
    private String dogName;
    @ExcelField(title = "性别", align = 2, sort = 31)
    private String dogGender;
    @ExcelField(title = "代数", align = 2, sort = 32)
    private String dogGeneration;
    @ExcelField(title = "出生日期", align = 2, sort = 33)
    private Date dogBirthday;
    @ExcelField(title = "年龄组别", align = 2, sort = 34)
    private String dogAgeGroup;
    @ExcelField(title = "CKU血统证书号", align = 2, sort = 35)
    private String dogCertificateCode;
    @ExcelField(title = "国外血统证书号", align = 2, sort = 36)
    private String dogCertificateCodeEn;
    @ExcelField(title = "芯片号", align = 2, sort = 37)
    private String dogChip;
    //-----------其他空白列-start------------
    @ExcelField(title = "犬展活动区域扫描出芯片", align = 2, sort = 38)
    private String other1;
    @ExcelField(title = "修改说明\n原证书交回，证书号不变。", align = 2, sort = 39)
    private String other2;
    //-----------其他空白列-end------------
    @ExcelField(title = "父犬血统证书号", align = 2, sort = 40)
    private String dogCertificateF;
    @ExcelField(title = "父犬名", align = 2, sort = 41)
    private String dogNameF;
    @ExcelField(title = "母犬血统证书号", align = 2, sort = 42)
    private String dogCertificateM;
    @ExcelField(title = "母犬名", align = 2, sort = 43)
    private String dogNameM;
    @ExcelField(title = "繁殖人", align = 2, sort = 44)
    private String dogBreeder;
    @ExcelField(title = "裁判", align = 2, sort = 45)
    private String judge;
    @ExcelField(title = "赛圈", align = 2, sort = 46)
    private String showRing;
    @ExcelField(title = "备注", align = 2, sort = 47)
    private String remarks;
    @ExcelField(title = "毛色", align = 2, sort = 48)
    private String dogColorMark;


    public ShowScoreBlankExport() {
    }

    /**
     * @Description： 根据showApply构建导出实体
     * @author: yuanshuai
     * @date: 2018/4/8 15:07
     */
    public ShowScoreBlankExport(ShowApply showApply) {
        this();
        showCode = showApply.getShowCode();
        orderNum = showApply.getOrderNum();
        dogOwnerName = showApply.getDogOwnerNameCn();
        dogOwnerAndHandle = showApply.getDogOwnerAndHandler();
        dogOwnerPinYin = showApply.getDogOwnerNameEn();
        dogOwnerCode = showApply.getDogOwnerMemberCode();
        dogBreedNameCn = showApply.getDogBreedNameCn();
        dogBreedNameEn = showApply.getDogBreedNameEn();
        dogBreedCode = showApply.getFciCode();
        dogBreedGroup = showApply.getDogBreedGroup();
        dogName = showApply.getDogName();
        dogGender = showApply.getDogGender();
        dogGeneration = showApply.getDogGeneration();
        dogBirthday = showApply.getDogBirthday();
        dogAgeGroup = showApply.getAgeGroup();
        dogCertificateCode =showApply.getPedigreeCertified();
        dogCertificateCodeEn = showApply.getOtherCertified();
        dogChip = showApply.getChipCode();
        dogCertificateF = showApply.getFdogPedigreeCertified();
        dogNameF = showApply.getFdogName();
        dogCertificateM = showApply.getMdogPedigreeCertified();
        dogNameM = showApply.getMdogName();
        dogBreeder = showApply.getBreeder();
        remarks = showApply.getRemarks();
        dogColorMark = showApply.getColorFlag();
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getShowOrder() {
        return showOrder;
    }

    public void setShowOrder(String showOrder) {
        this.showOrder = showOrder;
    }

    public Date getShowDate() {
        return showDate;
    }

    public void setShowDate(Date showDate) {
        this.showDate = showDate;
    }

    public String getShowName() {
        return showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public String getShowRule() {
        return showRule;
    }

    public void setShowRule(String showRule) {
        this.showRule = showRule;
    }

    public String getShowCode() {
        return showCode;
    }

    public void setShowCode(String showCode) {
        this.showCode = showCode;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getShowScore1() {
        return showScore1;
    }

    public void setShowScore1(String showScore1) {
        this.showScore1 = showScore1;
    }

    public String getShowScore2() {
        return showScore2;
    }

    public void setShowScore2(String showScore2) {
        this.showScore2 = showScore2;
    }

    public String getShowScore3() {
        return showScore3;
    }

    public void setShowScore3(String showScore3) {
        this.showScore3 = showScore3;
    }

    public String getShowScore4() {
        return showScore4;
    }

    public void setShowScore4(String showScore4) {
        this.showScore4 = showScore4;
    }

    public String getShowScore5() {
        return showScore5;
    }

    public void setShowScore5(String showScore5) {
        this.showScore5 = showScore5;
    }

    public String getShowScore6() {
        return showScore6;
    }

    public void setShowScore6(String showScore6) {
        this.showScore6 = showScore6;
    }

    public String getShowScore7() {
        return showScore7;
    }

    public void setShowScore7(String showScore7) {
        this.showScore7 = showScore7;
    }

    public String getShowScore8() {
        return showScore8;
    }

    public void setShowScore8(String showScore8) {
        this.showScore8 = showScore8;
    }

    public String getShowScore9() {
        return showScore9;
    }

    public void setShowScore9(String showScore9) {
        this.showScore9 = showScore9;
    }

    public String getShowScore10() {
        return showScore10;
    }

    public void setShowScore10(String showScore10) {
        this.showScore10 = showScore10;
    }

    public String getShowScore11() {
        return showScore11;
    }

    public void setShowScore11(String showScore11) {
        this.showScore11 = showScore11;
    }

    public String getShowScore12() {
        return showScore12;
    }

    public void setShowScore12(String showScore12) {
        this.showScore12 = showScore12;
    }

    public String getShowScore13() {
        return showScore13;
    }

    public void setShowScore13(String showScore13) {
        this.showScore13 = showScore13;
    }

    public String getShowScore14() {
        return showScore14;
    }

    public void setShowScore14(String showScore14) {
        this.showScore14 = showScore14;
    }

    public String getDogOwnerName() {
        return dogOwnerName;
    }

    public void setDogOwnerName(String dogOwnerName) {
        this.dogOwnerName = dogOwnerName;
    }

    public String getDogOwnerAndHandle() {
        return dogOwnerAndHandle;
    }

    public void setDogOwnerAndHandle(String dogOwnerAndHandle) {
        this.dogOwnerAndHandle = dogOwnerAndHandle;
    }

    public String getDogOwnerPinYin() {
        return dogOwnerPinYin;
    }

    public void setDogOwnerPinYin(String dogOwnerPinYin) {
        this.dogOwnerPinYin = dogOwnerPinYin;
    }

    public String getDogOwnerCode() {
        return dogOwnerCode;
    }

    public void setDogOwnerCode(String dogOwnerCode) {
        this.dogOwnerCode = dogOwnerCode;
    }

    public String getDogBreedNameCn() {
        return dogBreedNameCn;
    }

    public void setDogBreedNameCn(String dogBreedNameCn) {
        this.dogBreedNameCn = dogBreedNameCn;
    }

    public String getDogBreedNameEn() {
        return dogBreedNameEn;
    }

    public void setDogBreedNameEn(String dogBreedNameEn) {
        this.dogBreedNameEn = dogBreedNameEn;
    }

    public String getDogBreedCode() {
        return dogBreedCode;
    }

    public void setDogBreedCode(String dogBreedCode) {
        this.dogBreedCode = dogBreedCode;
    }

    public String getDogBreedGroup() {
        return dogBreedGroup;
    }

    public void setDogBreedGroup(String dogBreedGroup) {
        this.dogBreedGroup = dogBreedGroup;
    }

    public String getDogName() {
        return dogName;
    }

    public void setDogName(String dogName) {
        this.dogName = dogName;
    }

    public String getDogGender() {
        return dogGender;
    }

    public void setDogGender(String dogGender) {
        this.dogGender = dogGender;
    }

    public String getDogGeneration() {
        return dogGeneration;
    }

    public void setDogGeneration(String dogGeneration) {
        this.dogGeneration = dogGeneration;
    }

    public Date getDogBirthday() {
        return dogBirthday;
    }

    public void setDogBirthday(Date dogBirthday) {
        this.dogBirthday = dogBirthday;
    }

    public String getDogAgeGroup() {
        return dogAgeGroup;
    }

    public void setDogAgeGroup(String dogAgeGroup) {
        this.dogAgeGroup = dogAgeGroup;
    }

    public String getDogCertificateCode() {
        return dogCertificateCode;
    }

    public void setDogCertificateCode(String dogCertificateCode) {
        this.dogCertificateCode = dogCertificateCode;
    }

    public String getDogCertificateCodeEn() {
        return dogCertificateCodeEn;
    }

    public void setDogCertificateCodeEn(String dogCertificateCodeEn) {
        this.dogCertificateCodeEn = dogCertificateCodeEn;
    }

    public String getDogChip() {
        return dogChip;
    }

    public void setDogChip(String dogChip) {
        this.dogChip = dogChip;
    }

    public String getOther1() {
        return other1;
    }

    public void setOther1(String other1) {
        this.other1 = other1;
    }

    public String getOther2() {
        return other2;
    }

    public void setOther2(String other2) {
        this.other2 = other2;
    }

    public String getDogCertificateF() {
        return dogCertificateF;
    }

    public void setDogCertificateF(String dogCertificateF) {
        this.dogCertificateF = dogCertificateF;
    }

    public String getDogNameF() {
        return dogNameF;
    }

    public void setDogNameF(String dogNameF) {
        this.dogNameF = dogNameF;
    }

    public String getDogCertificateM() {
        return dogCertificateM;
    }

    public void setDogCertificateM(String dogCertificateM) {
        this.dogCertificateM = dogCertificateM;
    }

    public String getDogNameM() {
        return dogNameM;
    }

    public void setDogNameM(String dogNameM) {
        this.dogNameM = dogNameM;
    }

    public String getDogBreeder() {
        return dogBreeder;
    }

    public void setDogBreeder(String dogBreeder) {
        this.dogBreeder = dogBreeder;
    }

    public String getJudge() {
        return judge;
    }

    public void setJudge(String judge) {
        this.judge = judge;
    }

    public String getShowRing() {
        return showRing;
    }

    public void setShowRing(String showRing) {
        this.showRing = showRing;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getDogColorMark() {
        return dogColorMark;
    }

    public void setDogColorMark(String dogColorMark) {
        this.dogColorMark = dogColorMark;
    }
}
