/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import java.util.Date;

/**
 * 赛事播报信息Entity
 * @author lyy
 * @version 2018-01-22
 */
public class ShowReportInfo extends DataEntity<ShowReportInfo> {
	
	private static final long serialVersionUID = 1L;
	private String mainShowId;		// 主赛事id
	private Integer lookCount;
	private String showCode;		// 赛事编号
	private String showName;
	private Date startTime;
	private Date endTime;
	private String judgeId;		// 裁判名称
	private String judgePic;		// 裁判照片
	//裁判2裁判片仅为表单提交使用
	//----------------------------------------
	private String judgeId2;		// 裁判2名称
	private String judgePic2;		// 裁判2照片
	private String judgeId3;		// 裁判3名称
	private String judgePic3;		// 裁判3照片
	//----------------------------------------
	private String bisPic;
	private String bis1Order;		// bis1_order
	private String bis1Pic;		// bis1_pic
	private String bis2Order;		// bis2_order
	private String bis2Pic;		// bis2_pic
	private String bis3Order;		// bis3_order
	private String bis3Pic;		// bis3_pic
	private String bis4Order;		// bis4_order
	private String bis4Pic;		// bis4_pic
	private String jbisPic;
	private String jbis1Order;		// jbis1_order
	private String jbis1Pic;		// jbis1_pic
	private String jbis2Order;		// jbis2_order
	private String jbis2Pic;		// jbis2_pic
	private String jbis3Order;		// jbis3_order
	private String jbis3Pic;		// jbis3_pic
	private String jbis4Order;		// jbis4_order
	private String jbis4Pic;		// jbis4_pic
	private String pbisPic;
	private String pbis1Order;		// pbis1_order
	private String pbis1Pic;		// pbis1_pic
	private String pbis2Order;		// pbis2_order
	private String pbis2Pic;		// pbis2_pic
	private String pbis3Order;		// pbis3_order
	private String pbis3Pic;		// pbis3_pic
	private String pbis4Order;		// pbis4_order
	private String pbis4Pic;		// pbis4_pic
	private String bbisPic;
	private String bbis1Order;		// bbis1_order
	private String bbis1Pic;		// bbis1_pic
	private String bbis2Order;		// bbis2_order
	private String bbis2Pic;		// bbis2_pic
	private String bbis3Order;		// bbis3_order
	private String bbis3Pic;		// bbis3_pic
	private String bbis4Order;		// bbis4_order
	private String bbis4Pic;		// bbis4_pic
	
	private String bis1PedigreeCertified;	
	
	
	public String getBis1PedigreeCertified() {
		return bis1PedigreeCertified;
	}

	public void setBis1PedigreeCertified(String bis1PedigreeCertified) {
		this.bis1PedigreeCertified = bis1PedigreeCertified;
	}

	public ShowReportInfo() {
		super();
	}

	public ShowReportInfo(String id){
		super(id);
	}
	public ShowReportInfo(String id,String showCode,String showName,Date startTime,Date endTime){
		this.id = id;
		this.showCode = showCode;
		this.showName = showName;
		this.startTime = startTime;
		this.endTime = endTime;
	};
	@Length(min=0, max=64, message="主赛事id长度必须介于 0 和 64 之间")
	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}
	
	@Length(min=0, max=100, message="赛事编号长度必须介于 0 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}


	public String getJudgeId() {
		return judgeId;
	}

	public void setJudgeId(String judgeId) {
		this.judgeId = judgeId;
	}

	public String getBisPic() {
		return bisPic;
	}

	public void setBisPic(String bisPic) {
		this.bisPic = bisPic;
	}

	public String getJbisPic() {
		return jbisPic;
	}

	public void setJbisPic(String jbisPic) {
		this.jbisPic = jbisPic;
	}

	public String getPbisPic() {
		return pbisPic;
	}

	public void setPbisPic(String pbisPic) {
		this.pbisPic = pbisPic;
	}

	public String getBbisPic() {
		return bbisPic;
	}

	public void setBbisPic(String bbisPic) {
		this.bbisPic = bbisPic;
	}

	@Length(min=0, max=100, message="裁判照片长度必须介于 0 和 100 之间")
	public String getJudgePic() {
		return judgePic;
	}

	public void setJudgePic(String judgePic) {
		this.judgePic = judgePic;
	}

	public String getJudgeId2() {
		return judgeId2;
	}

	public void setJudgeId2(String judgeId2) {
		this.judgeId2 = judgeId2;
	}

	public String getJudgeId3() {
		return judgeId3;
	}

	public void setJudgeId3(String judgeId3) {
		this.judgeId3 = judgeId3;
	}

	public String getJudgePic2() {
		return judgePic2;
	}

	public void setJudgePic2(String judgePic2) {
		this.judgePic2 = judgePic2;
	}

	public String getJudgePic3() {
		return judgePic3;
	}

	public void setJudgePic3(String judgePic3) {
		this.judgePic3 = judgePic3;
	}

	@Length(min=0, max=10, message="bis1_order长度必须介于 0 和 10 之间")
	public String getBis1Order() {
		return bis1Order;
	}

	public void setBis1Order(String bis1Order) {
		this.bis1Order = bis1Order;
	}
	
	@Length(min=0, max=100, message="bis1_pic长度必须介于 0 和 100 之间")
	public String getBis1Pic() {
		return bis1Pic;
	}

	public void setBis1Pic(String bis1Pic) {
		this.bis1Pic = bis1Pic;
	}
	
	@Length(min=0, max=10, message="bis2_order长度必须介于 0 和 10 之间")
	public String getBis2Order() {
		return bis2Order;
	}

	public void setBis2Order(String bis2Order) {
		this.bis2Order = bis2Order;
	}
	
	@Length(min=0, max=100, message="bis2_pic长度必须介于 0 和 100 之间")
	public String getBis2Pic() {
		return bis2Pic;
	}

	public void setBis2Pic(String bis2Pic) {
		this.bis2Pic = bis2Pic;
	}
	
	@Length(min=0, max=10, message="bis3_order长度必须介于 0 和 10 之间")
	public String getBis3Order() {
		return bis3Order;
	}

	public void setBis3Order(String bis3Order) {
		this.bis3Order = bis3Order;
	}
	
	@Length(min=0, max=100, message="bis3_pic长度必须介于 0 和 100 之间")
	public String getBis3Pic() {
		return bis3Pic;
	}

	public void setBis3Pic(String bis3Pic) {
		this.bis3Pic = bis3Pic;
	}
	
	@Length(min=0, max=10, message="bis4_order长度必须介于 0 和 10 之间")
	public String getBis4Order() {
		return bis4Order;
	}

	public void setBis4Order(String bis4Order) {
		this.bis4Order = bis4Order;
	}
	
	@Length(min=0, max=100, message="bis4_pic长度必须介于 0 和 100 之间")
	public String getBis4Pic() {
		return bis4Pic;
	}

	public void setBis4Pic(String bis4Pic) {
		this.bis4Pic = bis4Pic;
	}
	
	@Length(min=0, max=10, message="jbis1_order长度必须介于 0 和 10 之间")
	public String getJbis1Order() {
		return jbis1Order;
	}

	public void setJbis1Order(String jbis1Order) {
		this.jbis1Order = jbis1Order;
	}
	
	@Length(min=0, max=100, message="jbis1_pic长度必须介于 0 和 100 之间")
	public String getJbis1Pic() {
		return jbis1Pic;
	}

	public void setJbis1Pic(String jbis1Pic) {
		this.jbis1Pic = jbis1Pic;
	}
	
	@Length(min=0, max=10, message="jbis2_order长度必须介于 0 和 10 之间")
	public String getJbis2Order() {
		return jbis2Order;
	}

	public void setJbis2Order(String jbis2Order) {
		this.jbis2Order = jbis2Order;
	}
	
	@Length(min=0, max=100, message="jbis2_pic长度必须介于 0 和 100 之间")
	public String getJbis2Pic() {
		return jbis2Pic;
	}

	public void setJbis2Pic(String jbis2Pic) {
		this.jbis2Pic = jbis2Pic;
	}
	
	@Length(min=0, max=10, message="jbis3_order长度必须介于 0 和 10 之间")
	public String getJbis3Order() {
		return jbis3Order;
	}

	public void setJbis3Order(String jbis3Order) {
		this.jbis3Order = jbis3Order;
	}
	
	@Length(min=0, max=100, message="jbis3_pic长度必须介于 0 和 100 之间")
	public String getJbis3Pic() {
		return jbis3Pic;
	}

	public void setJbis3Pic(String jbis3Pic) {
		this.jbis3Pic = jbis3Pic;
	}
	
	@Length(min=0, max=10, message="jbis4_order长度必须介于 0 和 10 之间")
	public String getJbis4Order() {
		return jbis4Order;
	}

	public void setJbis4Order(String jbis4Order) {
		this.jbis4Order = jbis4Order;
	}
	
	@Length(min=0, max=100, message="jbis4_pic长度必须介于 0 和 100 之间")
	public String getJbis4Pic() {
		return jbis4Pic;
	}

	public void setJbis4Pic(String jbis4Pic) {
		this.jbis4Pic = jbis4Pic;
	}
	
	@Length(min=0, max=10, message="pbis1_order长度必须介于 0 和 10 之间")
	public String getPbis1Order() {
		return pbis1Order;
	}

	public void setPbis1Order(String pbis1Order) {
		this.pbis1Order = pbis1Order;
	}
	
	@Length(min=0, max=100, message="pbis1_pic长度必须介于 0 和 100 之间")
	public String getPbis1Pic() {
		return pbis1Pic;
	}

	public void setPbis1Pic(String pbis1Pic) {
		this.pbis1Pic = pbis1Pic;
	}
	
	@Length(min=0, max=10, message="pbis2_order长度必须介于 0 和 10 之间")
	public String getPbis2Order() {
		return pbis2Order;
	}

	public void setPbis2Order(String pbis2Order) {
		this.pbis2Order = pbis2Order;
	}
	
	@Length(min=0, max=100, message="pbis2_pic长度必须介于 0 和 100 之间")
	public String getPbis2Pic() {
		return pbis2Pic;
	}

	public void setPbis2Pic(String pbis2Pic) {
		this.pbis2Pic = pbis2Pic;
	}
	
	@Length(min=0, max=10, message="pbis3_order长度必须介于 0 和 10 之间")
	public String getPbis3Order() {
		return pbis3Order;
	}

	public void setPbis3Order(String pbis3Order) {
		this.pbis3Order = pbis3Order;
	}
	
	@Length(min=0, max=100, message="pbis3_pic长度必须介于 0 和 100 之间")
	public String getPbis3Pic() {
		return pbis3Pic;
	}

	public void setPbis3Pic(String pbis3Pic) {
		this.pbis3Pic = pbis3Pic;
	}
	
	@Length(min=0, max=10, message="pbis4_order长度必须介于 0 和 10 之间")
	public String getPbis4Order() {
		return pbis4Order;
	}

	public void setPbis4Order(String pbis4Order) {
		this.pbis4Order = pbis4Order;
	}
	
	@Length(min=0, max=100, message="pbis4_pic长度必须介于 0 和 100 之间")
	public String getPbis4Pic() {
		return pbis4Pic;
	}

	public void setPbis4Pic(String pbis4Pic) {
		this.pbis4Pic = pbis4Pic;
	}
	
	@Length(min=0, max=10, message="bbis1_order长度必须介于 0 和 10 之间")
	public String getBbis1Order() {
		return bbis1Order;
	}

	public void setBbis1Order(String bbis1Order) {
		this.bbis1Order = bbis1Order;
	}
	
	@Length(min=0, max=100, message="bbis1_pic长度必须介于 0 和 100 之间")
	public String getBbis1Pic() {
		return bbis1Pic;
	}

	public void setBbis1Pic(String bbis1Pic) {
		this.bbis1Pic = bbis1Pic;
	}
	
	@Length(min=0, max=10, message="bbis2_order长度必须介于 0 和 10 之间")
	public String getBbis2Order() {
		return bbis2Order;
	}

	public void setBbis2Order(String bbis2Order) {
		this.bbis2Order = bbis2Order;
	}
	
	@Length(min=0, max=100, message="bbis2_pic长度必须介于 0 和 100 之间")
	public String getBbis2Pic() {
		return bbis2Pic;
	}

	public void setBbis2Pic(String bbis2Pic) {
		this.bbis2Pic = bbis2Pic;
	}
	
	@Length(min=0, max=10, message="bbis3_order长度必须介于 0 和 10 之间")
	public String getBbis3Order() {
		return bbis3Order;
	}

	public void setBbis3Order(String bbis3Order) {
		this.bbis3Order = bbis3Order;
	}
	
	@Length(min=0, max=100, message="bbis3_pic长度必须介于 0 和 100 之间")
	public String getBbis3Pic() {
		return bbis3Pic;
	}

	public void setBbis3Pic(String bbis3Pic) {
		this.bbis3Pic = bbis3Pic;
	}
	
	@Length(min=0, max=10, message="bbis4_order长度必须介于 0 和 10 之间")
	public String getBbis4Order() {
		return bbis4Order;
	}

	public void setBbis4Order(String bbis4Order) {
		this.bbis4Order = bbis4Order;
	}
	
	@Length(min=0, max=100, message="bbis4_pic长度必须介于 0 和 100 之间")
	public String getBbis4Pic() {
		return bbis4Pic;
	}

	public void setBbis4Pic(String bbis4Pic) {
		this.bbis4Pic = bbis4Pic;
	}

	public Integer getLookCount() {
		return lookCount;
	}

	public void setLookCount(Integer lookCount) {
		this.lookCount = lookCount;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}
}