package com.cku.oa.ipaddress.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * ip_black_list映射表Entity
 * @author ip_black_list映射表
 * @version 2019-10-18
 */
public class IpBlackList extends DataEntity<IpBlackList> {
	
	private static final long serialVersionUID = 1L;
	private String ip;		// ip
	private String status;		// 0:禁止 1:开放
	
	public IpBlackList() {
		super();
	}

	public IpBlackList(String id){
		super(id);
	}

	@Length(min=0, max=32, message="ip长度必须介于 0 和 32 之间")
	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}
	
	@Length(min=0, max=1, message="0:禁止 1:开放长度必须介于 0 和 1 之间")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	
}