package com.cku.oa.handler.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.handler.entity.Handler;
import com.cku.oa.handler.service.HandlerService;

/**
 * 在册牵犬师Controller
 * @author 柴雪腾
 * @version 2016-08-26
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handler")
public class HandlerController extends BaseController {

	@Autowired
	private HandlerService handlerService;
	
	@ModelAttribute
	public Handler get(@RequestParam(required=false) String id) {
		Handler entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = handlerService.get(id);
		}
		if (entity == null){
			entity = new Handler();
		}
		return entity;
	}
	
	@RequiresPermissions("handler:handler:view")
	@RequestMapping(value = {"list", ""})
	public String list(Handler handler, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Handler> page = handlerService.findPage(new Page<Handler>(request, response), handler); 
		model.addAttribute("page", page);
		return "oa/handler/handlerList";
	}

	@RequiresPermissions("handler:handler:view")
	@RequestMapping(value = "form")
	public String form(Handler handler, Model model) {
		model.addAttribute("handler", handler);
		return "oa/handler/handlerForm";
	}
	
	@RequiresPermissions("handler:handler:view")
	@RequestMapping(value = "view")
	public String view(Handler handler, Model model) {
		model.addAttribute("handler", handler);
		return "oa/handler/handlerForm";
	}

	@RequiresPermissions("handler:handler:edit")
	@RequestMapping(value = "save")
	public String save(Handler handler, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handler)){
			return form(handler, model);
		}
		handlerService.save(handler);
		addMessage(redirectAttributes, "保存在册牵犬师成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handler/?repage";
	}
	
	@RequiresPermissions("handler:handler:edit")
	@RequestMapping(value = "delete")
	public String delete(Handler handler, RedirectAttributes redirectAttributes) {
		handlerService.delete(handler);
		addMessage(redirectAttributes, "删除在册牵犬师成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handler/?repage";
	}

}