package com.cku.oa.handler.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;
import com.thinkgem.jeesite.common.persistence.DataEntity;

public class RefereeRankingSchem extends DataEntity<RefereeRankingSchem> {
	private static final long serialVersionUID = 1L;
	private String serialNum; // 批次号
	private String year; // 年份
	private String type; // 类型 1:年度 2:季度 3:月
	private String quarter; // 季度
	private String month; // 月
	private String status; // 状态 0:待生成 1:生成中 2:已生成

	private String half; // 半年度
	
	public RefereeRankingSchem() {
		super();
	}

	public RefereeRankingSchem(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "批次号长度必须介于 0 和 64 之间")
	public String getSerialNum() {
		return serialNum;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	@Length(min = 0, max = 64, message = "年份长度必须介于 0 和 64 之间")
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	@Length(min = 0, max = 64, message = "类型 1:年度 2:季度 3:月长度必须介于 0 和 64 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min = 0, max = 64, message = "季度长度必须介于 0 和 64 之间")
	public String getQuarter() {
		return quarter;
	}

	public void setQuarter(String quarter) {
		this.quarter = quarter;
	}

	@Length(min = 0, max = 64, message = "月长度必须介于 0 和 64 之间")
	public String getMonth() {
		return month;
	}

	public void setMonth(String month) {
		this.month = month;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getHalf() {
		return half;
	}

	public void setHalf(String half) {
		this.half = half;
	}
	
	
}
