/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 结业证书Entity
 * @author 柴雪腾
 * @version 2016-08-08
 */
public class HandlerDiploma extends DataEntity<HandlerDiploma> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="id", align=2, sort=1)
	private String id;
	@ExcelField(title="会员号", align=2, sort=8)
	private String memberCode;		// 会员号
	@ExcelField(title="姓名", align=2, sort=2)
	private String name;		// 姓名
	private String nameEn;		// 姓名
	@ExcelField(title="开始时间", align=2, sort=3)
	private Date startDate;		// 开始时间
	@ExcelField(title="结束时间", align=2, sort=4)
	private Date endDate;		// 结束时间
	private String teacher;		// 培训教师
	private String schoolId;		// 学校id
	@ExcelField(title="培训内容", align=2, sort=6)
	private String certificateLevel;		// 证书级别
	@ExcelField(title="结业证书号", align=2, sort=7)
	private String certificateCode;		// 证书编号
	private String reviewer;		// 审核人
	private String paymentMembershipCode;		// 支付人会员号
	private String printState;		// 打印状态
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private Date issueDate;		// 签发时间
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private String proccessState;		// 流程状态
	private Date proccessTime;		// 流程变更的时间
	private String runningNumber;		// 流水号
	private String reviewRemarks;		// 审核的意见
	private String handlerType;       //培训类别
	@ExcelField(title="培训学校名称", align=2, sort=5)
	private String schoolNameCn;       //(导出)学校中文名
	private TrainingInstitution trainingInstitution; //合作培训机构
	private String schoolNameEn; //学校英文名
	private String identificationFlag; // 芯片号
	
	private String issDate;
	
	
	private Member member; //会员表

	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public String getIssDate() {
		return issDate;
	}

	public void setIssDate(String issDate) {
		this.issDate = issDate;
	}

	public String getSchoolNameEn() {
		return schoolNameEn;
	}

	public void setSchoolNameEn(String schoolNameEn) {
		this.schoolNameEn = schoolNameEn;
	}

	public String getId() {
		return super.id;
	}
	
	public void setId(String id) {
		super.id = id;
	}
	public HandlerDiploma() {
		super();
	}

	public HandlerDiploma(String id){
		super(id);
	}

	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=64, message="姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	
	@Length(min=0, max=64, message="培训教师长度必须介于 0 和 64 之间")
	public String getTeacher() {
		return teacher;
	}

	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}
	
	@Length(min=0, max=64, message="学校id长度必须介于 0 和 64 之间")
	public String getSchoolId() {
		return schoolId;
	}

	public void setSchoolId(String schoolId) {
		this.schoolId = schoolId;
	}
	
	@Length(min=0, max=255, message="证书级别长度必须介于 0 和 255 之间")
	public String getCertificateLevel() {
		return certificateLevel;
	}

	public void setCertificateLevel(String certificateLevel) {
		this.certificateLevel = certificateLevel;
	}
	
	@Length(min=0, max=255, message="证书编号长度必须介于 0 和 255 之间")
	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}
	
	@Length(min=0, max=100, message="审核人长度必须介于 0 和 100 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}
	
	@Length(min=0, max=100, message="支付人会员号长度必须介于 0 和 100 之间")
	public String getPaymentMembershipCode() {
		return paymentMembershipCode;
	}

	public void setPaymentMembershipCode(String paymentMembershipCode) {
		this.paymentMembershipCode = paymentMembershipCode;
	}
	
	@Length(min=0, max=20, message="打印状态长度必须介于 0 和 20 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}
	
	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

	public TrainingInstitution getTrainingInstitution() {
		return trainingInstitution;
	}

	public void setTrainingInstitution(TrainingInstitution trainingInstitution) {
		this.trainingInstitution = trainingInstitution;
	}

	public String getHandlerType() {
		return handlerType;
	}

	public void setHandlerType(String handlerType) {
		this.handlerType = handlerType;
	}

	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}
}