
package com.cku.oa.groomer.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerPackage;
import com.cku.oa.groomer.service.GroomerPackageService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;

@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerPackage")
public class GroomerPackageController extends BaseController {

	@Autowired
	private GroomerPackageService groomerPackageService;

	/**
	 * 报名信息
	 * 
	 */
	@RequestMapping(value = { "list", "" })
	public String list(GroomerPackage groomerPackage, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<GroomerPackage> page = groomerPackageService.findPage(new Page<GroomerPackage>(request, response),
				groomerPackage);
		model.addAttribute("page", page);
		return "oa/groomer/groomerPackageList";
	}

	/**
	 * 报名信息导出
	 * 
	 */
	@RequestMapping(value = "export")
	public String export(GroomerPackage groomerPackage, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			groomerPackageService.export(groomerPackage, response);
		} catch (IOException e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息：" + e.getMessage());
			return "oa/groomer/groomerPackageList";
		}
		return null;
	}

	/**
	 * 上传证件照
	 * 
	 */
	@RequestMapping(value = { "toUpImage" })
	public String toUpImage(GroomerPackage groomerPackage, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("groomerPackage", groomerPackageService.get(groomerPackage.getId()));
		return "oa/groomer/groomerPackageToUpImage";
	}

	/**
	 * 保存证件照
	 * 
	 */
	@RequestMapping(value = { "toReImage" })
	@ResponseBody
	public Object toReImage(GroomerPackage groomerPackage, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Map<String, String> map = new HashMap<String, String>();
		if (groomerPackage.getAvatarFile() == null) {
			map.put("rc", "1");
			map.put("msg", "没有上传文件！");
			return map;
		}
		map.put("rc", "0");
		try {
			groomerPackageService.toReImage(groomerPackage);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 成绩管理
	 * 
	 */
	@RequestMapping(value = "grade")
	public String grade(GroomerPackage groomerPackage, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		groomerPackage.setPaymentState("2");
		Page<GroomerPackage> page = groomerPackageService.findPage(new Page<GroomerPackage>(request, response),
				groomerPackage);
		model.addAttribute("page", page);
		return "oa/groomer/groomerPackageGradeList";
	}

	/**
	 * 修改成绩
	 * 
	 */
	@RequestMapping(value = { "saveGrade" })
	public String saveGrade(GroomerPackage groomerPackage, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("groomerPackage", groomerPackageService.get(groomerPackage.getId()));
		return "oa/groomer/groomerPackageSaveGrade";
	}

	/**
	 * 编辑成绩
	 * 
	 */
	@ResponseBody
	@RequestMapping(value = "gradeViewFormEdit")
	public Object gradeViewFormEdit(HttpServletRequest request, Model model) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String id = request.getParameter("id");
		String gradeWrite = request.getParameter("gradeWrite");
		GroomerPackage groomerPackage = groomerPackageService.get(id);
		if (groomerPackage == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "笔试成绩修改失败");
		}
		try {
			groomerPackage.setGrade(gradeWrite);
			groomerPackageService.save(groomerPackage);
			map.put("msg", "保存成功");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 报名信息导出
	 * 
	 */
	@RequestMapping(value = "exportGrade")
	public String exportGrade(GroomerPackage groomerPackage, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			groomerPackage.setPaymentState("2");
			groomerPackageService.exportGrade(groomerPackage, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息：" + e.getMessage());
			return "oa/groomer/groomerPackageList";
		}
		return null;
	}

}