package com.cku.oa.groomer.service;

import java.util.List;

import com.cku.oa.groomer.entity.GroomerExamQuestionBank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.groomer.dao.GroomerExamQuestionBankDao;

/**
 * 美容考试题库相关crudService
 * @author hjx
 * @version 2023-11-23
 */
@Service
@Transactional(readOnly = true)
public class GroomerExamQuestionBankService extends CrudService<GroomerExamQuestionBankDao, GroomerExamQuestionBank> {

	@Autowired
	protected GroomerExamQuestionBankDao groomerExamQuestionBankDao;

	public GroomerExamQuestionBank get(String id) {
		return super.get(id);
	}
	
	public List<GroomerExamQuestionBank> findList(GroomerExamQuestionBank groomerExamQuestionBank) {
		return super.findList(groomerExamQuestionBank);
	}
	
	public Page<GroomerExamQuestionBank> findPage(Page<GroomerExamQuestionBank> page, GroomerExamQuestionBank groomerExamQuestionBank) {
		return super.findPage(page, groomerExamQuestionBank);
	}
	
	@Transactional(readOnly = false)
	public void save(GroomerExamQuestionBank groomerExamQuestionBank) {
		super.save(groomerExamQuestionBank);
	}
	
	@Transactional(readOnly = false)
	public void delete(GroomerExamQuestionBank groomerExamQuestionBank) {
		super.delete(groomerExamQuestionBank);
	}

	public GroomerExamQuestionBank getByCosmetologyCertificateLevelId(GroomerExamQuestionBank groomerExamQuestionBank){
		return groomerExamQuestionBankDao.getByCosmetologyCertificateLevelId(groomerExamQuestionBank);

	}
	
}