/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 美容活动犬种Entity
 * 
 * @author Sunny
 * @version 2021-12-17
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GroomerShowBreeds extends DataEntity<GroomerShowBreeds> {

	private static final long serialVersionUID = 1L;
	private String showType; // 活动类型;美容师：groomer 洗护师：nurse
	private String breedName; // 犬种名称
	private String breedGroup; // 犬种分组
	private String showLevels; // 所属级别;P(primary)，S(senior)，M(match) 逗号分隔
	private String popularFlag; // 是否热门
	private Integer sort; // 排序字段

	private String memberCode;// 会员编号
	private String checkedBreeds;// 已选中犬种
	private String otherBreeds;// 已填写其他犬种
	private boolean registered;// 已报名标识
	private Boolean validate = Boolean.TRUE;// 是否规则验证

}