package com.cku.oa.finance.web;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.SaPaymentDetailTotal;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Calendar;

/**
 * 充值消费明细Controller
 * @author wangjie
 * @version 2019-08-29
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/saPaymentDetailTotal")
public class SaPaymentDetailTotalController extends BaseController {

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@ModelAttribute
	public SaPaymentDetailTotal get(@RequestParam(required=false) String id) {
		SaPaymentDetailTotal entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = saPaymentDetailTotalService.get(id);
		}
		if (entity == null){
			entity = new SaPaymentDetailTotal();
		}
		return entity;
	}

//	@RequiresPermissions("finance:saPaymentDetailTotal:view")
	@RequestMapping(value = {"list", ""})
	public String list(SaPaymentDetailTotal saPaymentDetailTotal, HttpServletRequest request, HttpServletResponse response, Model model) {
		String paymentTimeStart = request.getParameter("paymentTimeStart");
		String paymentTimeEnd = request.getParameter("paymentTimeEnd");

		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if(paymentTimeStart == null || paymentTimeStart.equals("")) {
			paymentTimeStart = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
        }
		if(paymentTimeEnd == null || paymentTimeEnd.equals("")) {
			paymentTimeEnd = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}
		if(StringUtils.isBlank(saPaymentDetailTotal.getPaymentTimeStart()) ){
			saPaymentDetailTotal.setPaymentTimeStart(paymentTimeStart);
		}
		if(StringUtils.isBlank(saPaymentDetailTotal.getPaymentTimeEnd()) ){
			saPaymentDetailTotal.setPaymentTimeStart(paymentTimeEnd);
		}
		Page<SaPaymentDetailTotal> page = saPaymentDetailTotalService.findPage(new Page<SaPaymentDetailTotal>(request, response), saPaymentDetailTotal);
		model.addAttribute("paymentTimeStart", paymentTimeStart);
		model.addAttribute("paymentTimeEnd", paymentTimeEnd);
		model.addAttribute("page", page);
		model.addAttribute("chargingItems",paymentChargingItemService.findAllList(new PaymentChargingItem()));
		return "oa/finance/saPaymentDetailTotalList";
	}

//	@RequiresPermissions("finance:saPaymentDetailTotal:view")
	@RequestMapping(value = "form")
	public String form(SaPaymentDetailTotal saPaymentDetailTotal, Model model) {
		model.addAttribute("saPaymentDetailTotal", saPaymentDetailTotal);
		return "oa/finance/saPaymentDetailTotalForm";
	}

	@RequestMapping(value = "export")
	public String export(SaPaymentDetailTotal saPaymentDetailTotal, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			saPaymentDetailTotalService.export(saPaymentDetailTotal,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出资格收支明细失败！失败信息："+e.getMessage());
		}
		return null;
	}

//	@RequiresPermissions("finance:saPaymentDetailTotal:edit")
	@RequestMapping(value = "save")
	public String save(SaPaymentDetailTotal saPaymentDetailTotal, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, saPaymentDetailTotal)){
			return form(saPaymentDetailTotal, model);
		}
		saPaymentDetailTotalService.save(saPaymentDetailTotal);
		addMessage(redirectAttributes, "保存充值消费明细成功");
		return "redirect:"+Global.getAdminPath()+"/finance/saPaymentDetailTotal/?repage";
	}

//	@RequiresPermissions("finance:saPaymentDetailTotal:edit")
	@RequestMapping(value = "delete")
	public String delete(SaPaymentDetailTotal saPaymentDetailTotal, RedirectAttributes redirectAttributes) {
		saPaymentDetailTotalService.delete(saPaymentDetailTotal);
		addMessage(redirectAttributes, "删除充值消费明细成功");
		return "redirect:"+Global.getAdminPath()+"/finance/saPaymentDetailTotal/?repage";
	}

}