
package com.cku.oa.finance.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogActivationDao;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogFrozenSemenService;
import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.SaFinanceSubjectMapping;
import com.cku.oa.finance.vo.PaymentCartVO;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.coupon.vo.SysCouponEntityVO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.finance.service.DogChipDeleteService;
import com.cku.restful.v1.finance.service.DogNewbornDeleteService;
import com.cku.restful.v1.finance.service.KennelRegisterDeleteService;
import com.cku.restful.v1.finance.vo.PriceVO;
import com.cku.restful.v1.finance.vo.SysCouponVO;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.netty.util.internal.StringUtil;

@Service
@Transactional(readOnly = true)
public class PaymentCartService {
	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;
	@Autowired
	private SaFinanceSubjectMappingService saFinanceSubjectMappingService;

	private Logger logger = LoggerFactory.getLogger(PaymentCartService.class);

	@Autowired
	private PaymentCartDao paymentCartDao;
	@Autowired
	private KennelRegisterDeleteService kennelRegisterDeleteService;
	@Autowired
	private DogChipDeleteService dogChipDeleteService;
	@Autowired
	private DogNewbornDeleteService dogNewbornDeleteService;
	@Autowired
	private DogFrozenSemenService dogFrozenSemenService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private DogActivationDao dogActivationDao;
	@Autowired
	private DogBirthCertificateDao dogbirthcertificatedao;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private DogAppraisalDao dogAppraisalDao;
	// @Autowired
	// private MemberService memberService;
	@Autowired
	private MemberDao memberDao;
	public static final List<String> memberdogDepts = Arrays
			.asList(new String[] { "b6aed90fa186432aa16ad45a66410e75", "9df34d25aebc4ceaa7e326acb296c614" });// 用户管理部档案管理部
	public static final List<String> groomerDepts = Arrays.asList(new String[] { "eaaaaeff90f34d68a2f704f6ba246911" });// 美容部
	
	public List<PaymentCart> findAll() {
		PaymentCart cart = new PaymentCart();
		return paymentCartDao.findAllList(cart);
	}

	/**
	 * 在我的购物车添加一条购物信息
	 *
	 * @param paymentCart
	 */
	@Transactional(readOnly = false)
	public void addToCart(PaymentCart paymentCart, String businessId) {
		addToCart(paymentCart, true, businessId);
	}

	public void addToCart(PaymentCart paymentCart, boolean checkActive, String businessId) {
		if (StringUtil.isNullOrEmpty(businessId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, businessId + "业务名字不存在");
		}
		SaFinanceSubjectMapping bizId = saFinanceSubjectMappingService.get(businessId);

		if (bizId == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, businessId + "业务名字不存在");
		}
		Member member = UserUtils.getLoginMember();
		String memberCode = member.getMemberCode();
		paymentCart.setMemberCode(memberCode);
		paymentCart.setMemberName(member.getName());
		paymentCart.preInsert();
		paymentCart.setAddTime(new Date());
		paymentCart.setBusinessId(businessId);
		paymentCart.setBusinessName(bizId.getSubjectName());
		paymentCart.setBusinessRefund(bizId.getBusinessRefund());
		if (StringUtils.isBlank(paymentCart.getCouponNum())) {
			paymentCart.setCouponNum("0");
		}
		paymentCart.preInsert();
		paymentCartDao.insert(paymentCart);
	}

	/**
	 * 查询我的购物车
	 */
	public List<PaymentCart> getMyCart() {
		return getMyCart(true);
	}

	public List<PaymentCart> getCooperatorCart(boolean checkActive) {
		PartnerLoginUserInfo info = UserUtils.getLoginPartner();
		String memberCode = info.getMemberCode();
		//// if (checkActive) {
		// if (!MemberUtil.isActiveMember(member) || memberCode == null) {
		// throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "请确认会员是激活状态的会员");
		// }
		// }
		PaymentCart cart = new PaymentCart();
		cart.setMemberCode(memberCode);
		List<PaymentCart> carts = paymentCartDao.findList(cart);
		return carts;
	}

	// public List<PaymentCart> getClubCart(boolean checkActive,Member clubmember) {
	// Member member = null;
	// if(clubmember != null) {
	// member = clubmember;
	// }else {
	// member = UserUtils.getLoginMember();
	// String memberCode = member.getMemberCode();
	// if (checkActive) {
	// if (!MemberUtil.isActiveMember(member) || memberCode == null) {
	// throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "请确认会员是激活状态的会员");
	// }
	// }
	// }
	// PaymentCart cart = new PaymentCart();
	// cart.setMemberCode(member.getMemberCode());
	// List<PaymentCart> carts = paymentCartDao.findList(cart);
	// return carts;
	// }

	public List<PaymentCart> getMyCart(boolean checkActive) {
		Member member = UserUtils.getLoginMember();
		String memberCode = member.getMemberCode();
		if (checkActive) {
			if (!MemberUtil.isActiveMember(member) || memberCode == null) {
				throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "请确认会员是激活状态的会员");
			}
		}
		PaymentCart cart = new PaymentCart();
		cart.setMemberCode(member.getMemberCode());
		List<PaymentCart> carts = paymentCartDao.findList(cart);
		return carts;
	}

	/**
	 * 从购物车中移除一条信息 1.删除购物车的一个物品，会删除业务id相同的其他商品 2.删除购物车的一个物品，会同时删除业务表的数据 3.boolean
	 * delBusiness 是否删除业务表数据
	 */
	@Transactional(readOnly = false)
	public void removeCart(String paymentCartId, boolean delBusiness) {
		PaymentCart cart = new PaymentCart();
		cart.setId(paymentCartId);
		cart = paymentCartDao.get(cart);
		if (cart != null) {
			String tableName = cart.getBusinessTable();
			String businessIds = cart.getBusinessIds();
			// 新生犬业务根据业务号查询出来的相关购物车列表
			if (isDogChipBusiness(tableName)) {
				if (StringUtils.isBlank(cart.getBusinessOrderCode())) {
					// 旧数据用原来的方式删除
					paymentCartDao.deleteByBusinessId(cart);
				} else {
					// 新生犬业务根据业务号,先查出来以便删除业务表，然后再删除购物车
					paymentCartDao.deleteByBusinessOrderCode(cart);
				}
			} else if ("sys_member".equals(tableName)) {
				// 解决会员表相关业务业务id都为会员号，会被同时删除的bug
				if (StringUtils.isBlank(cart.getBusinessOrderCode())) {
					// 旧数据用原来的方式删除
					paymentCartDao.deleteByBusinessId(cart);
				} else {
					// 新数据用BusinessOrderCode进行删除
					paymentCartDao.deleteByBusinessOrderCode(cart);
				}
			} else if ("kennel".equals(tableName)) {
				// 解决犬舍相关业务业务id都为会员号，会被同时删除的bug
				if (StringUtils.isBlank(cart.getBusinessOrderCode())) {
					// 旧数据用原来的方式删除
					paymentCartDao.deleteByBusinessId(cart);
				} else {
					// 新数据用BusinessOrderCode进行删除
					paymentCartDao.deleteByBusinessOrderCode(cart);
				}
			} else if ("kennel_rename".equals(tableName)) {
				// 解决犬舍相关业务业务id都为会员号，会被同时删除的bug
				if (StringUtils.isBlank(cart.getBusinessOrderCode())) {
					// 旧数据用原来的方式删除
					paymentCartDao.deleteByBusinessId(cart);
				} else {
					// 新数据用BusinessOrderCode进行删除
					paymentCartDao.deleteByBusinessOrderCode(cart);
				}
			} else if ("dog_birth_certificate".equals(tableName)) {
				// 解决犬舍相关业务业务id都为会员号，会被同时删除的bug
				if (StringUtils.isBlank(cart.getBusinessOrderCode())) {
					// 旧数据用原来的方式删除
					paymentCartDao.deleteByBusinessId(cart);
				} else {
					// 新数据用BusinessOrderCode进行删除
					paymentCartDao.deleteByBusinessOrderCode(cart);
				}
			} else {
				paymentCartDao.deleteByBusinessId(cart);
			}

			// 删除业务数据
			if (delBusiness) {
				// 白名单删除
				if (StringUtils.isNotBlank(tableName)) {
					if ("dog_birth_certificate".equals(tableName) || "sys_coupon".equals(tableName)) {
						// 出生证明表根据配种证明号进行删除
						paymentCartDao.deleteDogBirthCertificate(businessIds);
						paymentCartDao.clearCouponItem(tableName, businessIds);
					} else if (tableName.startsWith("sys")) {
						// 会员业务一般是缴费
						// 绝对不能随便删除会员
					} else if (tableName.startsWith("groomer")) {
						// 美容只有报名能删除
						if (tableName.equals("groomer_register")) {
							paymentCartDao.deleteCartItem(tableName, businessIds);
						}
					} else if (tableName.startsWith("handler")) {
						// 牵犬师只有报名能删除
						if (tableName.equals("handler_register")) {
							paymentCartDao.deleteCartItem(tableName, businessIds);
						}
					} else if (tableName.trim().equals("show_apply") || tableName.equals("show_champion_login")) {
						// 赛事报名与冠军登录可删除
						if (businessIds.indexOf("#") != -1) {
							// 更新参赛券标记位
							String id = businessIds.split("#")[0];
							String pedigreeCertified = businessIds.split("#")[1];
							// paymentCartDao.deleteCartShowItem(tableName, id);
							paymentCartDao.deleteCartItem(tableName, id);
							paymentCartDao.clearCouponShowItem(tableName, businessIds, pedigreeCertified);
						} else {
							// 冠军登录可删除
							paymentCartDao.deleteCartItem(tableName, businessIds);
						}
					} else if (tableName.equals("dog_pedigree_certified_redo")
							|| tableName.equals("dog_pedigree_certified_change")
							|| tableName.equals("dog_pedigree_certified_export") || tableName.equals("dog_owner_change")
							|| tableName.equals("dog_appraisal") || tableName.equals("dog_tibetan_mastiff")) {
						// 这些繁殖业务是允许删除数据的
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (isDogChipBusiness(tableName)) {
						// 血统证书业务删除购物车的时候需要清空登记卡的addUser字段
						dogChipDeleteService.deleteCartDogBirthCertificateAddUser(tableName, businessIds);
					} else if (tableName.equals("dog_newborn")) {// 配种证明
						// 清除精子信息中的配种证明号
						dogNewbornDeleteService.clearDogSemen(businessIds);
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (tableName.equals("dog_frozen_semen")) {// 种犬申报报备
						// 删除犬只精子相关记录
						dogFrozenSemenService.deleteDogSemen(businessIds);
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (tableName.equals("dog_semen_change")) {// 种犬精子变更
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (tableName.equals("kennel_rename")) {// 犬舍名称变更业务删除
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (tableName.equals("dog_sticker_apply")) {// 犬只等级贴纸申请
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else if (tableName.equals("kennel")) {
						// 购物车删除犬舍注册记录时，同时把犬舍信息也删除
						kennelRegisterDeleteService.deleteKennelRegister(businessIds);
					} else if (tableName.equals("dog_activation")) {
						// 订单俱乐部超时激活信息时、删除超时激活记录
						dogActivationService.deleteById(businessIds);
						DogActivation dogActivation = dogActivationDao.get(businessIds);
						DogBirthCertificate certificate = dogbirthcertificatedao
								.getByBirthCerRegCode(dogActivation.getBirthCode());
						if (StringUtils.isNotBlank(certificate.getActivitionState())
								&& "3".equals(certificate.getActivitionState())) {
							dogbirthcertificatedao.updateActivationStates(certificate.getBirthCerRegCode(), null);
						}
					} else if (tableName.equals("dog_appraisal")) {
						dogAppraisalDao.updateVideoById(businessIds);
					} else if(tableName.equals("kennel_owner_change")) {
						paymentCartDao.deleteCartItem(tableName, businessIds);
					} else {
						// 其他未知的表也不允许删除
					}
				}
			}

		}
	}

	/**
	 * @description: 判断是否是新生犬登记业务，返回true表示是
	 * @author: laiguanglong
	 * @date: 2016/11/29 9:43
	 */
	private boolean isDogChipBusiness(String tableName) {
		boolean flag = false;
		if (tableName.equals("dog_chip") || tableName.equals("dog_blood_save") || tableName.equals("dog_dna_archive")
				|| tableName.equals("dog_dna_parents_compare")) {
			flag = true;
		}
		return flag;
	}

	public List<PaymentCartVO> findListByIds(List<String> ids, String memberCode) {
		return paymentCartDao.findListByIds(ids, memberCode);
	}

	public PriceVO totalPricseClub(List<String> ids, String couponId) {
		PriceVO pricceVO = new PriceVO();
		if (ids != null && ids.size() > 0) {

			List<PaymentCartVO> cartsT = null;
			cartsT = findListByIds(ids, UserUtils.getLoginPartner().getMemberCode());
			// 计算优惠前金额
			Double p = cartsT.stream().mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 券前价格
			pricceVO.setTotalPricePre(p);
			if (StringUtils.isNotEmpty(couponId)) {
				// 获得可用券列表
				Map<String, List> map = getclubCoupons(ids);
				List<SysCouponVO> availableList = map.get("availableList");
				// 判断传入的券ID是不是可用券
				List<String> cids = availableList.stream().map(a -> a.getId()).collect(Collectors.toList());
				if (!cids.contains(couponId)) {
					throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "此券不可用");
				}
				// 计算应优惠的金额 分别计算memberdog、groomer类业务优惠前金额是多少
				SysCouponVO c = availableList.stream().filter(a -> couponId.equals(a.getId()))
						.collect(Collectors.toList()).get(0);

				// 该券是美容券还是会员犬舍券
				List<String> depts = "memberdog".equals(c.getTarget()) ? memberdogDepts
						: "groomer".equals(c.getTarget()) ? groomerDepts : new ArrayList();

				Double kyP = cartsT.stream()
						.filter(a -> depts.contains(a.getDept()) || "dog_video_appraisal".equals(a.getBusinessTable()))
						.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用优惠券的一共多少钱
				// 计算可以减免多少钱
				if (kyP - Double.parseDouble(c.getFacePrice()) > 0) {// 计算后总价不能小于0
					pricceVO.setCouponPrice(Double.parseDouble(c.getFacePrice()));
				} else {
					pricceVO.setCouponPrice(kyP);
				}
			}
		}
		pricceVO.setTotalPrice(pricceVO.getTotalPricePre() - pricceVO.getCouponPrice());

		return pricceVO;

	}

	/**
	 * 两种抵扣券，只能分别抵扣美容/会员犬舍，不能夸业务种类抵扣
	 *
	 * @param ids
	 * @param couponId
	 * @return
	 */
	public PriceVO totalPrice(List<String> ids, String couponId) {
		PriceVO pricceVO = new PriceVO();
		if (ids != null && ids.size() > 0) {

			List<PaymentCartVO> cartsT = findListByIds(ids, UserUtils.getLoginMember().getMemberCode());

			// 计算优惠前金额
			Double p = cartsT.stream().mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 券前价格
			pricceVO.setTotalPricePre(p);
			if (StringUtils.isNotEmpty(couponId)) {
				// 获得可用券列表
				Map<String, List> map = getcoupons(ids);
				List<SysCouponVO> availableList = map.get("availableList");
				// 判断传入的券ID是不是可用券
				List<String> cids = availableList.stream().map(a -> a.getId()).collect(Collectors.toList());
				if (!cids.contains(couponId)) {
					throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "此券不可用");
				}
				// 计算应优惠的金额 分别计算memberdog、groomer类业务优惠前金额是多少
				SysCouponVO c = availableList.stream().filter(a -> couponId.equals(a.getId()))
						.collect(Collectors.toList()).get(0);

				// 该券是美容券还是会员犬舍券
				List<String> depts = "memberdog".equals(c.getTarget()) ? memberdogDepts
						: "groomer".equals(c.getTarget()) ? groomerDepts : new ArrayList();
				Double kyP = cartsT.stream().filter(a -> depts.contains(a.getDept()))
						.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用优惠券的一共多少钱
				// 计算可以减免多少钱
				if (kyP - Double.parseDouble(c.getFacePrice()) > 0) {// 计算后总价不能小于0
					pricceVO.setCouponPrice(Double.parseDouble(c.getFacePrice()));
				} else {
					pricceVO.setCouponPrice(kyP);
				}
			}
		}
		pricceVO.setTotalPrice(pricceVO.getTotalPricePre() - pricceVO.getCouponPrice());

		return pricceVO;

	}

	public String addToCartFCoupon(PaymentCart paymentCart) {
		Member member = UserUtils.getLoginMember();
		String memberCode = member.getMemberCode();
		paymentCart.setMemberCode(memberCode);
		paymentCart.setMemberName(member.getName());
		paymentCart.preInsert();
		paymentCart.setAddTime(new Date());
		if (StringUtils.isBlank(paymentCart.getCouponNum())) {
			paymentCart.setCouponNum("0");
		}
		paymentCart.preInsert();
		paymentCartDao.insert(paymentCart);
		return paymentCart.getId();
	}

	public String addToClubCartFCoupon(PaymentCart paymentCart) {

		String memberCode = UserUtils.getLoginPartner().getMemberCode();
		Member member = memberDao.getByMemberCode(memberCode);
		paymentCart.setMemberCode(memberCode);
		paymentCart.setMemberName(member.getName());
		paymentCart.preInsert();
		paymentCart.setAddTime(new Date());
		if (StringUtils.isBlank(paymentCart.getCouponNum())) {
			paymentCart.setCouponNum("0");
		}
		paymentCart.preInsert();
		paymentCartDao.insert(paymentCart);
		return paymentCart.getId();
	}

	public Map<String, List> getclubCoupons(List<String> ids) {

		List<SysCouponEntityVO> sysCouponsT = sysCouponService
				.findAvailableListCouponList(UserUtils.getLoginPartner().getMemberCode());

		List<SysCouponVO> sysCoupons = sysCouponsT.stream().map(a -> {
			SysCouponVO v = new SysCouponVO();
			BeanUtils.copyProperties(a, v);
			String couponTypeDesc = "1".equals(a.getCouponType()) ? "代金券"
					: "2".equals(a.getCouponType()) ? "抵扣券" : "3".equals(a.getCouponType()) ? "参展券" : "优惠券";
			v.setCouponTypeDesc(couponTypeDesc);
			return v;
		}).collect(Collectors.toList());
		// 区分可用不可用
		Map<String, List> coupons = new HashMap<>();
		List<SysCouponVO> availableListT = new ArrayList<>();
		if (ids != null && ids.size() > 0) {
			List<PaymentCartVO> carts = findListByIds(ids, UserUtils.getLoginPartner().getMemberCode());
			// 查询是否有适合用新券的收费项
			Double p = carts.stream().filter(a -> memberdogDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用memberdog类型优惠券
			Double p2 = carts.stream().filter(a -> groomerDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用groomer类型优惠券
			Double p3 = carts.stream().filter(a -> "dog_video_appraisal".equals(a.getBusinessTable()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用dogvideo类型优惠券
			availableListT = sysCoupons.stream().filter(a -> {
				return (p > 0 && "memberdog".equals(a.getTarget()) || p2 > 0 && "groomer".equals(a.getTarget())
						|| p3 > 0 && "dogvideo".equals(a.getTarget())) && a.getYx();
			}).collect(Collectors.toList());// 可用优惠券
		}
		sysCoupons.removeAll(availableListT);// sysCoupons 剩下的部分 // 不可用优惠券
		coupons.put("availableList", availableListT);
		coupons.put("unavailableList", sysCoupons);
		return coupons;
	}

	/**
	 * 根据购物车ID得到可用券列表
	 *
	 *
	 *
	 * @param ids
	 * @return
	 */
	public Map<String, List> getcoupons(List<String> ids) {

		List<SysCouponEntityVO> sysCouponsT = sysCouponService
				.findAvailableListCouponList(UserUtils.getLoginMember().getMemberCode());

		List<SysCouponVO> sysCoupons = sysCouponsT.stream().map(a -> {
			SysCouponVO v = new SysCouponVO();
			BeanUtils.copyProperties(a, v);
			String couponTypeDesc = "1".equals(a.getCouponType()) ? "代金券"
					: "2".equals(a.getCouponType()) ? "抵扣券" : "3".equals(a.getCouponType()) ? "参展券" : "优惠券";
			v.setCouponTypeDesc(couponTypeDesc);
			return v;
		}).collect(Collectors.toList());
		// 区分可用不可用
		Map<String, List> coupons = new HashMap<>();
		List<SysCouponVO> availableListT = new ArrayList<>();
		if (ids != null && ids.size() > 0) {
			List<PaymentCartVO> carts = findListByIds(ids, UserUtils.getLoginMember().getMemberCode());
			// 查询是否有适合用新券的收费项
			Double p = carts.stream().filter(a -> memberdogDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用memberdog类型优惠券
			Double p2 = carts.stream().filter(a -> groomerDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用groomer类型优惠券
			availableListT = sysCoupons.stream().filter(a -> {
				return (p > 0 && "memberdog".equals(a.getTarget()) || p2 > 0 && "groomer".equals(a.getTarget()))
						&& a.getYx();
			}).collect(Collectors.toList());// 可用优惠券
		}
		sysCoupons.removeAll(availableListT);// sysCoupons 剩下的部分 // 不可用优惠券
		coupons.put("availableList", availableListT);
		coupons.put("unavailableList", sysCoupons);
		return coupons;
	}

	public Map<String, List> getClubCoupons(List<String> ids) {

		List<SysCouponEntityVO> sysCouponsT = sysCouponService
				.findAvailableListCouponList(UserUtils.getLoginPartner().getMemberCode());

		List<SysCouponVO> sysCoupons = sysCouponsT.stream().map(a -> {
			SysCouponVO v = new SysCouponVO();
			BeanUtils.copyProperties(a, v);
			String couponTypeDesc = "1".equals(a.getCouponType()) ? "代金券"
					: "2".equals(a.getCouponType()) ? "抵扣券" : "3".equals(a.getCouponType()) ? "参展券" : "优惠券";
			v.setCouponTypeDesc(couponTypeDesc);
			return v;
		}).collect(Collectors.toList());
		// 区分可用不可用
		Map<String, List> coupons = new HashMap<>();
		List<SysCouponVO> availableListT = new ArrayList<>();
		if (ids != null && ids.size() > 0) {
			List<PaymentCartVO> carts = findListByIds(ids, UserUtils.getLoginPartner().getMemberCode());
			// 查询是否有适合用新券的收费项
			Double p = carts.stream().filter(a -> memberdogDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用memberdog类型优惠券
			Double p2 = carts.stream().filter(a -> groomerDepts.contains(a.getDept()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用groomer类型优惠券
			Double p3 = carts.stream().filter(a -> "dog_video_appraisal".equals(a.getBusinessTable()))
					.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();// 可用dogvideo类型优惠券

			availableListT = sysCoupons.stream().filter(a -> {
				return (p > 0 && "memberdog".equals(a.getTarget()) || p2 > 0 && "groomer".equals(a.getTarget())
						|| p3 > 0 && "dogvideo".equals(a.getTarget())) && a.getYx();
			}).collect(Collectors.toList());// 可用优惠券
		}
		sysCoupons.removeAll(availableListT);// sysCoupons 剩下的部分 // 不可用优惠券
		coupons.put("availableList", availableListT);
		coupons.put("unavailableList", sysCoupons);
		return coupons;
	}

	/**
	 * 根据业务序号 查找 业务信息添加到购物车
	 *
	 * @param pc
	 *            购物车 单个收费项
	 * @param id
	 *            所属业务序号
	 * @return
	 */
	public PaymentCart addBusinessManage(PaymentCart pc, String id) {
		if (pc == null) {
			return pc;
		}
		if (StringUtil.isNullOrEmpty(id)) {
			logger.info("购物车收费项所属业务id为空");
			// 没有id不能加入购物车
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, id + "业务名字不存在");
			// return pc;
		}
		// PaymentChargingItemGroup pcig = paymentChargingItemGroupService.get(id);
		// 修改为使用映射表 by GYH
		SaFinanceSubjectMapping bizId = saFinanceSubjectMappingService.get(id);

		if (bizId == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, id + "业务名字不存在");
		pc.setBusinessName(bizId.getSubjectName());
		pc.setBusinessId(bizId.getId());
		pc.setBusinessRefund(bizId.getBusinessRefund());
		return pc;
	}

	@Transactional(readOnly = false)
	public void addToCartByClub(PaymentCart paymentCart, String businessId, String clubCode) {
		addToCartClub(paymentCart, true, businessId, clubCode);
	}

	public void addToCartClub(PaymentCart paymentCart, boolean checkActive, String businessId, String clubCode) {
		if (StringUtil.isNullOrEmpty(businessId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, businessId + "业务名字不存在");
		}
		SaFinanceSubjectMapping bizId = saFinanceSubjectMappingService.get(businessId);

		if (bizId == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, businessId + "业务名字不存在");
		}

		paymentCart.setMemberCode(UserUtils.getLoginPartner().getMemberCode());
		paymentCart.setMemberName(UserUtils.getLoginPartner().getName());
		paymentCart.preInsert();
		paymentCart.setAddTime(new Date());
		paymentCart.setBusinessId(businessId);
		paymentCart.setBusinessName(bizId.getSubjectName());
		paymentCart.setBusinessRefund(bizId.getBusinessRefund());
		if (StringUtils.isBlank(paymentCart.getCouponNum())) {
			paymentCart.setCouponNum("0");
		}
		paymentCart.preInsert();
		paymentCartDao.insert(paymentCart);
	}
}
