/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import java.util.Date;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 退费记录Entity
 * @author Sunny
 * @version 2021-06-17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PaymentOrderRefund extends DataEntity<PaymentOrderRefund> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title = "序号",align = 2, sort = 1)
	private String index;		// 序号
	@ExcelField(title = "会员号",align = 2, sort = 3)
	private String memberCode;		// 会员号
	@ExcelField(title = "会员姓名",align = 2, sort = 2)
	private String memberName;		// 会员名称
	@ExcelField(title = "犬舍名称",align = 2, sort = 4)
	private String kennelName;		// 犬舍名称
	@ExcelField(title = "订单编号",align = 2, sort = 5)
	private String orderCode;		// 订单编号
	private String refundOrderCode;		// 退单订单编号
	@ExcelField(title = "订单金额",align = 2, sort = 6)
	private String totalPrice;		// 总价
	private Boolean partRefundFlag;		// 部分退费标识 0:否 1：是
	@ExcelField(title = "退费金额",align = 2, sort = 7)
	private String partRefundPrice;		// 部分退费金额
	private String chargingItemId;		// 收费项目
	private String chargingItemName;		// 收费项目名称
	@ExcelField(title = "备注",align = 2, sort = 8)
	private String refundRemark;		// 退款备注
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String processState;		// 处理状态
	private Date processTime;		// 处理时间
	private String processPerson;		// 退款操作人

}