/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

/**
 * 会员支付流水DAO接口
 * @author lyy
 * @version 2016-07-18
 */
@MyBatisDao
public interface PaymentRecordDao extends CrudDao<PaymentRecord> {
    int changePaymentState(@Param("sql") String sql);
    int newRecord(PaymentRecord paymentRecord);
    PaymentRecord getByRunningNumber(@Param("runningNumber")String runningNumber);
	List<PaymentRecord> getByRunningNumberAndItemId(@Param("runningNumber")String runningNumber,@Param("itemId")String itemId);

	/**
	 * 查询指定时间范围，指定收费项的流水
	 * @param chargeItemId 收费项ID
	 * @return
	 * @author fanhuibin
	 */
	public List<PaymentRecord> findRecordByChargeItem(@Param("chargeItemId") String chargeItemId,@Param("startDate")String startDate,@Param("endDate")String endDate);

	public HashMap findRecordByChargeItemCount(@Param("chargeItemId") String chargeItemId, @Param("startDate")String startDate, @Param("endDate")String endDate);
	/**
	 * 查询oa扣费的流水
	 * @return
	 * @author fanhuibin
	 */
	public List<PaymentRecord> findRecordByOaCharge(@Param("startDate")String startDate,@Param("endDate")String endDate);

	/**
	 * 删除调整后的数据
	 * @param detailList
	 * @return
	 */
	Integer deleteAdjustment(List<PaymentOrderDetail> detailList);
	/**
	 * 还原调整前的数据
	 * @param detailList
	 * @return
	 */
	Integer restoreAdjustment(List<PaymentOrderDetail> detailList);

	/**
	 * 查询原纪录
	 * @param record
	 * @return
	 */
	PaymentRecord findAdjustmentData(PaymentRecord record);

	/**
	 * 批量插入新记录
	 * @param recordList
	 * @return
	 */
	Integer insertBatch(List<PaymentRecord> recordList);

	Integer updateById(PaymentRecord record);


	List<PaymentRecord> findListCost(PaymentRecord record);
	
	
	
	String getRealMemberByOrder(@Param("orderCode")  String orderCode);
	
	PaymentRecord findById(@Param("id") String id);


}