/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.List;

import com.cku.oa.finance.entity.PaymentPayLog;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 支付记录日志DAO接口
 * 
 * @author yuanshuai
 * @version 2018-08-10
 */
@MyBatisDao
public interface PaymentPayLogDao extends CrudDao<PaymentPayLog> {

	/**
	 * @Description： 修改支付状态
	 * 
	 * @author: yuanshuai
	 * @date: 2018/8/13 14:12
	 */
	void updatePayState(PaymentPayLog paymentPayLog);

	List<PaymentPayLog> getByOrderId(String orderId);

	void updatePayType(PaymentPayLog paymentPayLog);

}