package com.cku.oa.dog.web;

import com.cku.oa.dog.entity.DogSticker;
import com.cku.oa.dog.service.DogStickerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 犬只贴纸Controller
 *
 * @author lgl
 * @version 2018-11-26
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogSticker")
public class DogStickerController extends BaseController {

    @Autowired
    private DogStickerService dogStickerService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/dog/dogSticker/?repage";

    private static final String AUTHORITY_PRDFIX = "dog:dogSticker:";

    @ModelAttribute
    public DogSticker get(@RequestParam(required = false) String id) {
        DogSticker entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogStickerService.get(id);
        }
        if (entity == null) {
            entity = new DogSticker();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogSticker dogSticker, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogSticker> page = dogStickerService.findPage(new Page<DogSticker>(request, response), dogSticker);
        model.addAttribute("page", page);
        return "oa/dog/dogsticker/dogStickerList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogSticker dogSticker, Model model) {
        model.addAttribute("dogSticker", dogSticker);
        return "oa/dog/dogsticker/dogStickerForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(DogSticker dogSticker, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogSticker)) {
            return form(dogSticker, model);
        }
        dogStickerService.save(dogSticker);
        addMessage(redirectAttributes, "保存犬只贴纸成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(DogSticker dogSticker, RedirectAttributes redirectAttributes) {
        dogStickerService.delete(dogSticker);
        addMessage(redirectAttributes, "删除犬只贴纸成功");
        return REPAGE;
    }

}