package com.cku.oa.dog.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.utils.PropertiesLoader;

public class VodUtil {

	private static PropertiesLoader loader = new PropertiesLoader("config.properties");

	/**
	 * 
	 * @param businessCode 业务code
	 * @param objectName   文件名
	 * @return
	 */
	public static String getVodUrl(String businessCode, String objectName) {
		String vodUrl = "";
		CloseableHttpClient httpClient = HttpClientBuilder.create().build();
		StringBuffer params = new StringBuffer();
		try {
			params.append("businessCode=" + URLEncoder.encode(businessCode, "utf-8"));
			params.append("&");
			params.append("objectName=" + URLEncoder.encode(objectName, "utf-8"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		HttpGet httpGet = new HttpGet(loader.getProperty("oss.vod.ulr") + "?" + params);
		CloseableHttpResponse response = null;
		try {
			// 设置http
			RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000)
					.setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
			httpGet.setConfig(requestConfig);
			// 由客户端执行(发送)Get请求
			response = httpClient.execute(httpGet);
			// 获取实体
			HttpEntity responseEntity = response.getEntity();
			if (responseEntity != null) {
				String result = EntityUtils.toString(responseEntity);

				JSONObject jsonObject = JSONObject.parseObject(result);
				vodUrl = jsonObject.getString("data");
			}
		} catch (IOException e) {
			e.printStackTrace();
			return "";
		} finally {
			try {
				// 释放资源
				if (httpClient != null)
					httpClient.close();
				if (response != null)
					response.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return vodUrl;
	}
}
