/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.service;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.*;
import com.cku.oa.dog.entity.*;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.enums.DogBreedClassEnum;
import com.cku.oa.dog.enums.GoldCertifiedStateEnum;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.cku.oa.dog.util.PedigreeCertifiedCodeUtil;
import com.cku.oa.dog.vo.DogNoseInfoResponse;
import com.cku.oa.dog.vo.request.DogChipNoSwapRequest;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.dao.ExpressSendDao;
import com.cku.oa.sys.entity.ExpressSend;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.dog.model.InsuranceDog;
import com.cku.restful.v1.dog.model.ViewDogVo;
import com.cku.util.ChineseUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * 犬只信息管理Service
 *
 * @author zhuoHeng
 * @version 2016-07-22
 */
@Service
@Transactional(readOnly = true)
public class DogService extends CrudService<DogDao, Dog> {

	@Autowired
	public DogNewbornDao dogNewbornDao;
	@Autowired
	public DogTypeService dogTypeService;
	@Autowired
	public DogTypeShowService dogTypeShowService;
	@Autowired
	public DogBreedCertifiedService dogBreedCertifiedService;
	@Autowired
	public DogAppraisalDao dogAppraisalDao;
	@Autowired
	public DogBirthCertificateDao dogBirthCertificateDao;
	@Lazy
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private DogChipDao dogChipDao;
	@Lazy
	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;
	@Autowired
	private DogPedigreeCertifiedRedoDao dogPedigreeCertifiedRedoDao;
	@Autowired
	private DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private DogAmphimixisProveService dogAmphimixisProveService;
	@Autowired
	private DogAppraisalAppraiserDao dogAppraisalAppraiserDao;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private DogDnaParentsCompareDao dogDnaParentsCompareDao;
	@Autowired
	public BusinessBanService businessBanService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public KennelService kennelService;
	@Autowired
	public DogColorMarkService dogColorMarkService;
	@Autowired
	public DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	public ChampionLoginDao championLoginDao;
	@Autowired
	public SaPaymentDetailTotalService saPaymentDetailTotalService;
	@Autowired
	public ExpressSendDao expressSendDao;
	@Autowired
	public MemberService memberService;
	@Autowired
	public DogNoseService dogNoseService;
	@Lazy
	@Autowired
	public ShowApplyService showApplyService;


	public Dog get(String id) {
		return super.get(id);
	}

	public List<Dog> findList(Dog dog) {
		if (StringUtils.isBlank(dog.getDogBreed())) {
			// 根据当前登录端查询犬种
			dog.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dog.getSqlMap().put("dogBreedMap", " ='" + dog.getDogBreed() + "'");
		}
		return super.findList(dog);
	}

	public Page<Dog> findPage(Page<Dog> page, Dog dog) {
		if (StringUtils.isBlank(dog.getDogBreed())) {
			// 根据当前登录端查询犬种
			dog.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dog.getSqlMap().put("dogBreedMap", " ='" + dog.getDogBreed() + "'");
		}
		return super.findPage(page, dog);
	}

	@Transactional(readOnly = false)
	public void save(Dog dog) {
		if (dog.getIsNewRecord()) {
			dog.setCreateDate(new Date());
			User u = UserUtils.getLoginUser();
			if (u != null) {
				dog.setOperator(u.getName() + ":" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"));// 操作人
			}
			// 新纪录更新业务禁止字段
			dog.setBusinessBan(
					businessBanService.getBusinessBan(dog.getDogBreed(), dog.getColorFlag(), dog.getBirthdate()));
			dog.setShowBan(businessBanService.getShowBan(dog.getDogBreed(), dog.getColorFlag(), dog.getBirthdate()));
			//如果证书号为NG或NGKC开头，则自动生成国外证书号
			if (StringUtils.isBlank(dog.getPedigreeCertifiedEn()) && dog.getPedigreeCertifiedCode().toLowerCase().startsWith("ng")) {
				dog.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedCode()));
			}
		} else {
			dog.setUpdateDate(new Date());
			User u = UserUtils.getLoginUser();
			if (u != null) {
				dog.setOperator(
						dog.getOperator() + ";" + u.getName() + ":" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"));// 操作人
			}
			if (SecurityUtils.getSubject().isPermitted("dog:dog:editshow")) {
				dao.updateShowDogBreed(dog);
			}
		}
		// 【OA--犬籍--犬只信息--添加、修改】如果DNA编号存在，且不属于该犬只，提示
		if (StringUtils.isNotBlank(dog.getDna())) {
			DogDna dogDna = dogDnaService.getByDnaCode(dog.getDna());
			if (dogDna != null && !dogDna.getDogId().equals(dog.getId())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该DNA编号不属于该犬只");
			}
		}
		if (dog.getDnaSaveWay() == null) {
			dog.setDnaSaveWay("");
		}
		if (dog.getIsDnaParentsCompare() == null) {
			dog.setIsDnaParentsCompare("");
		}
		// 呼名存在则校验是否符合规则
		if (StringUtils.isNotBlank(dog.getCallName())) {
			demandSensitiveWordService.validCallName(dog.getCallName());
		}
		super.save(dog);
	}

	@Transactional(readOnly = false)
	public void delete(Dog dog) {
		super.delete(dog);
	}

	/**
	 * 根据血统证书号查询犬信息
	 *
	 * @param pedigreeCertifiedCode
	 * @return
	 */
	public Dog getByPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			return null;
		}
		return dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
	}


	/**
	 * @Description 判断血统证书号是否NG或NGKC开头，如果是则替换为国外证书号
	 * @author yuanshuai
	 * @date 2020/12/1 8:53
	 */
	public void checkPedigreeCertifiedCodeWithNG(Dog dog) {
		if (dog.getPedigreeCertifiedCode().startsWith("NG") || dog.getPedigreeCertifiedCode().startsWith("NGKC")) {
			if (StringUtils.isNotBlank(dog.getPedigreeCertifiedEn()))
				dog.setPedigreeCertifiedCode(dog.getPedigreeCertifiedEn());
			else
				dog.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedCode()));
		}
	}

	public Dog getByPedigreeCertifiedCodeOrEn(String pedigreeCertifiedCode) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			return null;
		}
		return dao.getByPedigreeCertifiedCodeOrEn(pedigreeCertifiedCode);
	}

	public Dog getByPedigreeCertifiedCode(String pedigreeCertifiedCode, boolean isIncludeDel) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			return null;
		}
		if (isIncludeDel) {
			return dao.getByPedigreeCertifiedCodeIncludeDel(pedigreeCertifiedCode);
		} else {
			return dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		}
	}

	/**
	 * @Description：查询犬只三代家族信息方法
	 * @author: zhuoHeng
	 * @version: 2016年8月12日 下午4:26:54
	 */
	@SuppressWarnings("all")
	public String getDogFamily(String pedigreeCertifiedCode) {

		Map<String, Map<String, String>> newMap = new HashMap<String, Map<String, String>>();
		Map<String, String> map1 = DogFamily(pedigreeCertifiedCode.toUpperCase());

		Map<String, String> map21 = DogFamily(map1.get("fu"));
		Map<String, String> map22 = DogFamily(map1.get("mu"));

		Map<String, String> map211 = DogFamily(map21.get("fu"));
		Map<String, String> map212 = DogFamily(map21.get("mu"));
		Map<String, String> map221 = DogFamily(map22.get("fu"));
		Map<String, String> map222 = DogFamily(map22.get("mu"));

		newMap.put("fdai", map1);
		newMap.put("sdaif", map21);
		newMap.put("sdaim", map22);
		newMap.put("tdaiff", map211);
		newMap.put("tdaifm", map212);
		newMap.put("tdaimf", map221);
		newMap.put("tdaimm", map222);

		return JSONObject.fromObject(newMap).toString();
	}

	/**
	 * @Description：获取父母犬家族信息
	 * @author: zhuoHeng
	 * @version: 2016年8月31日 下午3:54:46
	 */
	public Map<String, Map<String, String>> getDogFamilyMessage(String fPedigreeCertifiedCode,
	                                                            String mPedigreeCertifiedCode) {

		Map<String, Map<String, String>> newMap = new HashMap<String, Map<String, String>>();
		Map<String, String> fmap1 = DogFamily(fPedigreeCertifiedCode.toUpperCase());

		Map<String, String> fmap21 = DogFamily(fmap1.get("fu"));
		Map<String, String> fmap22 = DogFamily(fmap1.get("mu"));

		Map<String, String> fmap211 = DogFamily(fmap21.get("fu"));
		Map<String, String> fmap212 = DogFamily(fmap21.get("mu"));
		Map<String, String> fmap221 = DogFamily(fmap22.get("fu"));
		Map<String, String> fmap222 = DogFamily(fmap22.get("mu"));

		newMap.put("ffdai", fmap1);
		newMap.put("fsdaif", fmap21);
		newMap.put("fsdaim", fmap22);
		newMap.put("ftdaiff", fmap211);
		newMap.put("ftdaifm", fmap212);
		newMap.put("ftdaimf", fmap221);
		newMap.put("ftdaimm", fmap222);

		Map<String, String> mmap1 = DogFamily(mPedigreeCertifiedCode.toUpperCase());

		Map<String, String> mmap21 = DogFamily(mmap1.get("fu"));
		Map<String, String> mmap22 = DogFamily(mmap1.get("mu"));

		Map<String, String> mmap211 = DogFamily(mmap21.get("fu"));
		Map<String, String> mmap212 = DogFamily(mmap21.get("mu"));
		Map<String, String> mmap221 = DogFamily(mmap22.get("fu"));
		Map<String, String> mmap222 = DogFamily(mmap22.get("mu"));

		newMap.put("mfdai", mmap1);
		newMap.put("msdaif", mmap21);
		newMap.put("msdaim", mmap22);
		newMap.put("mtdaiff", mmap211);
		newMap.put("mtdaifm", mmap212);
		newMap.put("mtdaimf", mmap221);
		newMap.put("mtdaimm", mmap222);

		return newMap;
	}

	/**
	 * @Description：获取近亲结果
	 * @author: zhuoHeng
	 * @version: 2016年8月31日 下午3:55:03
	 */
	public List<String> kinBreedMessage(String fPedigreeCertifiedCode, String mPedigreeCertifiedCode) {
		Map<String, String> map = new HashMap<String, String>();

		// 公犬系犬只信息
		map.put("1", fPedigreeCertifiedCode);
		map.put("11", (String) DogFamily(fPedigreeCertifiedCode).get("fu"));
		map.put("12", (String) DogFamily(fPedigreeCertifiedCode).get("mu"));
		map.put("111", (String) DogFamily(map.get("11")).get("fu"));
		map.put("112", (String) DogFamily(map.get("11")).get("mu"));
		map.put("121", (String) DogFamily(map.get("12")).get("fu"));
		map.put("122", (String) DogFamily(map.get("12")).get("mu"));
		map.put("1111", (String) DogFamily(map.get("111")).get("fu"));
		map.put("1112", (String) DogFamily(map.get("111")).get("mu"));
		map.put("1121", (String) DogFamily(map.get("112")).get("fu"));
		map.put("1122", (String) DogFamily(map.get("112")).get("mu"));
		map.put("1211", (String) DogFamily(map.get("121")).get("fu"));
		map.put("1212", (String) DogFamily(map.get("121")).get("mu"));
		map.put("1221", (String) DogFamily(map.get("122")).get("fu"));
		map.put("1222", (String) DogFamily(map.get("122")).get("mu"));
		// 母犬系犬只信息
		map.put("2", mPedigreeCertifiedCode);
		map.put("21", (String) DogFamily(mPedigreeCertifiedCode).get("fu"));
		map.put("22", (String) DogFamily(mPedigreeCertifiedCode).get("mu"));
		map.put("211", (String) DogFamily(map.get("21")).get("fu"));
		map.put("212", (String) DogFamily(map.get("21")).get("mu"));
		map.put("221", (String) DogFamily(map.get("22")).get("fu"));
		map.put("222", (String) DogFamily(map.get("22")).get("mu"));
		map.put("2111", (String) DogFamily(map.get("211")).get("fu"));
		map.put("2112", (String) DogFamily(map.get("211")).get("mu"));
		map.put("2121", (String) DogFamily(map.get("212")).get("fu"));
		map.put("2122", (String) DogFamily(map.get("212")).get("mu"));
		map.put("2211", (String) DogFamily(map.get("221")).get("fu"));
		map.put("2212", (String) DogFamily(map.get("221")).get("mu"));
		map.put("2221", (String) DogFamily(map.get("222")).get("fu"));
		map.put("2222", (String) DogFamily(map.get("222")).get("mu"));

		Iterator<String> ite = map.values().iterator();
		Map<String, Integer> countMap = new HashMap<String, Integer>();

		while (ite.hasNext()) {
			String item = ite.next();
			if (countMap.containsKey(item)) {
				countMap.put(item, Integer.valueOf(countMap.get(item).intValue() + 1));
			} else {
				countMap.put(item, new Integer(1));
			}
		}
		Set<String> kset = map.keySet();
		List<String> list = new ArrayList<>();
		for (Iterator<String> iter = countMap.keySet().iterator(); iter.hasNext(); ) {
			String key = (String) iter.next();
			if (countMap.get(key) > 1 && !"".equals(key)) {
				StringBuffer fsb = new StringBuffer();
				StringBuffer msb = new StringBuffer();
				for (String ks : kset) {
					if (key.equals(map.get(ks))) {
						/* System.out.println("出现位置"+ks+" 代数标识 "+ks.length()); */
						// 代表公犬系
						if ("1".equals(ks.substring(0, 1))) {
							fsb.append(ks.length());
							fsb.append(",");
						} else {
							msb.append(ks.length());
							msb.append(",");
						}
					}
				}
				// System.out.println(key + " 出现次数 " + countMap.get(key) + " 标识 " +
				// fsb.substring(0, fsb.length()-1)+"-"+msb.substring(0,msb.length()-1));
				// list.add(key+"("+fsb.substring(0,
				// fsb.length()>0?fsb.length()-1:fsb.length())+"-"+msb.substring(0,msb.length()>0?msb.length()-1:msb.length())+")");
				if (StringUtils.isBlank(fsb.toString()) || StringUtils.isBlank(msb.toString())) {
					continue;
				}
				int father = Integer.parseInt(fsb.substring(0, 1));
				int mother = Integer.parseInt(msb.substring(0, 1));
				String closeRelative = closeRelative(father, mother) ? "近亲" : "";
				list.add(key + "(" + father + "-" + mother + ")" + closeRelative);
			}
		}
		return list;
	}

	/**
	 * @description:近亲判断 11, 12, 13, 21, 22, 31为近亲
	 * @author: laiguanglong
	 * @date: 2018/3/6 18:13
	 */
	public boolean closeRelative(int father, int mother) {
		boolean flag = false;
		if (father == 1 || mother == 1 || (father == 2 && mother == 2)) {
			flag = true;
		}
		return flag;
	}

	/**
	 * @Description：查询犬只单代家族信息方法
	 * @author: zhuoHeng
	 * @version: 2016年8月12日 下午4:16:43
	 */
	@SuppressWarnings("all")
	public Map DogFamily(String pedigreeCertifiedCode) {

		Map<String, Object> map = new HashMap<String, Object>();
		Dog dog = "".equals(pedigreeCertifiedCode) ? new Dog() : dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode);

		String f_ckuNum = dog == null ? "" : dog.getFdogPedigreeCertified();// 父cku
		String m_ckuNum = dog == null ? "" : dog.getMdogPedigreeCertified();// 母cku

		Dog ListF = "".equals(f_ckuNum) ? new Dog() : dao.getByPedigreeCertifiedCode(f_ckuNum);
		Dog ListM = "".equals(m_ckuNum) ? new Dog() : dao.getByPedigreeCertifiedCode(m_ckuNum);

		map.put("fu", f_ckuNum == null ? "" : f_ckuNum);
		map.put("mu", m_ckuNum == null ? "" : m_ckuNum);
		map.put("fuName", ListF == null ? "" : ListF.getNameEn() == null ? "" : ListF.getNameEn());
		map.put("muName", ListM == null ? "" : ListM.getNameEn() == null ? "" : ListM.getNameEn());
		map.put("fcolorFlag", ListF == null ? "" : ListF.getColorFlag());
		map.put("fbirthdate", ListF == null ? "" : ListF.getBirthdate());
		map.put("mcolorFlag", ListM == null ? "" : ListM.getColorFlag());
		map.put("mbirthdate", ListM == null ? "" : ListM.getBirthdate());
		return map;
	}

	/**
	 * @Description：根据性别（定位查询父犬还是母犬）、血统证书号（所查询的犬只证书号）、代数初始值（从几代开始累加）查询犬只代数
	 * @author: zhuoHeng
	 * @version: 2016年8月30日 上午10:52:46
	 */
	public int getDogGeneration(String dogGender, String pedigreeCertifiedCode, int generation, int num) {

		String pedigreeCertified = "";
		int i = num;
		Map<String, String> map = new HashMap<String, String>();
		map = DogFamily(pedigreeCertifiedCode);
		if (!"".equals(map.get("fu")) && !"-".equals(map.get("fu")) && !"".equals(map.get("mu"))
				&& !"-".equals(map.get("mu"))) {
			generation = generation + 1;
			i++;
			if (i > 9) {
				return generation;
			}
			pedigreeCertified = map.get(dogGender);
		} else {
			return generation;
		}
		return getDogGeneration(dogGender, pedigreeCertified, generation, i);
	}

	/**
	 * @description: 检测三代是否满足, 满足返回true
	 * @author: laiguanglong
	 * @date: 2016年8月12日 上午10:28:35
	 */
	public boolean validate3Generation(String pedigreeCertifiedCode) {
		Dog dog1 = StringUtils.isBlank(pedigreeCertifiedCode) ? null
				: dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog1 != null && validateParentsPedigreeCertifiedCode(dog1)) {
			Dog dog2f = StringUtils.isBlank(dog1.getFdogPedigreeCertified()) ? null
					: dao.getByPedigreeCertifiedCode(dog1.getFdogPedigreeCertified());
			Dog dog2m = StringUtils.isBlank(dog1.getMdogPedigreeCertified()) ? null
					: dao.getByPedigreeCertifiedCode(dog1.getMdogPedigreeCertified());
			if (dog2f != null && validateParentsPedigreeCertifiedCode(dog2f) && dog2m != null
					&& validateParentsPedigreeCertifiedCode(dog2m)) {
				Dog dog3ff = StringUtils.isBlank(dog2f.getFdogPedigreeCertified()) ? null
						: dao.getByPedigreeCertifiedCode(dog2f.getFdogPedigreeCertified());
				Dog dog3fm = StringUtils.isBlank(dog2f.getMdogPedigreeCertified()) ? null
						: dao.getByPedigreeCertifiedCode(dog2f.getMdogPedigreeCertified());
				Dog dog3mf = StringUtils.isBlank(dog2m.getFdogPedigreeCertified()) ? null
						: dao.getByPedigreeCertifiedCode(dog2m.getFdogPedigreeCertified());
				Dog dog3mm = StringUtils.isBlank(dog2m.getMdogPedigreeCertified()) ? null
						: dao.getByPedigreeCertifiedCode(dog2m.getMdogPedigreeCertified());
				if (dog3ff != null && validateParentsPedigreeCertifiedCode(dog3ff) && dog3fm != null
						&& validateParentsPedigreeCertifiedCode(dog3fm) && dog3mf != null
						&& validateParentsPedigreeCertifiedCode(dog3mf) && dog3mm != null
						&& validateParentsPedigreeCertifiedCode(dog3mm)) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * @description: 校验该犬只父母犬的血统证书号是否有值, 返回true表示有值
	 * @author: laiguanglong
	 * @date: 2016年8月12日 上午10:21:23
	 */
	private boolean validateParentsPedigreeCertifiedCode(Dog dog) {
		if (StringUtils.isBlank(dog.getFdogPedigreeCertified()) || "-".equals(dog.getFdogPedigreeCertified())) {
			return false;
		}
		if (StringUtils.isBlank(dog.getMdogPedigreeCertified()) || "-".equals(dog.getMdogPedigreeCertified())) {
			return false;
		}
		return true;
	}

	/**
	 * @description: 根据芯片号查询犬信息
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午6:52:01
	 */
	public Dog getByIdentificationFlag(String identificationFlag) {
		if (StringUtils.isBlank(identificationFlag)) {
			return null;
		}
		return dao.getByIdentificationFlag(identificationFlag);
	}

	public List<Dog> getByIdentificationFlagList(String pedigreeCertifiedCode) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			return null;
		}
		return dao.getByIdentificationFlagList(pedigreeCertifiedCode);
	}


	/**
	 * @description: 打印血统证书
	 * @author: laiguanglong
	 * @date: 2016年9月1日 下午3:56:54
	 */
	@Transactional(readOnly = false)
	public String processPrintBusiness(Dog dog, Model model, Boolean isOA) {
		//判断是否已经打印过
		if (dog.getPrintState().contains("0")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该证书已打印过,请先重置打印");
		}
		//构建参数
		String printPath = null;
		String memberCode = dog.getMemberCode();
		String businessTable = null;
		String businessId = null;
		String certificateName = null;
		String certificateCode = dog.getPedigreeCertifiedCode();
		String runningNumber = null;

		//处理公用打印信息
		processCommonPrintInfo(dog, model);
		//根据打印类型处理打印逻辑
		if (dog.getPrintState().contains("1")) {
			//鉴定
			if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog.getGoldCertifiedState())) {
				//dna降级
				DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (Objects.isNull(dnaParentsCompare)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只DNA信息有误，无法打印血统证书");
				}
				businessTable = "dog_dna_parents_compare";
				certificateName = "DNA纯种犬证书";
				memberCode = dog.getMemberCode();
				businessId = dnaParentsCompare.getId();
				runningNumber = dnaParentsCompare.getRunningNumber();
				//处理打印DNA鉴定证书逻辑
				printPath = printDNAAppraisalCertified(dog, model);
			} else {
				//正常鉴定
				DogAppraisal dogAppraisal = dogAppraisalDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				businessTable = "dog_appraisal";
				certificateName = "犬只鉴定证书";
				if (Objects.nonNull(dogAppraisal)) {
					memberCode = dogAppraisal.getDogOwnerCode();
					businessId = dogAppraisal.getId();
					runningNumber = dogAppraisal.getRunningNumber();
				}
				//处理打印鉴定证书逻辑
				printPath = printAppraisalCertified(dogAppraisal, dog, model);
			}
		} else if (dog.getPrintState().contains("2")) {
			//血统证书
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
			certificateName = "犬只血统证书";
			if (Objects.nonNull(dogBirthCertificate)) {
				businessTable = "dog_chip";
				businessId = "旧业务缺少新生犬记录";
				DogChip dogChip = dogChipDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
				// 旧业务可能缺少新生犬登记记录，如果找不到，把流水号设置为空
				if (Objects.nonNull(dogChip)) {
					runningNumber = dogChip.getRunningNumber();
					businessId = dogChip.getId();
				} else {
					businessId = "旧业务缺少新生犬记录";
				}
			} else if (dog.getDogBreed().startsWith("NB")) {
				//NB犬只可无配种信息打印血统证书
				businessTable = "dog";
				businessId = dog.getId();
			} else {
				DogPedigreeCertifiedChange change = StringUtils.isBlank(dog.getPedigreeCertifiedEn()) ? null
						: dogPedigreeCertifiedChangeDao.getByOverseasPedigreeCertified(dog.getPedigreeCertifiedEn());
				if (Objects.nonNull(change)) {
					runningNumber = change.getRunningNumber();
					businessTable = "dog_pedigree_certified_change";
					businessId = change.getId();
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只无配种信息，无法打印血统证书");
				}
			}
			//处理打印血统证书逻辑
			printPath = printPedigreeCertified(dog, model);
		} else if (dog.getPrintState().contains("3")) {
			//出口
			DogPedigreeCertifiedExport export = dogPedigreeCertifiedExportService.getByDogId(dog.getId());
			businessTable = "dog_pedigree_certified_export";
			certificateName = "犬只出口血统证书";
			if (Objects.nonNull(export)) {
				memberCode = export.getPaymentMemberCode();
				businessId = export.getId();
				certificateCode = export.getPedigreeCertified();
				runningNumber = export.getRunningNumber();
			}
			//处理打印出口证书逻辑
			printPath = printExportCertified(export, dog, model);
		}
		//处理原生犬逻辑
		String nativePrintPath = printNativeCertified(dog, model);
		if (StringUtils.isNotBlank(nativePrintPath)) {
			printPath = nativePrintPath;
		}
		//鉴定和血统证书判断补做和换发
		if (dog.getPrintState().contains("1") || dog.getPrintState().contains("2")) {
			DogPedigreeCertifiedRedo redo = StringUtils.isBlank(dog.getPedigreeCertifiedCode()) ? null
					: dogPedigreeCertifiedRedoDao.getByCurrentPedigreeCertified(dog.getPedigreeCertifiedCode());
			if (Objects.nonNull(redo)) {
				runningNumber = redo.getRunningNumber();
				businessTable = "dog_pedigree_certified_redo";
				businessId = redo.getId();
			}
		}
		// 通过状态机记录日志
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, certificateName, memberCode, businessTable, businessId, runningNumber, (str) -> {
		});
		// 确认是哪个端进入的页面
		if (isOA) {
			model.addAttribute("isOrg", "0");
			// 添加待邮寄物品
			if (!StringUtils.isBlank(businessId)) {
				expressQueueService.push(memberCode, runningNumber, certificateName, certificateCode, businessTable, businessId, null);
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄信息有误");
			}
		} else {
			model.addAttribute("isOrg", "1");
			// 俱乐部打印不添加邮寄物品
			// 直接添加邮寄记录标记为协会自取
			sendAndConfirm(memberCode, businessId, businessTable, certificateCode, runningNumber);
		}
		// 修改打印状态
		dog.setPrintState("0" + dog.getPrintState());
		dog.preUpdate();
		if ("2".equals(dog.getPrintState())) {
			dog.setOperator(dog.getOperator() + "[" + dog.getUpdateBy() + "<打印>:" + DateUtils.formatDateTime(dog.getUpdateDate()) + "]");
		}
		dao.updatePrintState(dog);
		return printPath;
	}

	/**
	 * 处理DNA鉴定证书逻辑
	 * @author yuanshuai
	 * @since 2024/3/12 16:48
	 */
	private String printDNAAppraisalCertified(Dog dog, Model model) {
		Member member = memberService.getByMemberCode(dog.getMemberCode());
		if (Objects.isNull(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬主信息有误");
		} else {
			model.addAttribute("dogOwnerName", member.getName() + "[" + member.getNameEn() + "]");
		}
		DogDna dogDna = dogDnaService.getByDogId(dog.getId());
		if (Objects.isNull(dogDna) || StringUtils.isBlank(dogDna.getDnaResult())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只尚无DNA位点信息，无法打印DNA纯种犬证书");
		} else {
			model.addAttribute("geneCode", dogDnaService.convertGeneCodeByDNAResult(dogDna.getDnaResult()));
		}
		return "oa/dog/dog/dogDNAAppraisalPrint";
	}

	/**
	 * 处理出口证书逻辑
	 * @author yuanshuai
	 * @since 2023/12/14 11:31
	 */
	private String printExportCertified(DogPedigreeCertifiedExport export, Dog dog, Model model) {
		if ("1".equals(dog.getGender())) {
			dog.setGender("MALE");
		} else if ("2".equals(dog.getGender())) {
			dog.setGender("FEMALE");
		}
		// 如果繁育人姓名带汉字，要转换为全拼
		if (ChineseUtils.isContainChinese(dog.getBreeder())) {
			dog.setBreeder(dogPedigreeCertifiedExportService.getMemberNameEn(dog.getBreederMemberCode()));
		}
		// 如果犬主姓名取会员英文名
		Member member = memberService.getByMemberCode(dog.getMemberCode());
		dog.setDogOwner(member.getNameEn());
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(dog.getFmdogBreedCertifiedCode());
		if (dogNewborn != null) {
			dogNewborn.setPuppyBirthNum(dogNewborn.getPuppyBirthNum().replace(" ", ""));
			dogNewborn.setPuppyRegisterNum(dogNewborn.getPuppyRegisterNum().replace(" ", ""));
			export.setDogNewborn(dogNewborn);
		} else {
			// 如果国内配种证明表找不到，去国外配种证明表找
			DogAmphimixisProve dogAmphimixisProve = dogAmphimixisProveService.getMsg(dog.getFmdogBreedCertifiedCode());
			if (dogAmphimixisProve != null) {
				DogNewborn dogborn = new DogNewborn();
				String replace = dogAmphimixisProve.getNumberBirths().replace(" ", "");
				String replace2 = dogAmphimixisProve.getNumberRegisteredDogs().replace(" ", "");
				dogborn.setPuppyBirthNum(replace);
				dogborn.setPuppyRegisterNum(replace2);
				export.setDogNewborn(dogborn);
			}
		}
		// 设置上三代的信息
		dogPedigreeCertifiedExportService.set3Generation(export, dog);
		model.addAttribute("dogPedigreeCertifiedExport", export);
		model.addAttribute("printDate", new Date());
		return "oa/dog/dogexport/dogPedigreeCertifiedExportPrint";
	}

	/**
	 * 处理鉴定犬打印
	 *
	 * @author yuanshuai
	 * @since 2023/12/14 10:48
	 */
	private String printAppraisalCertified(DogAppraisal dogAppraisal, Dog dog, Model model) {
		dogAppraisal.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		dogAppraisal.setPedigreeCertifiedEn(dog.getPedigreeCertifiedEn());
		dogAppraisal.setDog(dog);
		model.addAttribute("dogAppraisal", dogAppraisal);
		if ("230".equals(dog.getDogBreed())) {
			//ID: 1006374 藏獒鉴定证书25年起使用通用版本
			if(Objects.isNull(dogAppraisal.getCreateDate()) 
					|| dogAppraisal.getCreateDate().before( com.cku.util.DateUtils.strToDate("2025-01-01"))) {
				return "oa/dog/dogappraisal/dogAppraisalPrintZangaoOld";
			}
		}
		
		return "oa/dog/dogappraisal/dogAppraisalPrint";
	}

	/**
	 * 处理原生犬打印
	 *
	 * @author yuanshuai
	 * @since 2023/12/14 10:37
	 */
	private String printNativeCertified(Dog dog, Model model) {
		String printPath = null;
		List<DogType> dogTypeList = dogTypeService.findList(new DogType());
		// add by zjw 新加国家级犬种判断
		List<String> countryList = dogTypeList.stream()
				.filter(dt -> DogBreedClassEnum.COUNTRY.code().equals(dt.getBreedClass()))
				.map(DogType::getDogBreedCode)
				.collect(Collectors.toList());
		Integer nbNum = null;
		if (dog.getDogBreed().startsWith("NB")) {
			nbNum = Integer.parseInt(dog.getDogBreed().substring(2));
		}
		if (Objects.nonNull(nbNum) && nbNum.compareTo(50) < 0) {
			//NB系列犬只打印原生犬证书（黄色）
			printPath = "oa/dog/dog/dogYsqPrint";
		} else if ((Objects.nonNull(nbNum) && nbNum.compareTo(50) >= 0)
				|| countryList.contains(dog.getDogBreed())) {
			//FCI国家级证书(白色)
			printPath = "oa/dog/dog/dogCountryPrint";
		}
		return printPath;
	}

	/**
	 * 处理血统证书打印逻辑
	 *
	 * @author yuanshuai
	 * @since 2023/12/14 10:21
	 */
	private String printPedigreeCertified(Dog dog, Model model) {
		// 设置跳转页面
		String returnPath = "oa/dog/dog/dogPrint";
		//默认背景
		String background = "print_xt_b.jpg";
		//犬只年龄
		//是否父母及自身都大于15
		Boolean isAllGT15 = Boolean.TRUE;
		if (Objects.isNull(dog.getBirthdate()) || DateUtils.isInXMounth(dog.getBirthdate(), new Date(), 15)) {
			isAllGT15 = Boolean.FALSE;
		}
		Dog dog1 = getByPedigreeCertifiedCode(toUpdateEmpty(dog.getFdogPedigreeCertified()));
		if (Objects.nonNull(dog1)
				&& (Objects.isNull(dog1.getBirthdate()) || DateUtils.isInXMounth(dog1.getBirthdate(), new Date(), 15))) {
			isAllGT15 = Boolean.FALSE;
		}
		Dog dog2 = getByPedigreeCertifiedCode(toUpdateEmpty(dog.getMdogPedigreeCertified()));
		if (Objects.nonNull(dog2)
				&& (Objects.isNull(dog2.getBirthdate()) || DateUtils.isInXMounth(dog2.getBirthdate(), new Date(), 15))) {
			isAllGT15 = Boolean.FALSE;
		}
		//构建祖辈信息
		buildAncestorInfo(dog1, dog2, model);
		// 判断父母是否都为优生繁育
		// 父母是否获得繁育证书标记位
		boolean isDogBreedCertified = false;
		if (Objects.nonNull(dog1) && Objects.nonNull(dog2)) {
			DogBreedCertified dogBreedCertified1 = dogBreedCertifiedService.getByDogId(dog1.getId());
			DogBreedCertified dogBreedCertified2 = dogBreedCertifiedService.getByDogId(dog2.getId());
			if (dogBreedCertified1 != null && "1".equals(dogBreedCertified1.getReviewState())
					&& dogBreedCertified2 != null && "1".equals(dogBreedCertified2.getReviewState())) {
				isDogBreedCertified = true;
			}
		}
		// 位点分析是否通过标记位
		boolean isDogDnaArchive = dogDnaService.isHaveDogDna(dog.getId());
		// 双亲比对是否通过标记位
		boolean isDnaParentsCompare = false;
		DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareDao
				.getByBirthCode(dog.getBirthCertificateLevelCode());
		// 办理了双亲比对业务，审核状态不为通过不允许打印
		if (dogDnaParentsCompare != null && !"1".equals(dogDnaParentsCompare.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只办理了双亲比对业务，需双亲比对审核通过后，方可打印证书或查看电子证书");
		}
		if (dogDnaParentsCompare != null && "1".equals(dogDnaParentsCompare.getReviewState())) {
			isDnaParentsCompare = true;
		}
		//是否参加过赛事
		Boolean isFinishShowApply = showApplyService.isFinishShowApply(dog.getPedigreeCertifiedCode());
		// 《DNA纯血犬血统证书》完成血样留存、位点分析、双亲比对通过
		if (isDogDnaArchive && isDnaParentsCompare) {
			DogDna dogDna = dogDnaService.getByDogId(dog.getId());
			if (Objects.nonNull(dogDna) && !StringUtils.isBlank(dogDna.getDnaResult())) {
				model.addAttribute("geneCode", dogDnaService.convertGeneCodeByDNAResult(dogDna.getDnaResult()));
			}
			returnPath = "oa/dog/dog/dogDnaCertifiedPrint";
		}
		// 《DNA优生繁育纯血犬血统证书》完成血样留存、位点分析、双亲比对通过、父母犬获得繁育证书
		if (isDogDnaArchive && isDnaParentsCompare && isDogBreedCertified && isAllGT15 && isFinishShowApply) {
			returnPath = "oa/dog/dog/dogDnaRedCertifiedPrint";
		}
		// 藏獒只有一种血统证书
		if ("230".equals(dog.getDogBreed())) {
//			returnPath = "oa/dog/dog/dogPrintZangao";
			returnPath = "oa/dog/dog/dogPrint";
		} else if ("15C".equals(dog.getDogBreed())) {
			// 马犬血统证书
			background = "print_mc.jpg";
		}
		//添加背景
		model.addAttribute("background", background);
		return returnPath;
	}

	/**
	 * 处理公用打印信息
	 *
	 * @author yuanshuai
	 * @since 2023/12/14 10:53
	 */
	private void processCommonPrintInfo(Dog dog, Model model) {
		//默认时间
		model.addAttribute("date", new SimpleDateFormat("yyyy年M月d日").format(new Date()));
		//配种信息
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(dog.getFmdogBreedCertifiedCode());
		if (dogNewborn != null) {
			model.addAttribute("puppyBirthNum", dogNewborn.getPuppyBirthNum().replace(" ", ""));
			model.addAttribute("puppyRegisterNum", dogNewborn.getPuppyRegisterNum().replace(" ", ""));
		} else {
			// 如果国内配种证明表找不到，去国外配种证明表找
			DogAmphimixisProve dogAmphimixisProve = dogAmphimixisProveService.getMsg(dog.getFmdogBreedCertifiedCode());
			if (dogAmphimixisProve != null) {
				String breeder = dogAmphimixisProve.getBreeder();
				if (StringUtils.isNotBlank(breeder)) {
					dog.setBreeder(breeder);
				}
				String numberBirths = dogAmphimixisProve.getNumberBirths();
				String[] str = numberBirths.split(",");
				String numberRegisteredDogs = dogAmphimixisProve.getNumberRegisteredDogs();
				String[] str1 = numberRegisteredDogs.split(",");
				model.addAttribute("puppyBirthNum", str[0] + "公" + str[1] + "母");
				model.addAttribute("puppyRegisterNum", str1[0] + "公" + str1[1] + "母");
			}
		}
		//犬主人繁殖人
		if (StringUtils.isNotBlank(dog.getDogBreed()) && !dog.getDogBreed().equals("15C")) {
			String nameEn = memberService.getByMemberCode(dog.getMemberCode()).getNameEn();
			if (StringUtils.isNotBlank(nameEn)) {
				String[] split1 = nameEn.split(" ");
				if (split1.length > 1) {
					dog.setDogOwner(dog.getDogOwner() + "【" + split1[1] + " " + split1[0] + "】");
				} else {
					dog.setDogOwner(dog.getDogOwner() + "【" + split1[0] + "】");
				}
			}
			DogBirthCertificate birthCerRegCode = dogBirthCertificateDao.getByBirthCerRegCode(dog.getBirthCertificateLevelCode());
			if (birthCerRegCode != null) {
				String memberCode = birthCerRegCode.getBreederMemberCode();
				String nameEn2 = memberService.getByMemberCode(memberCode).getNameEn();
				if (StringUtils.isNotBlank(nameEn2)) {
					String[] split2 = nameEn2.split(" ");
					if (split2.length > 1) {
						dog.setBreeder(dog.getBreeder() + "【" + split2[1] + " " + split2[0] + "】");
					} else {
						dog.setBreeder(dog.getBreeder() + "【" + split2[0] + "】");
					}
				}
			}
		}
		//第二繁殖人
		if (StringUtils.isNotBlank(dog.getSecondBreeder())) {
			DogBirthCertificate birthCerRegCode = dogBirthCertificateDao
					.getByBirthCerRegCode(dog.getBirthCertificateLevelCode());
			if (birthCerRegCode != null && StringUtils.isNotBlank(birthCerRegCode.getSecondBreederMemberCode())) {
				Member secondBreederMember = memberService
						.getByMemberCode(birthCerRegCode.getSecondBreederMemberCode());
				if (secondBreederMember != null && StringUtils.isNotBlank(secondBreederMember.getNameEn())) {
					String[] split = secondBreederMember.getNameEn().split(" ");
					if (split.length > 1) {
						dog.setSecondBreeder(dog.getSecondBreeder() + "【" + split[1] + " " + split[0] + "】");
					} else {
						dog.setSecondBreeder(dog.getSecondBreeder() + "【" + split[0] + "】");
					}
				}
			}
			if (dog.getSecondBreeder().equals(dog.getBreeder())) {
				dog.setSecondBreeder(null);
			}
		}
		//犬种
		DogType dogtype = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		if (dogtype == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"该犬只的犬种" + dog.getDogBreed() + ",在犬种表无法找到对应的记录，请检查是否有该犬种");
		} else {
			//fci级别
			dog.setBreedClass(dogtype.getBreedClass());
			model.addAttribute("breedEnName", dogtype.getBreedEnName());
			model.addAttribute("breedCnName", dogtype.getBreedCnName());
		}
		//犬舍
		if (StringUtils.isNotBlank(dog.getBreederMemberCode())) {
			Kennel kennel = kennelService.getKennelByMemberCode(dog.getBreederMemberCode());
			if (kennel != null) {
				model.addAttribute("kennelName", kennel.getName());
			}
		}
		//毛色
		DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dog.getColorFlag());
		if (dogColorMark != null) {
			String colorMarkCn = dogColorMark.getDogColorMarkCn();
			String[] color = colorMarkCn.split("-");
			model.addAttribute("colorCn", color[1]);
			model.addAttribute("colorEn", dogColorMark.getDogColorMarkCode());
		}
		//dna信息
		dog.setDna(StringUtils.isEmpty(dog.getDna()) ? "-" : dog.getDna());
		model.addAttribute("dog0", dog);
	}

	/**
	 * 构建祖辈信息
	 *
	 * @author yuanshuai
	 * @since 2023/12/13 15:53
	 */
	private void buildAncestorInfo(Dog dog1, Dog dog2, Model model) {
		//祖辈信息
		for (int i = 1; i < 15; i++) {
			model.addAttribute("dog" + i, new Dog());
		}
		if (dog1 != null) {
			checkPedigreeCertifiedCodeWithNG(dog1);
			model.addAttribute("dog1", dog1);
			Dog dog3 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getFdogPedigreeCertified()));
			if (dog3 != null) {
				checkPedigreeCertifiedCodeWithNG(dog3);
				model.addAttribute("dog3", dog3);
				Dog dog7 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getFdogPedigreeCertified()));
				if (dog7 != null) {
					checkPedigreeCertifiedCodeWithNG(dog7);
					model.addAttribute("dog7", dog7);

					Dog dog15 = getByPedigreeCertifiedCode(toUpdateEmpty(dog7.getFdogPedigreeCertified()));
					if (dog15 != null) {
						checkPedigreeCertifiedCodeWithNG(dog15);
						model.addAttribute("dog15", dog15);
					}
					Dog dog16 = getByPedigreeCertifiedCode(toUpdateEmpty(dog7.getMdogPedigreeCertified()));
					if (dog16 != null) {
						checkPedigreeCertifiedCodeWithNG(dog16);
						model.addAttribute("dog16", dog16);
					}
				}
				Dog dog8 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getMdogPedigreeCertified()));
				if (dog8 != null) {
					checkPedigreeCertifiedCodeWithNG(dog8);
					model.addAttribute("dog8", dog8);

					Dog dog17 = getByPedigreeCertifiedCode(toUpdateEmpty(dog8.getFdogPedigreeCertified()));
					if (dog17 != null) {
						checkPedigreeCertifiedCodeWithNG(dog17);
						model.addAttribute("dog17", dog17);
					}
					Dog dog18 = getByPedigreeCertifiedCode(toUpdateEmpty(dog8.getMdogPedigreeCertified()));
					if (dog18 != null) {
						checkPedigreeCertifiedCodeWithNG(dog18);
						model.addAttribute("dog18", dog18);
					}
				}
			}
			Dog dog4 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getMdogPedigreeCertified()));
			if (dog4 != null) {
				checkPedigreeCertifiedCodeWithNG(dog4);
				model.addAttribute("dog4", dog4);
				Dog dog9 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getFdogPedigreeCertified()));
				if (dog9 != null) {
					checkPedigreeCertifiedCodeWithNG(dog9);
					model.addAttribute("dog9", dog9);

					Dog dog19 = getByPedigreeCertifiedCode(toUpdateEmpty(dog9.getFdogPedigreeCertified()));
					if (dog19 != null) {
						checkPedigreeCertifiedCodeWithNG(dog19);
						model.addAttribute("dog19", dog19);
					}
					Dog dog20 = getByPedigreeCertifiedCode(toUpdateEmpty(dog9.getMdogPedigreeCertified()));
					if (dog20 != null) {
						checkPedigreeCertifiedCodeWithNG(dog20);
						model.addAttribute("dog20", dog20);
					}
				}
				Dog dog10 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getMdogPedigreeCertified()));
				if (dog10 != null) {
					checkPedigreeCertifiedCodeWithNG(dog10);
					model.addAttribute("dog10", dog10);

					Dog dog21 = getByPedigreeCertifiedCode(toUpdateEmpty(dog10.getFdogPedigreeCertified()));
					if (dog21 != null) {
						checkPedigreeCertifiedCodeWithNG(dog21);
						model.addAttribute("dog21", dog21);
					}
					Dog dog22 = getByPedigreeCertifiedCode(toUpdateEmpty(dog10.getMdogPedigreeCertified()));
					if (dog22 != null) {
						checkPedigreeCertifiedCodeWithNG(dog22);
						model.addAttribute("dog22", dog22);
					}
				}
			}
		}
		if (dog2 != null) {
			checkPedigreeCertifiedCodeWithNG(dog2);
			model.addAttribute("dog2", dog2);
			Dog dog5 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getFdogPedigreeCertified()));
			if (dog5 != null) {
				checkPedigreeCertifiedCodeWithNG(dog5);
				model.addAttribute("dog5", dog5);
				Dog dog11 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getFdogPedigreeCertified()));
				if (dog11 != null) {
					checkPedigreeCertifiedCodeWithNG(dog11);
					model.addAttribute("dog11", dog11);

					Dog dog23 = getByPedigreeCertifiedCode(toUpdateEmpty(dog11.getFdogPedigreeCertified()));
					if (dog23 != null) {
						checkPedigreeCertifiedCodeWithNG(dog23);
						model.addAttribute("dog23", dog23);
					}
					Dog dog24 = getByPedigreeCertifiedCode(toUpdateEmpty(dog11.getMdogPedigreeCertified()));
					if (dog24 != null) {
						checkPedigreeCertifiedCodeWithNG(dog24);
						model.addAttribute("dog24", dog24);
					}
				}
				Dog dog12 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getMdogPedigreeCertified()));
				if (dog12 != null) {
					checkPedigreeCertifiedCodeWithNG(dog12);
					model.addAttribute("dog12", dog12);

					Dog dog25 = getByPedigreeCertifiedCode(toUpdateEmpty(dog12.getFdogPedigreeCertified()));
					if (dog25 != null) {
						checkPedigreeCertifiedCodeWithNG(dog25);
						model.addAttribute("dog25", dog25);
					}
					Dog dog26 = getByPedigreeCertifiedCode(toUpdateEmpty(dog12.getMdogPedigreeCertified()));
					if (dog26 != null) {
						checkPedigreeCertifiedCodeWithNG(dog26);
						model.addAttribute("dog26", dog26);
					}
				}
			}
			Dog dog6 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getMdogPedigreeCertified()));
			if (dog6 != null) {
				checkPedigreeCertifiedCodeWithNG(dog6);
				model.addAttribute("dog6", dog6);
				Dog dog13 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getFdogPedigreeCertified()));
				if (dog13 != null) {
					checkPedigreeCertifiedCodeWithNG(dog13);
					model.addAttribute("dog13", dog13);

					Dog dog27 = getByPedigreeCertifiedCode(toUpdateEmpty(dog13.getFdogPedigreeCertified()));
					if (dog27 != null) {
						checkPedigreeCertifiedCodeWithNG(dog27);
						model.addAttribute("dog27", dog27);
					}
					Dog dog28 = getByPedigreeCertifiedCode(toUpdateEmpty(dog13.getMdogPedigreeCertified()));
					if (dog28 != null) {
						checkPedigreeCertifiedCodeWithNG(dog28);
						model.addAttribute("dog28", dog28);
					}
				}
				Dog dog14 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getMdogPedigreeCertified()));
				if (dog14 != null) {
					checkPedigreeCertifiedCodeWithNG(dog14);
					model.addAttribute("dog14", dog14);

					Dog dog29 = getByPedigreeCertifiedCode(toUpdateEmpty(dog14.getFdogPedigreeCertified()));
					if (dog29 != null) {
						checkPedigreeCertifiedCodeWithNG(dog29);
						model.addAttribute("dog29", dog29);
					}
					Dog dog30 = getByPedigreeCertifiedCode(toUpdateEmpty(dog14.getMdogPedigreeCertified()));
					if (dog30 != null) {
						checkPedigreeCertifiedCodeWithNG(dog30);
						model.addAttribute("dog30", dog30);
					}
				}
			}
		}
	}

	/**
	 * 添加邮寄记录
	 *
	 * @author yuanshuai
	 * @since 2023/12/13 15:30
	 */
	private void sendAndConfirm(String memberCode, String businessId, String businessTable, String content, String runningNumber) {
		Date now = new Date();
		Member member = memberService.getByMemberCode(memberCode);
		ExpressSend expressSend = new ExpressSend();
		expressSend.preInsert();
		expressSend.setMemberCode(memberCode);
		expressSend.setMemberName(member.getName());
		expressSend.setContent(content);
		expressSend.setExpressType("协会自取");
		expressSend.setExpressName("无");
		expressSend.setExpressNo("");
		expressSend.setPostDate(now);
		expressSend.setCreateDate(now);
		expressSend.setUpdateDate(now);
		expressSend.setDelFlag("0");
		expressSend.setAddress(member.getAddress());
		// 添加邮寄记录
		expressSendDao.insert(expressSend);
		// 确认收入时点
		saPaymentDetailTotalService.financeConfirmTime(businessId, businessTable, runningNumber);
	}

	/**
	 * 公共的去空方法
	 *
	 * @Author chaixueteng
	 * @2016年11月15日下午5:41:51
	 */
	public String toUpdateEmpty(String a) {
		if (a == null) {
			return null;
		}
		if ("".equals(a.trim())) {
			return null;
		} else {
			return a;
		}
	}

	/**
	 * @description: 重置打印
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午5:49:46
	 */
	@Transactional(readOnly = false)
	public void resetPrint(String id) {
		Dog dog = super.get(id);
		if (dog.getPrintState().length() == 2) {
			// 修改打印状态
			dog.setPrintState(dog.getPrintState().substring(1));
			// 打印更新时间和操作人
			dog.preUpdate();
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			dog.setOperator(
					dog.getOperator() + "[" + dog.getUpdateBy() + "<重置>:" + format.format(dog.getUpdateDate()) + "]");

			dao.updatePrintState(dog);
		}
	}

	/**
	 * @description: 更新打印状态
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午5:49:46
	 */
	@Transactional(readOnly = false)
	public void updatePrintState(Dog dog) {
		dao.updatePrintState(dog);
	}

	/**
	 * @description: 根据外国血统证书号查询犬信息
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午6:52:01
	 */
	public Dog getByPedigreeCertifiedEn(String pedigreeCertifiedEn) {
		return dao.getByPedigreeCertifiedEn(pedigreeCertifiedEn);
	}

	/**
	 * @description: 根据外国血统证书号查询CKU犬信息
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午6:52:01
	 */
	public Dog getCkuDogByPedigreeCertifiedEn(String pedigreeCertifiedEn) {
		return dao.getCkuDogByPedigreeCertifiedEn(pedigreeCertifiedEn);
	}

	public Dog getCkuDogByPedigreeCertifiedEnOrCode(String pedigreeCertifiedEn) {
		return dao.getCkuDogByPedigreeCertifiedEnOrCode(pedigreeCertifiedEn);
	}

	/**
	 * 血统证书号 唯一性校验
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:41:47
	 */
	public String codeCheck(String pedigreeCertifiedCode, String id) {
		List<Dog> list = dao.getBycode(pedigreeCertifiedCode);
		if (list.size() > 0) {
			String ids = list.get(0).getId();
			if (id.equals(ids)) {
				return "{\"rc\":0}";
			}
			return "{\"rc\":1,\"pedigreeCertifiedCode\":\"" + pedigreeCertifiedCode + "\"}";
		} else {
			return "{\"rc\":0}";
		}
	}

	/**
	 * 犬只芯片号唯一性校验
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:41:47
	 */
	public String checkIdentification(String identificationFlag, String id) {
		List<Dog> list = dao.getByFlag(identificationFlag);
		if (list.size() > 0) {
			String ids = list.get(0).getId();
			if (id.equals(ids)) {
				return "{\"rc\":0}";
			}
			return "{\"rc\":1,\"identificationFlag\":\"" + identificationFlag + "\"}";
		} else {
			return "{\"rc\":0}";
		}
	}

	/**
	 * 根据出生证明编号查询
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:25:04
	 */
	public Dog getByBirthCertificateLevelCode(String birthCerRegCode) {
		return dao.getByBirthCertificateLevelCode(birthCerRegCode);
	}

	/**
	 * 根据配种证明查询
	 *
	 * @Author
	 * @2016年10月13日下午4:25:04
	 */
	public List<Dog> getByFmdog(String fmdogBreedCertifiedCode) {
		return dao.getByFmdog(fmdogBreedCertifiedCode);
	}

	/**
	 * 打印旧数据的鉴定证书
	 *
	 * @Author chaixueteng
	 * @2016年11月15日下午2:18:01
	 */

	@Transactional(readOnly = false)
	public String printZang(Dog dog0, Model model) {
		model.addAttribute("dog0", dog0);
		DogPedigreeCertifiedRedo redo = dogPedigreeCertifiedRedoDao
				.getByCurrentPedigreeCertified(dog0.getPedigreeCertifiedCode());
		if (redo == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该证书号没有证书补做记录！");
		}
		String originalPedigreeCertified = redo.getOriginalPedigreeCertified();
		DogAppraisalAppraiser dogAppraisalAppraiser = dogAppraisalAppraiserDao
				.getByCertified(originalPedigreeCertified);
		model.addAttribute("dogAppraisalAppraiser", dogAppraisalAppraiser);
		String dogBreed = dog0.getDogBreed();
		DogType type = dogTypeService.getByDogBreedCode(dogBreed);
		if (type == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"该犬只的犬种" + dog0.getDogBreed() + ",在犬种表无法找到对应的记录，请检查是否有该犬种");
		}
		model.addAttribute("breedCnName", type.getBreedCnName());
		model.addAttribute("breedEnName", type.getBreedEnName());
		model.addAttribute("date", new Date());
		// 修改打印状态
		if ("1".equals(dog0.getPrintState())) {
			dog0.setPrintState("01");
			updatePrintState(dog0);
		}

		// 通过状态机记录日志
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "犬只鉴定打印", dog0.getMemberCode(), "dog", dog0.getId(),
				dog0.getRunningNumber(), (str) -> {
				});

		// 添加待邮寄物品
		expressQueueService.push(dog0.getMemberCode(), dog0.getRunningNumber(), "犬只鉴定证书",
				dog0.getPedigreeCertifiedCode(), null); // GYH2 TODO

		// 设置跳转页面
		String returnPath = "oa/dog/dogappraisal/dogAppraisalPrintOld";
		if ("230".equals(redo.getDogBreed())) {
			returnPath = "oa/dog/dogappraisal/dogAppraisalPrintZangaoOld";
		}
		return returnPath;
	}

	public Map<String, Object> getDogMsg(String pedigreeCertifiedCode) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		// 查询并组装返回对象
		Dog dog = getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {
			// 支持根据芯片号进行查询
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
		}
		if (!"0".equals(dog.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态非正常");
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.YEAR, -1);
		Date oneYearBeforeDate = calendar.getTime();
		if (dog.getBirthdate().getTime() >= oneYearBeforeDate.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄不足1岁");
		}
		map.put("nameEn", dog.getNameEn());
		map.put("identificationFlag", dog.getIdentificationFlag());
		DogType byDogBreedCode = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		if (byDogBreedCode != null) {
			map.put("dogBreedName", byDogBreedCode.getBreedCnName());
		}
		map.put("dogOwner", dog.getDogOwner());
		map.put("birthdate", sdf.format(dog.getBirthdate()));
		map.put("colorFlag", dog.getColorFlag());
		return map;
	}

	public static int getMonth(String str) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = sdf.parse(str);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			Calendar calendarNow = Calendar.getInstance();
			Calendar temp = Calendar.getInstance();

			temp.add(Calendar.DATE, 1);
			int year = calendarNow.get(Calendar.YEAR) - calendar.get(Calendar.YEAR);
			int month = calendarNow.get(Calendar.MONTH) - calendar.get(Calendar.MONTH);

			if ((calendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) == 1)) {
				return year * 12 + month + 1;
			} else if ((calendar.get(Calendar.DATE) != 1) && (temp.get(Calendar.DATE) == 1)) {
				return year * 12 + month;
			} else if ((calendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) != 1)) {
				return year * 12 + month;
			} else {
				return (year * 12 + month - 1) < 0 ? 0 : (year * 12 + month);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}

	public String getAge(Date birthdate) {
		StringBuilder dogAge = new StringBuilder();
		int monthAge = getMonthAge(new Date(), birthdate);
		if (monthAge / 12 > 0) {
			dogAge.append(monthAge / 12).append("岁");
			if (monthAge % 12 != 0) {
				dogAge.append(monthAge % 12).append("个月");
			}
		} else {
			dogAge.append(monthAge % 12).append("个月");
		}
		return dogAge.toString();
	}

	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}
	
	
	public  Map<String,Dog> getMapByPedigreeCertifiedCodes(List<String> pedigreeCertifiedCodes) {
		List<Dog> list = dao.findByPedigreeCertifiedCodes(pedigreeCertifiedCodes);
		return	list.stream().collect(Collectors.toMap(Dog::getPedigreeCertifiedCode, Function.identity()));
	}

	/**
	 * @description: 宠爱王国保险根据芯片号查询犬信息
	 * @author: cuihuaiyu
	 * @date: 2018年3月22日
	 */
	public List<InsuranceDog> getByInsIdentificationFlag(String identificationFlag) {
		if (StringUtils.isBlank(identificationFlag)) {
			return null;
		}
		return dao.getByInsIdentificationFlag(identificationFlag);
	}

	/**
	 * @Description：根据血统证书号获取犬只代数
	 * @author: zhuoHeng
	 * @version: 2018年3月28日
	 */
	public int getDogGeneration(String pedigreeCertifiedCode) {
		List<String> errorList = new ArrayList<>();
		errorList.add("NP37525602");
		errorList.add("LOSH0999052");
		errorList.add("NHSB 2386893");
		errorList.add("NHSB 1.873.962");
		errorList.add("WP75624301");
		errorList.add("NO INFORMATION");
		errorList.add("JR 79752");
		errorList.add("JR 81791");
		errorList.add("2100065327");
		errorList.add("RKF 1976148");
		errorList.add("BCU 006241");
		errorList.add("AKC WR05890102");
		errorList.add("KCTH I06110273");
		errorList.add("RKF 1995966");
		errorList.add("RKF 2616407");
		errorList.add("LOF 6GD.B.G 0");
		errorList.add("РКФ 0001601");
		errorList.add("AKC TR09136601");
		errorList.add("ROI 09/172767");
		errorList.add("LOSH 0936742");
		errorList.add("PKR 50356");
		errorList.add("RKF 2102808");
		errorList.add("JKC-NP/11-17840");
		errorList.add("MKA DG-354742-2011");
		errorList.add("UKU 0000909");
		errorList.add("DHM-56062/99");
		errorList.add("PT-01175/84");
		errorList.add("LR -15834/98");
		errorList.add("-");
		errorList.add("RKF 1044939");
		errorList.add("（ENCI）TC070934");
		errorList.add("KCC 00105963");
		errorList.add("RKF 1383768");
		errorList.add("IKC T49584");
		errorList.add("MET.ANG.BULL8254/09");
		errorList.add("RKF 2371039");
		errorList.add("ENCI04/105364");
		List<Map> list = new ArrayList<>();
		boolean all = true;
		Map<String, String> map = new HashMap<>();
		map.put("1", pedigreeCertifiedCode);
		list.add(map);
		int time = 1;
		int generation = 0;
		while (all) {
			String str = list.get(0).keySet().toString().substring(1, list.get(0).keySet().toString().length() - 1);
			String tempCode = list.get(0).get(str).toString();
			Dog dog = null;
			// 过滤错误号码
			if (!errorList.contains(tempCode)) {
				dog = getByPedigreeCertifiedCode(tempCode);
			}
			time++;
			if (list.size() == 0) {
				break;
			} else {
				list.remove(0);
			}
			if (dog != null && StringUtils.isNotBlank(dog.getFdogPedigreeCertified())
					&& StringUtils.isNotBlank(dog.getMdogPedigreeCertified())
					&& !"-".equals(dog.getFdogPedigreeCertified()) && !"-".equals(dog.getMdogPedigreeCertified())) {
				all = true;
				Map<String, String> mapF = new HashMap<>();
				Map<String, String> mapM = new HashMap<>();
				mapF.put(str + "1", dog.getFdogPedigreeCertified());
				list.add(mapF);
				mapM.put(str + "2", dog.getMdogPedigreeCertified());
				list.add(mapM);
			} else {
				all = false;
				generation = str.length() - 1;
			}
		}
		return generation;

	}

	/**
	 * @Description： 根据父母犬信息获取犬只代数
	 * @author: yuanshuai
	 * @date: 2018/4/12 10:43
	 */
	public int getDogGeneration(String fDogPedigreeCertified, String mDogPedigreeCertified) {
		int fDogGeneration = getDogGeneration(fDogPedigreeCertified);
		int mDogGeneration = getDogGeneration(mDogPedigreeCertified);
		// 取最小的代数+1
		return Math.min(fDogGeneration, mDogGeneration) + 1;
	}

	public int getRank(String fDogPedigreeCertified, String mDogPedigreeCertified) {
		int dogGeneration = getDogGeneration(fDogPedigreeCertified, mDogPedigreeCertified);
		if (dogGeneration >= 3) {
			ChampionLogin championLogin = new ChampionLogin();
			championLogin.setReviewState("1");
			championLogin.setPedigreeCertified(fDogPedigreeCertified);
			long fatherChampionLoginCount = championLoginDao.listCount(championLogin);
			championLogin.setPedigreeCertified(mDogPedigreeCertified);
			long motherChampionLoginCount = championLoginDao.listCount(championLogin);
			if (fatherChampionLoginCount > 0 && motherChampionLoginCount > 0) {
				return 8;
			} else if (fatherChampionLoginCount > 0 || motherChampionLoginCount > 0) {
				return 6;
			} else {
				return 4;
			}
		} else {
			return 2;
		}
	}

	/**
	 * @Description： 导入犬只信息的模板
	 * @author: yuanshuai
	 * @date: 2019年5月30日10:51:38
	 */
	public String importFileTemplate(HttpServletResponse response) throws IOException {
		String fileName = "犬只数据导入模板.xlsx";
		List<Dog> list = Lists.newArrayList();
		Dog dog = new Dog();
		list.add(dog);
		new ExportExcel("犬只信息", Dog.class, 2).setDataList(list).write(response, fileName).dispose();
		return null;
	}

	/**
	 * @Description： 导入犬只信息
	 * @author: yuanshuai
	 * @date: 2019年5月30日10:51:41
	 */
	@Transactional(readOnly = false)
	public void importMember(MultipartFile file)
			throws InvalidFormatException, IOException, IllegalAccessException, InstantiationException {
		ImportExcel ei = new ImportExcel(file, 1, 0);
		List<Dog> list = ei.getDataList(Dog.class);
		boolean error = false;
		StrBuilder strBuilder = new StrBuilder();
		for (Dog dog : list) {
			if (StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
				continue;
			}

			// 是NG开头
			if (StringUtils.isBlank(dog.getPedigreeCertifiedEn()) && dog.getPedigreeCertifiedCode().toLowerCase().startsWith("ng")) {
				dog.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedCode()));
			}

			// 国外证书号
			if (StringUtils.isNotBlank(dog.getPedigreeCertifiedEn())) {
				if (dog.getPedigreeCertifiedEn().toLowerCase().startsWith("ng")
						|| dog.getPedigreeCertifiedEn().toLowerCase().startsWith("ngkc")) {
					error = recordError(strBuilder, dog.getPedigreeCertifiedEn() + "国外证书号不能以NG开头");
				}
			}
			// 证书号判重
			Dog vo = dao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
			if (vo != null && !StringUtils.isBlank(vo.getId())) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "证书号重复有误");
			}
			// 犬主人
			if (StringUtils.isBlank(dog.getDogOwner()) || StringUtils.isBlank(dog.getMemberCode())) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬主人信息有误");
			}
			// 犬名
			if (StringUtils.isBlank(dog.getNameEn())) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只英文名有误");
			} else {
				dog.setNameEn(StringEscapeUtils.unescapeHtml4(dog.getNameEn()));
			}
			// 性别
			String gender = DictUtils.getDictValue(dog.getGender(), "dog_gender", null);
			if (StringUtils.isBlank(gender)) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只性别有误");
			}
			dog.setGender(gender);
			// 出生日期
			if (dog.getBirthdate() == null) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只出生日期有误");
			}
			// 处理犬种
			DogType dogType = null;
			if (!StringUtils.isBlank(dog.getDogBreed())) {
				// 先查繁殖犬种
				dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
			}
			if (dogType == null || StringUtils.isBlank(dogType.getBreedCnName())) {
				// 繁殖犬种为空查赛事犬种
				if (!StringUtils.isBlank(dog.getShowDogBreed())) {
					// 根据FCi赛事编码查询犬种
					DogTypeShow dogTypeShow = dogTypeShowService.getByDogShowCode(dog.getShowDogBreed());
					if (dogTypeShow != null && !StringUtils.isBlank(dogTypeShow.getDogBreedCode())) {
						dog.setDogBreed(dogTypeShow.getDogBreedCode());
					} else {
						error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只犬种有误");
					}
				} else {
					error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只犬种有误");
				}
			} else {
				dog.setShowDogBreed(dogType.getDogBreedCode());
			}
			// 不判断毛色
			// if (StringUtils.isBlank(dog.getColorFlag())) {
			// error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只毛色为空");
			// } else {
			// DogColorMark colorMark =
			// dogColorMarkService.getByDogColorMarkCode(dog.getColorFlag());
			// if (colorMark == null
			// || StringUtils.isBlank(colorMark.getDogColorMarkCn())) {
			// error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只毛色有误");
			// }
			// }
			// 判断芯片
			if (StringUtils.isBlank(dog.getIdentificationFlag())) {
				error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "犬只芯片有误");
			}
			// 判断繁殖人，配种证明，父母犬信息
			// if (StringUtils.isBlank(dog.getBreeder())) {
			// error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "繁殖人有误");
			// }
			// if (StringUtils.isBlank(dog.getFmdogBreedCertifiedCode())) {
			// error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "配种证明有误");
			// }
			// if (StringUtils.isBlank(dog.getFdogPedigreeCertified())
			// || StringUtils.isBlank(dog.getMdogPedigreeCertified())) {
			// error = recordError(strBuilder, dog.getPedigreeCertifiedCode() + "父母犬信息有误");
			// }
			if (!error) {
				// 代数
				if (StringUtils.isBlank(dog.getDogGeneration())) {
					dog.setDogGeneration("0");
				}
				// 备注
				dog.setRemarks(dog.getImportRemark());
				// 默认数据
				dog.preInsert();
				dog.setDogState("0");// 犬只状态正常
				dog.setSpecialFlag("");// 特殊标记
				dog.setDnaPayState("0");
				dog.setBreedPayState("0");
				dog.setDnaSaveWay("");
				dog.setIsDnaParentsCompare("");
				// 默认禁止
				dog.setBusinessBan("1");
				dog.setShowBan("0");
				if (StringUtils.isBlank(dog.getCreateBy().getName())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, dog.getPedigreeCertifiedCode() + "用户登录状态有误");
				}
				// 操作人
				dog.setOperator(dog.getCreateBy().getName() + ":" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"));
				dao.insert(dog);
			}
		}
		if (error) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, strBuilder.toString());
		}
	}

	/**
	 * @Description： 导入统一记录错误
	 * @author: yuanshuai
	 * @date: 2019/6/12 13:47
	 */
	private boolean recordError(StrBuilder strBuilder, String msg) {
		strBuilder.append(msg).append("##");
		return true;
	}

	public Dog getOneByIdentificationFlagOrPedigreeCertified(String keyword) {

		return dao.getOneByIdentificationFlagOrPedigreeCertified(keyword);

	}

	public String getDogImgById(String id) {
		return dao.getDogImgById(id);
	}

	public ViewDogVo convertDogVo(Dog dog) {
		ViewDogVo vo = new ViewDogVo();
		vo.setColor(dog.getColorFlag());
		if (dog.getBirthdate() != null) {
			vo.setCreateDate(new SimpleDateFormat("yyyy-M-d").format(dog.getBirthdate()));
		}
		vo.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		vo.setDogName(StringUtils.isNotBlank(dog.getNameEn()) ? dog.getNameEn().toUpperCase() : "");
		vo.setShowLevel(dog.getShowLevel());
		vo.setShowGrade(dog.getShowGrade());
		if ("1".equals(dog.getPictureReviewState())) {
			vo.setPicture(dog.getPicture());
		}
		vo.setNameEn(dog.getNameEn());
		vo.setId(dog.getId());
		return vo;
	}

	public Dog getByPedigreeCertifiedCodeOrIdentificationFlag(String key) {
		return dao.getByPedigreeCertifiedCodeOrIdentificationFlag(key);
	}

	/***
	 * 根据芯片号查询犬只信息
	 *
	 * @param chipNo
	 */
	public ResultDto<DogNoseInfoResponse> findDogInfo(String chipNo) {
		DogNoseInfoResponse resp = new DogNoseInfoResponse();
		// 查询犬只表
		Dog dog = dao.getOneByIdentificationFlagOrPedigreeCertified(chipNo);
		if (ObjectUtils.isEmpty(dog)) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(chipNo);
			if (ObjectUtils.isEmpty(dogBirthCertificate)) {
				return ResultDto.error(ZAErrorCode.ZA_ERROR, "芯片号错误");
			}
			resp.setBirthCertificateLevelCode(dogBirthCertificate.getBirthCerRegCode());
			resp.setBirthdate(DateUtils.formatDate(dogBirthCertificate.getDogBirthday()));
			;
			resp.setDogBreed(getString(dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed())));
			resp.setGender(dogBirthCertificate.getDogGender());
			resp.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
			resp.setDogName(dogBirthCertificate.getDogEnName());
			resp.setNoseMethod("2");
			resp.setBirthCertificateLevelId(dogBirthCertificate.getId());
			resp = getnoseInfo(dogBirthCertificate, null, resp);
			return ResultDto.success(resp);
		}
		resp.setBirthCertificateLevelCode(dog.getBirthCertificateLevelCode());
		resp.setNoseMethod("1");
		resp.setDogId(dog.getId());
		resp.setBirthdate(DateUtils.formatDate(dog.getBirthdate()));
		resp.setDogBreed(getString(dogTypeService.getBreedCnName(dog.getDogBreed())));
		resp.setGender(dog.getGender());
		resp.setIdentificationFlag(dog.getIdentificationFlag());
		resp.setDogName(dog.getNameEn());
		resp.setPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());

		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(chipNo);
		resp = getnoseInfo(dogBirthCertificate, dog, resp);
		return ResultDto.success(resp);
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	private DogNoseInfoResponse getnoseInfo(DogBirthCertificate dogBirthCertificate, Dog dog,
	                                        DogNoseInfoResponse resp) {
		DogNose dogNose = dogNoseService.getByDogIdODogBirthCertificateId(
				dogBirthCertificate == null ? "" : dogBirthCertificate.getId(), dog == null ? "" : dog.getId());
		if (!ObjectUtils.isEmpty(dogNose)) {
			resp.setNoseCode(dogNose.getNoseCode());
			resp.setNoseId(dogNose.getNoseId());
			resp.setNoseFlag("1");
		} else {
			resp.setNoseFlag("2");
		}
		return resp;
	}

	public List<Dog> getByFmdogBreedCertifiedCode(String key) {
		if (StringUtils.isBlank(key)) {
			return null;
		}
		List<Dog> dogList = dao.getByFmdogBreedCertifiedCode(key);
		return dogList;
	}

	public List<Dog> getByParents(String key) {
		List<Dog> dogList = dao.getByParents(key);
		return dogList;
	}

	public List<Dog> getByFatherDog(String key) {
		return dao.getByFatherDog(key);
	}

	public List<Dog> getByMotherDog(String key) {
		return dao.getByMotherDog(key);
	}

	public List<Dog> findDogNameByBirthCode(List<String> birthCode) {
		return dao.findDogNameByBirthCode(birthCode);
	}

	public List<Dog> findDogNameByPedigreeCode(List<String> pedigreeCode) {
		return dao.findDogNameByPedigreeCode(pedigreeCode);
	}


	public Page<Dog> findPicturePage(Page<Dog> page, Dog entity) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		entity.setPage(page);
		List<Dog> pictureReviewStateList = dao.getPictureReviewStateList(entity);
		page.setList(pictureReviewStateList);
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<Dog>(0));
		}
		return page;
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void deleteDogByIds(List<String> dogIds) {
		int row = dao.deleteByDogIds(dogIds);
		if (row != dogIds.size()) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "删除犬只记录失败");
		}
	}

	private void changeBan(Dog dog) {
		if ("1".equals(dog.getChangeBan())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "因4代内包含禁止出口犬只，此犬无法申请出口");
		}
	}

	public void dogChangeBan(Dog dog0) {
		changeBan(dog0);
		Dog dog1 = getByPedigreeCertifiedCode(toUpdateEmpty(dog0.getFdogPedigreeCertified()));
		if (dog1 != null) {
			changeBan(dog1);
			Dog dog3 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getFdogPedigreeCertified()));
			if (dog3 != null) {
				changeBan(dog3);
				Dog dog7 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getFdogPedigreeCertified()));
				if (dog7 != null) {
					changeBan(dog7);

					Dog dog15 = getByPedigreeCertifiedCode(toUpdateEmpty(dog7.getFdogPedigreeCertified()));
					if (dog15 != null) {
						changeBan(dog15);
					}
					Dog dog16 = getByPedigreeCertifiedCode(toUpdateEmpty(dog7.getMdogPedigreeCertified()));
					if (dog16 != null) {
						changeBan(dog16);
					}
				}
				Dog dog8 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getMdogPedigreeCertified()));
				if (dog8 != null) {
					changeBan(dog8);

					Dog dog17 = getByPedigreeCertifiedCode(toUpdateEmpty(dog8.getFdogPedigreeCertified()));
					if (dog17 != null) {
						changeBan(dog17);
					}
					Dog dog18 = getByPedigreeCertifiedCode(toUpdateEmpty(dog8.getMdogPedigreeCertified()));
					if (dog18 != null) {
						changeBan(dog18);
					}
				}
			}
			Dog dog4 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getMdogPedigreeCertified()));
			if (dog4 != null) {
				changeBan(dog4);
				Dog dog9 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getFdogPedigreeCertified()));
				if (dog9 != null) {
					changeBan(dog9);

					Dog dog19 = getByPedigreeCertifiedCode(toUpdateEmpty(dog9.getFdogPedigreeCertified()));
					if (dog19 != null) {
						changeBan(dog19);
					}
					Dog dog20 = getByPedigreeCertifiedCode(toUpdateEmpty(dog9.getMdogPedigreeCertified()));
					if (dog20 != null) {
						changeBan(dog20);
					}
				}
				Dog dog10 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getMdogPedigreeCertified()));
				if (dog10 != null) {
					changeBan(dog10);
					Dog dog21 = getByPedigreeCertifiedCode(toUpdateEmpty(dog10.getFdogPedigreeCertified()));
					if (dog21 != null) {
						changeBan(dog21);
					}
					Dog dog22 = getByPedigreeCertifiedCode(toUpdateEmpty(dog10.getMdogPedigreeCertified()));
					if (dog22 != null) {
						changeBan(dog22);
					}
				}
			}
		}
		Dog dog2 = getByPedigreeCertifiedCode(toUpdateEmpty(dog0.getMdogPedigreeCertified()));
		if (dog2 != null) {
			changeBan(dog2);
			Dog dog5 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getFdogPedigreeCertified()));
			if (dog5 != null) {
				changeBan(dog5);
				Dog dog11 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getFdogPedigreeCertified()));
				if (dog11 != null) {
					changeBan(dog11);

					Dog dog23 = getByPedigreeCertifiedCode(toUpdateEmpty(dog11.getFdogPedigreeCertified()));
					if (dog23 != null) {
						changeBan(dog23);
					}
					Dog dog24 = getByPedigreeCertifiedCode(toUpdateEmpty(dog11.getMdogPedigreeCertified()));
					if (dog24 != null) {
						changeBan(dog24);
					}
				}
				Dog dog12 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getMdogPedigreeCertified()));
				if (dog12 != null) {
					changeBan(dog12);
					Dog dog25 = getByPedigreeCertifiedCode(toUpdateEmpty(dog12.getFdogPedigreeCertified()));
					if (dog25 != null) {
						changeBan(dog25);
					}
					Dog dog26 = getByPedigreeCertifiedCode(toUpdateEmpty(dog12.getMdogPedigreeCertified()));
					if (dog26 != null) {
						changeBan(dog26);
					}
				}
			}
			Dog dog6 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getMdogPedigreeCertified()));
			if (dog6 != null) {
				changeBan(dog6);
				Dog dog13 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getFdogPedigreeCertified()));
				if (dog13 != null) {
					changeBan(dog13);
					Dog dog27 = getByPedigreeCertifiedCode(toUpdateEmpty(dog13.getFdogPedigreeCertified()));
					if (dog27 != null) {
						changeBan(dog27);
					}
					Dog dog28 = getByPedigreeCertifiedCode(toUpdateEmpty(dog13.getMdogPedigreeCertified()));
					if (dog28 != null) {
						changeBan(dog28);
					}
				}
				Dog dog14 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getMdogPedigreeCertified()));
				if (dog14 != null) {
					changeBan(dog14);

					Dog dog29 = getByPedigreeCertifiedCode(toUpdateEmpty(dog14.getFdogPedigreeCertified()));
					if (dog29 != null) {
						changeBan(dog29);
					}
					Dog dog30 = getByPedigreeCertifiedCode(toUpdateEmpty(dog14.getMdogPedigreeCertified()));
					if (dog30 != null) {
						changeBan(dog30);
					}
				}
			}
		}
	}


	@Transactional(readOnly = false)
	public void updateDogChip(Dog dog) {
		dao.updateDogChip(dog);
	}

	@Transactional(readOnly = false)
	public void chipNoSwapByBirthCode(DogChipNoSwapRequest request) {
		if (request.getBirthCodeA().equals(request.getBirthCodeB())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的两个出生纸编号一致，请重新输入");
		}
		DogBirthCertificate dogBirthA = dogBirthCertificateDao.getByBirthCerRegCode(request.getBirthCodeA());
		if (Objects.isNull(dogBirthA)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生纸编号：" + request.getBirthCodeA() + "查找不到信息");
		}
		DogBirthCertificate dogBirthB = dogBirthCertificateDao.getByBirthCerRegCode(request.getBirthCodeB());
		if (Objects.isNull(dogBirthB)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生纸编号：" + request.getBirthCodeB() + "查找不到信息");
		}
		String chipNoA = dogBirthA.getIdentificationFlag();
		String chipNoB = dogBirthB.getIdentificationFlag();
		//修改出生纸中芯片号
		dogBirthA.setIdentificationFlag(chipNoB);
		dogBirthCertificateDao.updateDogChip(dogBirthA);
		dogBirthB.setIdentificationFlag(chipNoA);
		dogBirthCertificateDao.updateDogChip(dogBirthB);
		//修改犬只信息中芯片号
		Dog dogA = this.getByBirthCertificateLevelCode(request.getBirthCodeA());
		if (Objects.nonNull(dogA)) {
			dogA.setIdentificationFlag(chipNoB);
			this.updateDogChip(dogA);
		}
		Dog dogB = this.getByBirthCertificateLevelCode(request.getBirthCodeB());
		if (Objects.nonNull(dogB)) {
			dogB.setIdentificationFlag(chipNoA);
			this.updateDogChip(dogB);
		}
		//添加芯片变更记录
		DogChipChange dogChipChangeA = new DogChipChange();
		dogChipChangeA.setDogId(Objects.isNull(dogA) ? null : dogA.getId());
		dogChipChangeA.setBirthCode(dogBirthA.getBirthCerRegCode());
		dogChipChangeA.setChipCodeOld(chipNoA);
		dogChipChangeA.setChipCodeNew(chipNoB);
		dogChipChangeA.preInsert();
		dogChipChangeA.setIsNewRecord(Boolean.TRUE);
		dogChipChangeService.save(dogChipChangeA);
		DogChipChange dogChipChangeB = new DogChipChange();
		dogChipChangeB.setDogId(Objects.isNull(dogB) ? null : dogB.getId());
		dogChipChangeB.setBirthCode(dogBirthB.getBirthCerRegCode());
		dogChipChangeB.setChipCodeOld(chipNoB);
		dogChipChangeB.setChipCodeNew(chipNoA);
		dogChipChangeB.preInsert();
		dogChipChangeB.setIsNewRecord(Boolean.TRUE);
		dogChipChangeService.save(dogChipChangeB);
	}

	/**
	 * 更新金质证书相关信息
	 *
	 * @author yuanshuai
	 * @since 2024/3/12 14:43
	 */
	public void updateGoldCertifiedInfo(DogDnaParentsCompare dogDnaParentsCompare) {
		//如果有血统证书则更新犬只表金质证书信息
		Dog dog = getByPedigreeCertifiedCode(dogDnaParentsCompare.getPedigreeCertified());
		if (Objects.nonNull(dog)) {
			dog.setGoldCertifiedType(dogDnaParentsCompare.getApplySource());
			dog.setGoldCertifiedState(dogDnaParentsCompare.getGoldCertifiedState());
			if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dogDnaParentsCompare.getGoldCertifiedState())) {
				dog.setPrintState("1");
			} else {
				dog.setPrintState("2");
			}
			dog.preUpdate();
			dao.updateGoldCertifiedInfo(dog);
		}
	}
}
