package com.cku.oa.dog.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sampling.service.SamplingService;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DogTypeShow;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.ExpressSendDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.finance.service.OADeleteService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 证书换发Service
 *
 * @author lgl
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class DogPedigreeCertifiedChangeService
		extends CrudService<DogPedigreeCertifiedChangeDao, DogPedigreeCertifiedChange> {

	private static final String BUSINESS_NAME = "证书换发";

	public static Long newBusinessTimeMillis = null;

	static {
		try {
			newBusinessTimeMillis = new SimpleDateFormat("yyyy-MM-dd").parse("2017-06-01").getTime();
		} catch (ParseException e) {
			System.out.println("证书换发判断新旧业务记录格式化时间出错");
		}
	}

	@Lazy
	@Autowired
	private RestDogService restDogService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private RemindService remindService;
	@Autowired
	private DogAmphimixisProveService dogAmphimixisProveService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	public ExpressSendDao expressSendDao;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	private OADeleteService oADeleteService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogTypeShowService dogTypeShowService;
	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private SamplingService samplingService;

	public DogPedigreeCertifiedChange get(String id) {
		return super.get(id);
	}

	public List<DogPedigreeCertifiedChange> findList(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		if (StringUtils.isBlank(dogPedigreeCertifiedChange.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogPedigreeCertifiedChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogPedigreeCertifiedChange.getSqlMap().put("dogBreedMap",
					" ='" + dogPedigreeCertifiedChange.getDogBreed() + "'");
		}
		return super.findList(dogPedigreeCertifiedChange);
	}

	public Page<DogPedigreeCertifiedChange> findPage(Page<DogPedigreeCertifiedChange> page,
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		dogPedigreeCertifiedChange.setPage(page);
		page.setIbatisPagePluginEnable(false);
		if (StringUtils.isBlank(dogPedigreeCertifiedChange.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogPedigreeCertifiedChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogPedigreeCertifiedChange.getSqlMap().put("dogBreedMap",
					" ='" + dogPedigreeCertifiedChange.getDogBreed() + "'");
		}
		int count = dao.listCount(dogPedigreeCertifiedChange);
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		page.setCount(count);
		if ((pageNo - 1) * pageSize >= count) {
			page.setList(new ArrayList<DogPedigreeCertifiedChange>(0));
			return page;
		}
		page.setList(dao.findList(dogPedigreeCertifiedChange));
		return page;
	}

	@Transactional(readOnly = false)
	public void save(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		String overseasPedigreeCertified = dogPedigreeCertifiedChange.getOverseasPedigreeCertified().toUpperCase();
		if (StringUtils.isNotBlank(dogPedigreeCertifiedChange.getId())) {
			// 编辑
			DogPedigreeCertifiedChange po = dao.get(dogPedigreeCertifiedChange);
			if ("1".equals(po.getProcessState())) {
				// 如果已处理不允许修改外国血统证书号
				overseasPedigreeCertified = po.getOverseasPedigreeCertified();
			} else if (!po.getOverseasPedigreeCertified().equals(overseasPedigreeCertified)) {
				//修改证书号
				// 如果外国血统证书号修改了，同步修改DNA存档、采样包和芯片变更表相关记录的外国血统证书号
				DogDnaArchive dogDnaArchive = dogDnaArchiveDao
						.getByOverseasPedigreeCertified(po.getOverseasPedigreeCertified());
				if (dogDnaArchive != null) {
					dogDnaArchive.setOverseasPedigreeCertified(overseasPedigreeCertified);
					dogDnaArchive.preUpdate();
					dogDnaArchiveDao.update(dogDnaArchive);
					//同步修改采样包
					Sampling sampling = samplingService.getByDogCode(po.getOverseasPedigreeCertified(), SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED);
					sampling.setDogCode(overseasPedigreeCertified);
					samplingService.updateDogInfo(sampling);
				}
				DogChipChange dogChipChange = dogChipChangeDao
						.getByOverseasPedigreeCertified(po.getOverseasPedigreeCertified());
				if (dogChipChange != null) {
					dogChipChange.setOverseasPedigreeCertified(overseasPedigreeCertified);
					dogChipChange.preUpdate();
					dogChipChangeDao.update(dogChipChange);
				}
			}
		}
		dogPedigreeCertifiedChange.setOverseasPedigreeCertified(overseasPedigreeCertified);
		String string = StringEscapeUtils.unescapeHtml4(dogPedigreeCertifiedChange.getDogName());
		dogPedigreeCertifiedChange.setDogName(string.toUpperCase());
		dogPedigreeCertifiedChange.setDogFurColor(dogPedigreeCertifiedChange.getDogFurColor().toUpperCase());
		if (StringUtils.isNotBlank(dogPedigreeCertifiedChange.getDogChip())) {
			dogPedigreeCertifiedChange.setDogChip(dogPedigreeCertifiedChange.getDogChip().toUpperCase());
		}
		super.save(dogPedigreeCertifiedChange);
	}

	@Transactional(readOnly = false)
	public void delete(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		// 已缴费的订单不允许删除
		if ("2".equals(dogPedigreeCertifiedChange.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		// OA删除订单
		oADeleteService.deleteUnpay(dogPedigreeCertifiedChange.getPaymentState(), "dog_pedigree_certified_change",
				dogPedigreeCertifiedChange.getId(), dogPedigreeCertifiedChange.getRunningNumber());
		super.delete(dogPedigreeCertifiedChange);
	}

	/**
	 * @description: 证书换发审核
	 * @author: laiguanglong
	 * @date: 2016年8月18日 下午5:16:49
	 */
	@Transactional(readOnly = false)
	public void audit(DogPedigreeCertifiedChange review) throws ZAException {
		try {
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = get(review.getId());
			// 未通过的数据可直接变更为除为审核外的任何状态，此处将未通过的数据当做待审核处理 zhuoHeng
			if ("2".equals(dogPedigreeCertifiedChange.getReviewState())) {
				dogPedigreeCertifiedChange.setReviewState("0");
			}
			SysContext sysContext = new SysContext(dogPedigreeCertifiedChange.getPaymentState(),
					dogPedigreeCertifiedChange.getReviewState(), dogPedigreeCertifiedChange.getProcessState());
			if ("1".equals(review.getReviewState())) {
				// 通过
				sysContext.confirmSuccess(sysContext, BUSINESS_NAME, dogPedigreeCertifiedChange.getPaymentMemberCode(),
						"dog_pedigree_certified_change", dogPedigreeCertifiedChange.getId(),
						dogPedigreeCertifiedChange.getRunningNumber(), (str) -> {
						});
				dogPedigreeCertifiedChange.setReviewState(review.getReviewState());
			} else if ("2".equals(review.getReviewState())) {
				// 未通过
				sysContext.confirmFail(sysContext, BUSINESS_NAME, review.getReviewRemarks(),
						dogPedigreeCertifiedChange.getPaymentMemberCode(), "dog_pedigree_certified_change",
						dogPedigreeCertifiedChange.getId(), dogPedigreeCertifiedChange.getRunningNumber(), (str) -> {
						});
				dogPedigreeCertifiedChange.setReviewState(review.getReviewState());
			} else if ("3".equals(review.getReviewState())) {
				// 已注销
				sysContext.confirmFail(sysContext, BUSINESS_NAME, review.getReviewRemarks(),
						dogPedigreeCertifiedChange.getPaymentMemberCode(), "dog_pedigree_certified_change",
						dogPedigreeCertifiedChange.getId(), dogPedigreeCertifiedChange.getRunningNumber(), (str) -> {
						});
				dogPedigreeCertifiedChange.setReviewState(review.getReviewState());
			}
			dogPedigreeCertifiedChange.setReviewTime(new Date());
			dogPedigreeCertifiedChange.setReviewRemarks(review.getReviewRemarks());
			// 审核同时可以修改犬只芯片号
			dogPedigreeCertifiedChange.setDogChip(review.getDogChip());
			super.save(dogPedigreeCertifiedChange);
			// 给用户发送消息
			sendMsg(dogPedigreeCertifiedChange);
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * @description: 是否能撤销，能撤销返回true
	 * @author: laiguanglong
	 * @date: 2017/5/18 16:38
	 */
	public boolean isCanRefund(DogPedigreeCertifiedChange po) {
		boolean flag = false;
		if ("0".equals(po.getIsCanceled())) {
			if ("2".equals(po.getReviewState())) {
				// 审核不通过，可以撤销
				flag = true;
			} else if ("1".equals(po.getReviewState())) {
				// 审核通过，以下条件可以撤销
				if ("0".equals(po.getDogChipCheck())) {
					// 犬只芯片校验未通过，未支付芯片费
					flag = true;
				} else if ("1".equals(po.getDogChipCheck())) {
					DogChipChange dogChipChange = dogChipChangeDao.getByIdentificationFlag(po.getDogChip());
					if (dogChipChange == null) {
						// 不需要缴纳芯片费，且没有缴纳位点分析费
						if (StringUtils.isBlank(po.getDogDnaArchiveId())) {
							flag = true;
						}
					} else {
						// 需要缴纳芯片费，且没有付款
						if (!"2".equals(dogChipChange.getPaymentState())) {
							flag = true;
						}
					}
				}
			} else if ("0".equals(po.getReviewState())) {
				flag = true;
			}
		}
		return flag;
	}

	/**
	 * @description: 证书换发处理
	 * @author: laiguanglong
	 * @date: 2016年8月18日 下午5:17:09
	 */
	@Transactional(readOnly = false)
	public void resolve(DogPedigreeCertifiedChange handle) throws ZAException {
		try {
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = get(handle.getId());
			SysContext sysContext = new SysContext(dogPedigreeCertifiedChange.getPaymentState(),
					dogPedigreeCertifiedChange.getReviewState(), dogPedigreeCertifiedChange.getProcessState());
			sysContext.updateData(sysContext, BUSINESS_NAME, dogPedigreeCertifiedChange.getPaymentMemberCode(),
					"dog_pedigree_certified_change", dogPedigreeCertifiedChange.getId(),
					dogPedigreeCertifiedChange.getRunningNumber(), (str) -> {
					});
			// 修改证书换发记录状态信息
			dogPedigreeCertifiedChange.setProcessState("1");
			dogPedigreeCertifiedChange.setProcessTime(new Date());
			//查询犬种信息
			DogType dogType = dogTypeService.getByDogBreedCode(dogPedigreeCertifiedChange.getDogBreed());
			// 生成犬只信息
			Dog dog = isCkuExportDog(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			String dogId = "";
			if (dog != null) {
				// 只做犬主变更和犬状态变更,还要打印血统证书
				dog.setMemberCode(dogPedigreeCertifiedChange.getPaymentMemberCode());
				dog.setDogOwner(dogPedigreeCertifiedChange.getDogOwnerName());
				dog.setDogState("0");
				dog.setPrintState("2");
				dog.setCallName(handle.getCallName());
				//增加标记 只有FCI正式认可可以申请出口
				if(dogType!=null) {
					dog.setChangeBan(!"formal".equals(dogType.getBreedClass())?"1":null);
				}
				dogService.save(dog);
				// 由于dog表update的方法不更新打印状态，所以需要再次单独调用
				dogDao.updatePrintState(dog);
				// 由于dog表update的方法不更新犬主信息，所以需要再次单独调用
				dogDao.updateDogOwner(dog);
				dogId = dog.getId();
				// 如果犬种为292，且CKU开头，且费CKUDC开头，且时间大于2017-08-01，需要把血统证书号中的CKU改为CKUDC，并更新其他表的血统证书号
				if ("292".equals(dog.getDogBreed()) && dog.getPedigreeCertifiedCode().startsWith("CKU")
						&& !dog.getPedigreeCertifiedCode().startsWith("CKUDC")
						&& System.currentTimeMillis() > SysCodeUtil.duGaoTimeMillis) {
					String newPedigreeCertifiedCode = dog.getPedigreeCertifiedCode().replace("CKU", "CKUDC");
					// 更新证书换发业务表外国血统证书号
					dogPedigreeCertifiedChange.setOverseasPedigreeCertified(newPedigreeCertifiedCode);
					// 更新血统证书涉及的表
					DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = new DogPedigreeCertifiedRedo();
					dogPedigreeCertifiedRedo.setDogGender(dog.getGender());
					dogPedigreeCertifiedRedo.setOriginalPedigreeCertified(dog.getPedigreeCertifiedCode());
					dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(newPedigreeCertifiedCode);
					dogPedigreeCertifiedRedoService.updatePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
					// 犬只信息表单独更新
					dog.setPedigreeCertifiedOld(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
					dog.setPedigreeCertifiedCode(dogPedigreeCertifiedRedo.getCurrentPedigreeCertified());
					dogService.save(dog);
				}
			} else {
				dog = insertDog(dogPedigreeCertifiedChange,dogType);
				// 生成犬只时更新DNA位点分析表的dogId和pedigreeCertified
				updateDogDnaArchive(dogPedigreeCertifiedChange.getOverseasPedigreeCertified(), dog);
				dogId = dog.getId();
			}
			dogPedigreeCertifiedChange.setDogId(dogId);
			super.save(dogPedigreeCertifiedChange);
			// 等级贴纸业务
			// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//			if ("1".equals(dogPedigreeCertifiedChange.getStickerFlag())) {
//				dogStickerApplyService.applySticker(dog, dogPedigreeCertifiedChange.getPaymentMemberCode(),
//						dogPedigreeCertifiedChange.getRunningNumber());
//			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * @description: 生成犬只信息
	 * @author: laiguanglong
	 * @date: 2016年8月12日 下午3:40:54
	 */
	private Dog insertDog(DogPedigreeCertifiedChange dogPedigreeCertifiedChange,DogType dogType) {
		Dog dog = new Dog();
		String fmdogBreedCertifiedCode = dogPedigreeCertifiedChange.getFmdogBreedCertifiedCode();
		DogAmphimixisProve dogAmphimixisProve = dogAmphimixisProveService.getMsg(fmdogBreedCertifiedCode);
		if (dogAmphimixisProve != null) {
			dog.setFdogPedigreeCertified(dogAmphimixisProve.getFdogPedigreeCertified());
			dog.setMdogPedigreeCertified(dogAmphimixisProve.getMdogPedigreeCertified());
			dog.setBreeder(dogAmphimixisProve.getBreeder());
		}
		dog.setMemberCode(dogPedigreeCertifiedChange.getPaymentMemberCode());
		dog.setDogOwner(dogPedigreeCertifiedChange.getDogOwnerName());
		dog.setPedigreeCertifiedCode(SysCodeUtil.getPedigreeCertifiedCode(dogPedigreeCertifiedChange.getDogBreed()));
		dog.setPedigreeCertifiedEn(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		dog.setDogBreed(dogPedigreeCertifiedChange.getDogBreed());
		// 设置FCi赛事编码
		List<DogTypeShow> dogTypeShowList = dogTypeShowService.findListByDogBreed(dog.getDogBreed());
		if (dogTypeShowList != null && dogTypeShowList.size() == 1) {
			dog.setShowDogBreed(dogTypeShowList.get(0).getDogShowCode());
		}
		dog.setNameEn(dogPedigreeCertifiedChange.getDogName());
		dog.setGender(dogPedigreeCertifiedChange.getDogGender());
		dog.setColorFlag(dogPedigreeCertifiedChange.getDogFurColor());
		dog.setBirthdate(dogPedigreeCertifiedChange.getDogBirthday());
		dog.setIdentificationFlag(dogPedigreeCertifiedChange.getDogChip());
		dog.setFmdogBreedCertifiedCode(dogPedigreeCertifiedChange.getFmdogBreedCertifiedCode());
		dog.setPrintState("2");// 打印血统证书
		dog.setDnaPayState("0");
		dog.setBreedPayState("0");
		// 证书换发的犬只代数为3
		dog.setDogGeneration(String.valueOf(
				restDogService.getDogGeneration(dog.getFdogPedigreeCertified(), dog.getMdogPedigreeCertified())));
		dog.setDogState("0");
		dog.setCallName(dogPedigreeCertifiedChange.getCallName());
		//增加标记 只有FCI正式认可可以申请出口
		dog.setChangeBan(!"formal".equals(dogType.getBreedClass())?"1":null);
		dogService.save(dog);
		return dog;
	}

	/**
	 * @description: 录入证书换发记录
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午5:24:53
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void add(DogPedigreeCertifiedChange add) throws ZAException {
		// 国外引进纯种犬单项登记的申请人应该是CKU专业会员。
		validateMDogOwner(add.getPaymentMemberCode());
		// 外国血统证书号查重
		DogPedigreeCertifiedChange example = dao
				.getByOverseasPedigreeCertified(add.getOverseasPedigreeCertified().toUpperCase());
		if (example != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该外国血统证书号已换发");
		}

		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = new DogPedigreeCertifiedChange();
		dogPedigreeCertifiedChange.setOverseasPedigreeCertified(add.getOverseasPedigreeCertified().toUpperCase());
		dogPedigreeCertifiedChange.setPaymentMemberCode(add.getPaymentMemberCode());
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(add.getPaymentChargingItemId());
		dogPedigreeCertifiedChange.setPrice(paymentChargingItem.getPrice());
		dogPedigreeCertifiedChange.setReviewState("0");
		dogPedigreeCertifiedChange.setRunningNumber(add.getRunningNumber());
		dogPedigreeCertifiedChange.setPaymentState("2");
		dogPedigreeCertifiedChange
				.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(add.getRunningNumber()));
		dogPedigreeCertifiedChange.setProcessState("0");
		// 判断该换发犬只是否CKU出口的犬只，不是返回NULL
		Dog dog = isCkuExportDog(add.getOverseasPedigreeCertified().toUpperCase());
		if (dog != null) {
			// 构建CKU的犬只进行证书换发
			buildCkuChange(dogPedigreeCertifiedChange, dog);
		} else {
			dogPedigreeCertifiedChange.setDogBreed(add.getDogBreed());
			String string = StringEscapeUtils.unescapeHtml4(add.getDogName());
			dogPedigreeCertifiedChange.setDogName(string.toUpperCase());
			dogPedigreeCertifiedChange.setDogGender(add.getDogGender());
			dogPedigreeCertifiedChange.setDogFurColor(add.getDogFurColor());
			dogPedigreeCertifiedChange.setDogBirthday(add.getDogBirthday());
			dogPedigreeCertifiedChange.setDogChip(add.getDogChip());
			dogPedigreeCertifiedChange.setAssociation(add.getAssociation());
		}
		if ("赛场换发".equals(add.getOrgId())) {
			dogPedigreeCertifiedChange.setOrgId(add.getOrgId());
			dogPedigreeCertifiedChange.setOrgName(add.getOrgId());
			// OA订单录入如果选择赛场换发默认审核通过
			dogPedigreeCertifiedChange.setReviewState("1");
		} else {
			Org org = orgDao.get(add.getOrgId());
			dogPedigreeCertifiedChange.setOrgId(org.getId());
			dogPedigreeCertifiedChange.setOrgName(org.getName());
		}
		super.save(dogPedigreeCertifiedChange);
		// 给用户发送消息
		sendMsg(dogPedigreeCertifiedChange);
	}

	/**
	 * @description: 校验会员是否为专业会员
	 * @author: laiguanglong
	 * @date: 2016年8月20日 上午11:42:58
	 */
	private void validateMDogOwner(String memberCode) throws ZAException {
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员的登录信息不存在");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员未续费");
		}
		if (!MemberUtil.isProfessionalMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员不是专业版会员");
		}
	}

	public DogPedigreeCertifiedChange getByOverseasPedigreeCertified(String overseasPedigreeCertified) {
		return dao.getByOverseasPedigreeCertified(overseasPedigreeCertified);
	}

	/**
	 * @description: 给用户发送消息，根据审核状态来判断发送内容
	 * @author: laiguanglong
	 * @date: 2016年8月19日 上午10:49:51
	 */
	private void sendMsg(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		String reviewState = dogPedigreeCertifiedChange.getReviewState();
		// 只有0，1，2的状态发消息
		if ("0".equals(reviewState) || "1".equals(reviewState) || "2".equals(reviewState)) {
			String content = null;
			if ("0".equals(reviewState)) {
				// 未审核状态，提交未缴费
				SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
				String dateString = formatter.format(new Date());
				content = "您于" + dateString + "提交了国外血统证书编号为“"
						+ dogPedigreeCertifiedChange.getOverseasPedigreeCertified()
						+ "”证书换发申请，请您务必于当日24时前完成缴费，过期订单失效哦。";
			} else if ("1".equals(reviewState)) {
				// 审核通过
				content = "您提交的国外血统证书编号为“" + dogPedigreeCertifiedChange.getOverseasPedigreeCertified()
						+ "”的证书换发申请审核通过，请注意查收邮件。";
			} else if ("2".equals(reviewState)) {
				// 审核不通过
				content = "您提交的国外血统证书编号为“" + dogPedigreeCertifiedChange.getOverseasPedigreeCertified()
						+ "”的证书换发审核未通过，请修改后重新提交。";
			}
			remindService.addRemind(content, dogPedigreeCertifiedChange.getPaymentMemberCode());
		}
	}

	/**
	 * @description: 获取已付款待审核的证书换发申请记录数
	 * @author: laiguanglong
	 * @date: 2016年8月29日 下午4:28:22
	 */
	public int getAuditCount() {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = new DogPedigreeCertifiedChange();
		// 已付款
		dogPedigreeCertifiedChange.setPaymentState("2");
		// 未审核
		dogPedigreeCertifiedChange.setReviewState("0");
		return dao.listCount(dogPedigreeCertifiedChange);
	}

	/**
	 * @description: 证书换发业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午6:18:14
	 */
	public void validateBusiness(DogPedigreeCertifiedChange po) {
		Member member = UserUtils.getLoginMember();
		// 校验会员为有效会员
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "会员无效,请续费后申请!");
		}
		// 校验专业会员
		if (!"professional".equals(member.getMemberType())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "只有专业会员才能申请证书换发");
		}
		// 外国血统证书号查重
		DogPedigreeCertifiedChange example = dao
				.getByOverseasPedigreeCertified(po.getOverseasPedigreeCertified().toUpperCase());
		if (example != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该外国血统证书号已换发");
		}
		// 等级贴纸业务
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(po.getStickerFlag()) && StringUtils.isNotEmpty(po.getDogChip())) {
//			dogStickerApplyService.basicValidate(po.getDogChip(), po.getPaymentMemberCode());
//		}
		// 所选机构为单犬种机构时判断登录人是否为机构下的会员
		Org org = orgDao.get(po.getOrgId());
		if ("singleTypeClub".equals(org.getOrgType()) && !(member.getMemberCode().equals(org.getAdminCode()))) {
			Member singleMember = memberService.singleMember(member.getMemberCode(), org.getUser().getLoginName());
			if (singleMember == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
			}
		}
	}

	/**
	 * @description: 判断该换发犬只是否CKU出口的犬只，不是返回NULL
	 * @author: laiguanglong
	 * @date: 2016/12/26 15:56
	 */
	public Dog isCkuExportDog(String overseasPedigreeCertified) {
		Dog dog = null;
		if (overseasPedigreeCertified.toUpperCase().startsWith("CKU")) {
			dog = dogService.getByPedigreeCertifiedCode(overseasPedigreeCertified);
			if (dog != null && !"5".equals(dog.getDogState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该CKU犬只状态不为已出口");
			}
		}
		return dog;
	}

	/**
	 * @description: 构建CKU的犬只进行证书换发
	 * @author: laiguanglong
	 * @date: 2016/12/26 17:16
	 */
	public void buildCkuChange(DogPedigreeCertifiedChange po, Dog dog) {
		po.setDogBreed(dog.getDogBreed());
		po.setDogName(dog.getNameEn());
		po.setDogGender(dog.getGender());
		po.setDogFurColor(dog.getColorFlag());
		po.setDogBirthday(dog.getBirthdate());
		po.setDogChip(dog.getIdentificationFlag());
		po.setAssociation("CKU");
		po.setDogId(dog.getId());
		po.setFmdogBreedCertifiedCode(dog.getFmdogBreedCertifiedCode());
	}

	/**
	 * @description: 撤销证书焕发 1只有审核未通过的可以撤销 2由于审核不通过后不能做后续的业务，只需要把证书换发表记录标记为已撤销即可
	 * @author: laiguanglong
	 * @date: 2017/5/9 14:05
	 */
	@Transactional(readOnly = false)
	public void canceled(DogPedigreeCertifiedChange po) {
		// 只有审核未通过的可以撤销
		if (!isCanCancel(po)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该申请不符合撤销条件");
		}
		po.setIsCanceled("1");
		User user = UserUtils.getLoginUser();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
		po.setRemarks(user.getName() + "于" + sdf.format(new Date()) + "撤销该记录");
		dao.update(po);
	}

	/**
	 * 合作机构里的审核芯片
	 *
	 * @param dogPedigreeCertifiedChange
	 */
	@Transactional(readOnly = false)
	public void toYesChip(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange2 = super.get(dogPedigreeCertifiedChange.getId());
		dogPedigreeCertifiedChange2.setDogChipCheck("1");
		dao.update(dogPedigreeCertifiedChange2);
	}

	/**
	 * 合作机构缴费芯片后的处理操作
	 *
	 * @param businessIds
	 */
	@Transactional(readOnly = false)
	public void afterPay(String businessIds) {
		DogChipChange dogChipChange = dogChipChangeService.get(businessIds);
		if (StringUtils.isBlank(dogChipChange.getBirthCode())
				&& StringUtils.isNotBlank(dogChipChange.getOverseasPedigreeCertified())) {
			String chipCodeNew = dogChipChange.getChipCodeNew();// 得到芯片
			DogPedigreeCertifiedChange byDogChipCode = dao
					.getByOverseasPedigreeCertified(dogChipChange.getOverseasPedigreeCertified());
			byDogChipCode.setDogChipCheck("1");
			byDogChipCode.setDogChip(chipCodeNew);
			dao.update(byDogChipCode);
		}
	}

	/**
	 * 根据国外证书号得到信息 (合作机构专用)
	 *
	 * @param overseasPedigreeCertified
	 * @return
	 */
	public DogPedigreeCertifiedChange getByUnPayPedigreeCertified(String overseasPedigreeCertified) {
		return dao.getByPedigreeCertified(overseasPedigreeCertified);
	}

	/**
	 * @description: 生成犬只时更新DNA位点分析表的dogId和pedigreeCertified
	 * @author: laiguanglong
	 * @date: 2017/5/18 11:55
	 */
	private void updateDogDnaArchive(String overseasPedigreeCertified, Dog dog) {
		DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByOverseasPedigreeCertified(overseasPedigreeCertified);
		if (dogDnaArchive != null) {
			dogDnaArchive.setDogId(dog.getId());
			dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
			dogDnaArchiveDao.update(dogDnaArchive);
		}
	}

	/**
	 * @description: 获取业务状态
	 * @author: laiguanglong
	 * @date: 2017/5/17 19:11
	 */
	public String getBusinessState(DogPedigreeCertifiedChange po) {
		if ("1".equals(po.getIsCanceled())) {
			return "已撤销";
		} else if ("2".equals(po.getReviewState())) {
			return "未通过";
		} else if ("1".equals(po.getReviewState())) {
			Dog dog = dogDao.getByPedigreeCertifiedEn(po.getOverseasPedigreeCertified());
			if (dog == null) {
				return "已通过";
			} else {
				if ("2".equals(dog.getPrintState())) {
					return "待打印";
				} else if ("02".equals(dog.getPrintState())) {
					if (po.getSendDate() != null && System.currentTimeMillis() > po.getSendDate().getTime()) {
						return "已寄出";
					} else {
						return "待邮寄";
					}
				}
			}
		} else if ("0".equals(po.getReviewState())) {
			if ("1".equals(po.getPaymentState())) {
				return "待支付";
			} else if ("2".equals(po.getPaymentState())) {
				return "待审核";
			}
		}
		return "";
	}

	/**
	 * @description: 是否能撤销，能撤销返回true
	 * @author: laiguanglong
	 * @date: 2017/5/18 16:38
	 */
	public boolean isCanCancel(DogPedigreeCertifiedChange po) {
		boolean flag = false;
		if ("0".equals(po.getIsCanceled())) {
			if ("2".equals(po.getReviewState())) {
				// 审核不通过，可以撤销
				flag = true;
			} else if ("1".equals(po.getReviewState())) {
				// 审核通过，以下条件可以撤销
				if ("0".equals(po.getDogChipCheck())) {
					// 犬只芯片校验未通过，未支付芯片费
					flag = true;
				} else if ("1".equals(po.getDogChipCheck())) {
					DogChipChange dogChipChange = dogChipChangeDao.getByIdentificationFlag(po.getDogChip());
					if (dogChipChange == null) {
						// 不需要缴纳芯片费，且没有缴纳位点分析费
						if (StringUtils.isBlank(po.getDogDnaArchiveId())) {
							flag = true;
						}
					} else {
						// 需要缴纳芯片费，且没有付款
						if (!"2".equals(dogChipChange.getPaymentState())) {
							flag = true;
						}
					}
				}
			}
		}
		return flag;
	}

	/**
	 * @description: 添加DNA存档订单页面，根据外国血统证书号查询犬只信息
	 * @author: laiguanglong
	 * @date: 2016年8月23日 下午5:22:03
	 */
	public HashMap<String, String> getMessageByOverseasPedigreeCertified(String overseasPedigreeCertified) {
		HashMap<String, String> map = new HashMap<String, String>();
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dao
				.getByOverseasPedigreeCertified(overseasPedigreeCertified);
		String flag = "failure";
		if (dogPedigreeCertifiedChange != null) {
			map.put("nameEn", dogPedigreeCertifiedChange.getDogName());
			map.put("birthdate", DateUtils.dateToStr(dogPedigreeCertifiedChange.getDogBirthday()));
			map.put("gender", DictUtils.getDictLabel(dogPedigreeCertifiedChange.getDogGender(), "dog_gender", ""));
			map.put("colorFlag", dogPedigreeCertifiedChange.getDogFurColor());
			map.put("identificationFlag", dogPedigreeCertifiedChange.getDogChip());
			DogType dogType = dogTypeService.getByDogBreedCode(dogPedigreeCertifiedChange.getDogBreed());
			if (dogType != null) {
				map.put("dogBreed", dogType.getBreedCnName());
			}
			flag = "success";
		}
		map.put("flag", flag);
		return map;
	}

	public DogPedigreeCertifiedChange getByDogId(String dogId) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = null;
		Dog dog = dogDao.get(dogId);
		if (dog != null && StringUtils.isNotBlank(dog.getPedigreeCertifiedEn())) {
			dogPedigreeCertifiedChange = dao.getByPedigreeCertified(dog.getPedigreeCertifiedEn());
		}
		return dogPedigreeCertifiedChange;
	}

	public DogPedigreeCertifiedChange getByDogIdOrDogChip(String dogId, String dogChip) {
		return dao.getByDogIdOrDogChip(dogId, dogChip);

	}

	public int updateChange(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		return dao.update(dogPedigreeCertifiedChange);
	}
}