package com.cku.oa.dog.service;

import static com.cku.restful.v1.dog.service.RestDogOwnerChangeService.PAYMENTCHARGINGITEM_SHORTNAME_ALL;
import static com.cku.restful.v1.dog.service.RestDogOwnerChangeService.PAYMENTCHARGINGITEM_SHORTNAME_ALL0;
import static com.cku.restful.v1.dog.service.RestDogOwnerChangeService.PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogOwnerChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogOwnerChange;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.util.Debugger;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬主变更申请Service
 *
 * @author zhuoHeng
 * @version 2016-08-17
 */
@Service
@Transactional(readOnly = true)
public class DogOwnerChangeService extends CrudService<DogOwnerChangeDao, DogOwnerChange> {

	@Autowired
	public DogDao dogDao;
	@Autowired
	private RemindService remindService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private StudDogService studDogService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private DogChipMemberLockService dogChipMemberLockService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	public DogOwnerChange get(String id) {
		return super.get(id);
	}

	public List<DogOwnerChange> findList(DogOwnerChange dogOwnerChange) {
		if (StringUtils.isBlank(dogOwnerChange.getDogBreed())) {
			dogOwnerChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogOwnerChange.getSqlMap().put("dogBreedMap", " ='" + dogOwnerChange.getDogBreed() + "'");
		}
		return super.findList(dogOwnerChange);
	}

	public Page<DogOwnerChange> findPage(Page<DogOwnerChange> page, DogOwnerChange dogOwnerChange) {
		if (StringUtils.isBlank(dogOwnerChange.getDogBreed())) {
			dogOwnerChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogOwnerChange.getSqlMap().put("dogBreedMap", " ='" + dogOwnerChange.getDogBreed() + "'");
		}
		return super.findPage(page, dogOwnerChange);
	}

	@Transactional(readOnly = false)
	public void save(DogOwnerChange dogOwnerChange) {
		super.save(dogOwnerChange);
	}

	@Transactional(readOnly = false)
	public void delete(DogOwnerChange dogOwnerChange) {
		super.delete(dogOwnerChange);
	}

	/**
	 * @Description：犬主变更审核状态更改
	 * @author: zhuoHeng
	 * @version: 2016年8月19日 上午10:56:07
	 */
	@Transactional(readOnly = false)
	public void changeStatus(DogOwnerChange dogOwnerChange) throws ZAException {
		DogOwnerChange dogOwnerChangeModel = super.get(dogOwnerChange.getId());
		String reviewState = dogOwnerChangeModel.getReviewState();
		//特殊处理，因犬主变更审核不通过的数据可以修改为审核通过，此处将审核未通过的状态当成未审核来处理，以迎合状态机公用
		if ("2".equals(dogOwnerChangeModel.getReviewState())) {
			reviewState = "0";
		}
		SysContext sysContext = new SysContext(dogOwnerChangeModel.getPaymentState(), reviewState,
				dogOwnerChangeModel.getProcessState() == null ? "0" : dogOwnerChangeModel.getProcessState());
		if ("1".equals(dogOwnerChange.getReviewState())) {
			sysContext.confirmSuccess(sysContext, "犬主变更", dogOwnerChangeModel.getPaymentMemberCode(), "dog_owner_change", dogOwnerChangeModel.getId(), dogOwnerChangeModel.getRunningNumber(), (str) -> {
				if (dogOwnerChangeModel.getDogId() != null && !"".equals(dogOwnerChangeModel.getDogId())) {
					dogOwnerChange.setReviewRemarks("");
				} else {
					throw new ZAException(-1, "未找到有效的血统证书号");
				}
			});

		} else if ("2".equals(dogOwnerChange.getReviewState())) {
			sysContext.confirmFail(sysContext, "犬主变更", dogOwnerChange.getReviewRemarks(), dogOwnerChangeModel.getPaymentMemberCode(), "dog_owner_change", dogOwnerChangeModel.getId(), dogOwnerChangeModel.getRunningNumber(), (str) -> {

			});
		}
		dogOwnerChange.setReviewer("协会");
		dogOwnerChange.setReviewTime(new Date());
		dao.changeStatus(dogOwnerChange);
		sendMsg(dogOwnerChange);
	}

	/**
	 * @Description：犬主变更编辑保存
	 * @author: zhuoHeng
	 * @version: 2016年8月19日 下午6:28:04
	 */
	@Transactional(readOnly = false)
	public void edit(DogOwnerChange dogOwnerChange) {
		dogOwnerChange.setUpdateDate(new Date());
		dao.edit(dogOwnerChange);
	}

	/**
	 * @Description：更改犬主变更处理状态并更新犬主信息
	 * @author: zhuoHeng
	 * @version: 2016年8月20日 下午5:01:05
	 */
	@Transactional(readOnly = false)
	public void changeProcessState(DogOwnerChange dogOwnerChange) throws ZAException {
		DogOwnerChange ownerChange = super.get(dogOwnerChange.getId());
		//处理前校验犬只状态
		Dog d = dogDao.get(ownerChange.getDogId());
		if (!"0".equals(d.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只状态不为正常，不能进行变更犬主处理");
		}
		SysContext sysContext = new SysContext(ownerChange.getPaymentState(), ownerChange.getReviewState(),
				ownerChange.getProcessState() == null ? "0" : ownerChange.getProcessState());
		sysContext.updateData(sysContext, "新生犬登记", ownerChange.getPaymentMemberCode(), "dog_owner_change", ownerChange.getId(), ownerChange.getRunningNumber(), (str) -> {
			Dog dog = new Dog();
			dog.setId(ownerChange.getDogId());
			dog.setDogOwner(dogOwnerChange.getNewOwnerName());
			dog.setMemberCode(dogOwnerChange.getNewOwnerMemberCode());
			dogOwnerChange.setProcessTime(new Date());
			dogOwnerChange.setProcessState("1");
			dao.changeProcessState(dogOwnerChange);
			dogDao.updateDogOwner(dog);
			studDogService.updateMemberCode(dogOwnerChange.getNewOwnerMemberCode(), dogOwnerChange.getDogId());
			//更新
			//查询原犬主此狗可用的参赛卷
			SysCoupon sysCoupon = new SysCoupon();
			sysCoupon.setMemberCode(dogOwnerChange.getOriginOwnerMemberCode());
			sysCoupon.setState("0");//可用的
			if (StringUtils.isNotBlank(d.getPedigreeCertifiedCode())) {
				sysCoupon.setTargetId(d.getPedigreeCertifiedCode());
				List<SysCoupon> sList = sysCouponService.findList(sysCoupon);
				for (int i = 0; i < sList.size(); i++) {
					SysCoupon sys = sList.get(i);
					if (sys.getCouponName().equals("CAC赛事免费参赛券")||sys.getCouponName().equals("CAC犬展免费参展券")) {
						sys.preUpdate();
						sys.setMemberCode(dogOwnerChange.getNewOwnerMemberCode());
						sysCouponService.updateMemberCode(sys);
					}
				}
			}
		});

		// TODO 财务收入确认时点
		saPaymentDetailTotalService.financeConfirmTime(dogOwnerChange.getId(), "dog_owner_change");
	}


	/**
	 * @description: 获取已付款待审核的犬主变更申请记录数
	 * @author: laiguanglong
	 * @date: 2016年8月29日 下午4:52:58
	 */
	public int getAuditCount() {
		DogOwnerChange dogOwnerChange = new DogOwnerChange();
		//已付款
		dogOwnerChange.setPaymentState("2");
		//已审核
		dogOwnerChange.setReviewState("1");
		//未处理
		dogOwnerChange.setProcessState("0");
		return dao.listCount(dogOwnerChange);
	}

	/**
	 * @Description：给用户发送消息，根据审核状态和缴费状态来判断发送内容
	 * @author: zhuoHeng
	 * @version: 2016年9月1日 下午3:32:44
	 */
	public void sendMsg(DogOwnerChange dogOwnerChange) {
		String reviewState = dogOwnerChange.getReviewState();
		if ("0".equals(reviewState) || "1".equals(reviewState) || "2".equals(reviewState)) {
			String content = "";
			//未审核
			if ("0".equals(reviewState)) {
				//已提交
				if ("9".equals(dogOwnerChange.getPaymentState())) {
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
					String dateString = formatter.format(new Date());
					content = "您于" + dateString + "提交了血统证书号为“" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "”犬主变更申请，请您务必于当日24时前完成缴费，过期订单失效哦。";
				}
			} else if ("1".equals(reviewState)) {
				content = "您提交的血统证书号为“" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "”的犬主变更申请审核通过。";
			} else if ("2".equals(reviewState)) {
				content = "您提交的血统证书号为“" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "”的犬主变更申请审核未通过，请进入会员中心查看未通过原因，修改后重新提交。";
			}
			remindService.addRemind(content, dogOwnerChange.getNewOwnerMemberCode());
		}
	}

	/**
	 * @Description：犬主变更业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午3:30:20
	 */
	@Transactional(readOnly = false)
	public ResultDto<String> orderSave(DogOwnerChange dogOwnerChange) {
		//校验会员是否为犬只芯片绑定会员
		Dog dog = dogService.get(dogOwnerChange.getDogId());
		dogChipMemberLockService.checkDogLocked(dogOwnerChange.getNewOwnerMemberCode(), dog.getIdentificationFlag());
		//校验是否有重复数据
		int count = dao.validateApply(dogOwnerChange.getDogId());
		if (count > 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该犬只存在未处理的犬主变更记录！");
		}
		dogOwnerChange.setCreateDate(new Date());
		dogOwnerChange.setReviewState("0");
		dogOwnerChange.setPaymentState("2");
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(dogOwnerChange.getRunningNumber());
		dogOwnerChange.setPaymentTime(paymentOrder.getCreateDate());
		dogOwnerChange.setPaymentTime(new Date());
		dogOwnerChange.setProcessState("0");
		dogOwnerChange.setPaymentMemberCode(dogOwnerChange.getNewOwnerMemberCode());
		super.save(dogOwnerChange);

		return ResultDto.success("保存犬主变更成功");
	}

	/**
	 * @description: 业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:39:02
	 */
	public void validateBusiness(DogOwnerChange po) {
		//犬只状态的校验
		Dog dog = StringUtils.isBlank(po.getDog().getPedigreeCertifiedCode()) ? null : dogDao.getByPedigreeCertifiedCode(po.getDog().getPedigreeCertifiedCode());
		//血统证书号必须以CKU开头
		if (!dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号必须为CKU证书号");
		}
		Debugger.doAssert("0".equals(dog.getDogState()), ZAErrorCode.ZA_VALID_FAILED, "犬只状态不正常");
		if ("230".equals(dog.getDogBreed()) && !dogDnaService.isHaveDogDna(dog.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该藏獒未完成DNA位点分析，不允许申请犬主变更");
		}
		//血统证书犬主不能为当前账号主人
		Member member = UserUtils.getLoginMember();
		if (dog.getMemberCode().equals(member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬主人已为当前登录用户");
		}
//		1006203 工单要求去掉关于禁赛时间的要求
//		Member dogOwnerMemberCode = memberService.getByMemberCode(dog.getMemberCode());
//		Date banEndDate = dogOwnerMemberCode.getBanEndDate();
//		if (banEndDate != null && !"".equals(banEndDate)) {
//			if (banEndDate.after(new Date())) {
//				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬主人处于禁赛期");
//			}
//		}
//		if(member != null && (member.getMemberEndDate() == null  || new Date().getTime() > member.getMemberEndDate().getTime())){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员为无效会员，不允许申请证书补做");
//		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的会员身份已经过期，无法办理该业务");
		}

		//校验会员是否为犬只芯片绑定会员
		dogChipMemberLockService.checkDogLocked(member.getMemberCode(), dog.getIdentificationFlag());

		//血统证书无未处理的变更信息(初始化订单为未处理，故已包括订单重复校验)
		DogOwnerChange example = new DogOwnerChange();
		example.setDogId(po.getDogId());
		example.setProcessState("0");
		example.setDelFlag("0");//排除已经删除数据
		List<DogOwnerChange> dogOwnerChangeList = super.findList(example);
		for (Iterator<DogOwnerChange> it = dogOwnerChangeList.iterator(); it.hasNext(); ) {
			DogOwnerChange dogOwnerChange = it.next();
			if ("3".equals(dogOwnerChange.getReviewState())) {
				//排除已注销的记录
				it.remove();
			}
			if ("2".equals(dogOwnerChange.getReviewState())) {
				//排除未通过的记录,并将未通过的改为注销状态
				dogOwnerChange.setReviewState("3");
				SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
				dogOwnerChange.setReviewRemarks("犬主于" + formatter.format(dogOwnerChange.getReviewTime()) + "审核未通过,备注:" + dogOwnerChange.getReviewRemarks() + ";该犬主变更已注销，请联系原犬主");
				dogOwnerChange.setReviewTime(new Date());
				dao.changeStatus(dogOwnerChange);
				it.remove();
			}
		}
		if (dogOwnerChangeList.size() != 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只有未处理的犬主变更申请，不允许申请犬主变更");
		}
		//当前账号会员有效
		//新版APP去掉此限制 zjw 2020.04.08
//		if(!MemberUtil.isActiveMember(member)){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前会员未无效会员，请进行续费后再申请犬主变更");
//		}
	}

	public PaymentChargingItem getPaymentChargingItem(String dogBreed) {
		String shortName = getPaymentChargingItemShortName(dogBreed);
		return paymentChargingItemService.getByShortName(shortName);
	}

	public String getPaymentChargingItemShortName(String dogBreed) {
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dogBreed)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		return shortName;
	}

	public PaymentChargingItem getPaymentChargingItemSale() {
		return paymentChargingItemService.getByShortName(getPaymentChargingItemShortNameSale());
	}

	public String getPaymentChargingItemShortNameSale() {
		return PAYMENTCHARGINGITEM_SHORTNAME_ALL0;
	}
	
	
	public Integer countDogOwnerChangeByReviewTime(Date reviewTime,String dogId) {
		return dao.countDogOwnerChangeByReviewTime(reviewTime, dogId);
	}

}