package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestJudgeTypeClass;
import com.cku.oa.contest.service.ContestJudgeTypeClassService;

/**
 * 赛制年龄组别对照Controller
 * @author yuanshuai
 * @version 2020-11-05
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestJudgeTypeClass")
public class ContestJudgeTypeClassController extends BaseController {

	@Autowired
	private ContestJudgeTypeClassService contestJudgeTypeClassService;
	
	@ModelAttribute
	public ContestJudgeTypeClass get(@RequestParam(required=false) String id) {
		ContestJudgeTypeClass entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestJudgeTypeClassService.get(id);
		}
		if (entity == null){
			entity = new ContestJudgeTypeClass();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestJudgeTypeClass:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestJudgeTypeClass contestJudgeTypeClass, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestJudgeTypeClass> page = contestJudgeTypeClassService.findPage(new Page<ContestJudgeTypeClass>(request, response), contestJudgeTypeClass); 
		model.addAttribute("page", page);
		return "oa/contest/contestJudgeTypeClassList";
	}

	@RequiresPermissions("contest:contestJudgeTypeClass:view")
	@RequestMapping(value = "form")
	public String form(ContestJudgeTypeClass contestJudgeTypeClass, Model model) {
		model.addAttribute("contestJudgeTypeClass", contestJudgeTypeClass);
		return "oa/contest/contestJudgeTypeClassForm";
	}

	@RequiresPermissions("contest:contestJudgeTypeClass:edit")
	@RequestMapping(value = "save")
	public String save(ContestJudgeTypeClass contestJudgeTypeClass, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestJudgeTypeClass)){
			return form(contestJudgeTypeClass, model);
		}
		contestJudgeTypeClassService.save(contestJudgeTypeClass);
		addMessage(redirectAttributes, "保存规则年龄组别对照成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestJudgeTypeClass/?repage";
	}
	
	@RequiresPermissions("contest:contestJudgeTypeClass:del")
	@RequestMapping(value = "delete")
	public String delete(ContestJudgeTypeClass contestJudgeTypeClass, RedirectAttributes redirectAttributes) {
		contestJudgeTypeClassService.delete(contestJudgeTypeClass);
		addMessage(redirectAttributes, "删除规则年龄组别对照成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestJudgeTypeClass/?repage";
	}

}