package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestBreedXref;
import com.cku.oa.contest.service.ContestBreedXrefService;

/**
 * 犬展活动区域犬种补充Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestBreedXref")
public class ContestBreedXrefController extends BaseController {

	@Autowired
	private ContestBreedXrefService contestBreedXrefService;
	
	@ModelAttribute
	public ContestBreedXref get(@RequestParam(required=false) String id) {
		ContestBreedXref entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestBreedXrefService.get(id);
		}
		if (entity == null){
			entity = new ContestBreedXref();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestBreedXref:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestBreedXref contestBreedXref, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestBreedXref> page = contestBreedXrefService.findPage(new Page<ContestBreedXref>(request, response), contestBreedXref); 
		model.addAttribute("page", page);
		return "oa/contest/contestBreedXrefList";
	}

	@RequiresPermissions("contest:contestBreedXref:view")
	@RequestMapping(value = "form")
	public String form(ContestBreedXref contestBreedXref, Model model) {
		model.addAttribute("contestBreedXref", contestBreedXref);
		return "oa/contest/contestBreedXrefForm";
	}

	@RequiresPermissions("contest:contestBreedXref:edit")
	@RequestMapping(value = "save")
	public String save(ContestBreedXref contestBreedXref, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestBreedXref)){
			return form(contestBreedXref, model);
		}
		contestBreedXrefService.save(contestBreedXref);
		addMessage(redirectAttributes, "保存犬展活动区域犬种补充成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestBreedXref/?repage";
	}
	
	@RequiresPermissions("contest:contestBreedXref:del")
	@RequestMapping(value = "delete")
	public String delete(ContestBreedXref contestBreedXref, RedirectAttributes redirectAttributes) {
		contestBreedXrefService.delete(contestBreedXref);
		addMessage(redirectAttributes, "删除犬展活动区域犬种补充成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestBreedXref/?repage";
	}

}