package com.cku.oa.contest.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.dao.LanguageDao;

/**
 * 语言Service
 * @author yuanshuai
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class LanguageService extends CrudService<LanguageDao, Language> {

	public Language get(String id) {
		return super.get(id);
	}
	
	public List<Language> findList(Language language) {
		return super.findList(language);
	}
	
	public Page<Language> findPage(Page<Language> page, Language language) {
		return super.findPage(page, language);
	}
	
	@Transactional(readOnly = false)
	public void save(Language language) {
		super.save(language);
	}
	
	@Transactional(readOnly = false)
	public void delete(Language language) {
		super.delete(language);
	}
	
}