package com.cku.oa.contest.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.contest.dao.ContestWinnerDao;
import com.cku.oa.contest.entity.ContestExhibit;
import com.cku.oa.contest.entity.ContestGrade;
import com.cku.oa.contest.entity.ContestWinner;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.show.entity.*;
import com.cku.oa.show.service.*;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

import static com.cku.restful.v1.contest.service.RestCkuContestService.CONTEST_CHILD;

/**
 * 赛场成绩Service
 *
 * @author yuanshuai
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class ContestWinnerService extends CrudService<ContestWinnerDao, ContestWinner> {

	@Autowired
	private DogService dogService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private ShowJudgeService showJudgeService;
	@Autowired
	private ShowResultsService showResultsService;
	@Autowired
	private ContestExhibitService contestExhibitService;
	@Autowired
	private ContestGradeService contestGradeService;

	public ContestWinner get(String id) {
		return super.get(id);
	}

	public List<ContestWinner> findList(ContestWinner contestWinner) {
		return super.findList(contestWinner);
	}

	public Page<ContestWinner> findPage(Page<ContestWinner> page, ContestWinner contestWinner) {
		return super.findPage(page, contestWinner);
	}

	@Transactional(readOnly = false)
	public void save(ContestWinner contestWinner) {
		super.save(contestWinner);
	}

	@Transactional(readOnly = false)
	public void delete(ContestWinner contestWinner) {
		super.delete(contestWinner);
	}

	/**
	 * @Description： 校验数据唯一
	 * @author: yuanshuai
	 * @date: 2020/11/10 10:23
	 */
	public boolean checkDataUnique(ContestWinner contestWinner) {
		Integer integer = dao.checkDataUnique(contestWinner);
		if (integer == null || integer.equals(0)) {
			return true;
		}
		return false;
	}

	/**
	 * @Description： 新增数据
	 * @author: yuanshuai
	 * @date: 2020/11/10 10:33
	 */
	@Transactional(readOnly = false)
	public void insert(ContestWinner contestWinner) {
		contestWinner.preInsert();
		dao.insert(contestWinner);
	}

	/**
	 * @Description： 更新成绩数据
	 * @author: yuanshuai
	 * @date: 2020/11/10 10:36
	 */
	@Transactional(readOnly = false)
	public void updateWinner(ContestWinner contestWinner) {
		contestWinner.preUpdate();
		dao.updateWinner(contestWinner);
	}

	public List<ContestWinner> getWinnerByContest(String contestId, String type) {
		return dao.getWinnerByContest(contestId, type);
	}

	/**
	 * @Description 生成犬展成绩
	 * @author yuanshuai
	 * @date 2020/11/13 14:56
	 */
	@Transactional(readOnly = false)
	public void createResult(String childShowId) {
		if (StringUtils.isBlank(childShowId)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "犬展编号有误。");
		}
		ChildShows childShows = childShowsService.get(childShowId);
		MainShows mainShows = mainShowsService.get(childShows.getMainShowId());
		ContestWinner search = new ContestWinner();
		search.setContestNo(childShowId);
		List<ContestWinner> winnerList = findList(search);
		if (winnerList == null || winnerList.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该场子犬展无成绩。");
		}

		List<ContestExhibit> exhibitList = contestExhibitService.getExhibitListByContest(childShowId, CONTEST_CHILD);
		for (ContestExhibit exhibit : exhibitList) {
			//获取犬只信息
			ShowApply showApply = showApplyService.getByShowMainIdAndPedigreeCertified(childShows.getMainShowId(), exhibit.getPedigreeCode());
			if (showApply == null || StringUtils.isBlank(showApply.getId())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "该场子犬展信息有误，找不到证书号" + exhibit.getPedigreeCode() + "的犬只报名信息，如有疑问请联系技术部");
			}
			Dog dog = dogService.getByPedigreeCertifiedCode(exhibit.getPedigreeCode());
			if (dog == null || StringUtils.isBlank(dog.getId())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "该场子犬展信息有误，找不到证书号" + exhibit.getPedigreeCode() + "的犬只，如有疑问请联系技术部");
			}
			//判断是否已有成绩
			if (showResultsService.checkResultByShowCodeAndPedigreeCertified(childShows.getShowCode(), exhibit.getPedigreeCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有血统证书号为" + exhibit.getPedigreeCode() + ",犬展编号为" + exhibit.getPedigreeCode() + "的成绩记录");
			}
			//初始化构造成绩对象
			ShowResults results = new ShowResults();
			//犬展年份
			results.setYear(mainShows.getYear());
			//犬展编号
			results.setShowCode(childShows.getShowCode());
			//裁判
			if (!StringUtils.isBlank(childShows.getReferee())) {
				ShowJudge judge = showJudgeService.get(childShows.getReferee().split(",")[0]);
				results.setReferee("(" + judge.getCitizenship() + ")" + judge.getJudgeName());
			}
			//犬只信息
			results.setDogId(dog.getId());
			results.setPedigreeCertified(exhibit.getPedigreeCode());
			results.setOtherCertified(showApply.getOtherCertified());
			results.setDogBreedGroup(showApply.getDogBreedGroup());
			results.setAgeGroup(ContestExhibitService.getCurrentAgeGroup(childShows.getShowCode(), showApply.getShowCode(), showApply.getAgeGroup()));
			results.setDogGender(showApply.getDogGender());
			results.setFciCode(showApply.getFciCode());
			//犬主信息
			results.setDogOwnerNameCn(showApply.getDogOwnerNameCn());
			results.setDogOwnerNameEn(showApply.getDogOwnerNameEn());
			results.setDogOwnerMemberCode(showApply.getDogOwnerMemberCode());
			//参赛信息
			results.setOrderCode(exhibit.getExhibitNo());
			//赛圈信息
			results.setRaceLap(exhibit.getRaceLap());
			//获取评价
			ContestGrade grade = contestGradeService.getByCodeAndAgeGroup(exhibit.getGrade(), exhibit.getClassNo());
			results.setAppraisal(grade.getCode());
			//成绩信息
			//积分默认为0
			results.setShowResult("0");
			//根据Winner生成成绩
			buildResultByWinner(results, childShows);
			//保存成绩
			showResultsService.save(results);
		}
		//修改是否生成成绩标记位
		childShows.setWinnerState("2");
		childShowsService.updateWinnerState(childShows);
	}

	/**
	 * @Description 根据奖项生成成绩
	 * @author yuanshuai
	 * @date 2020/11/13 16:01
	 */
	@Transactional(readOnly = false)
	private void buildResultByWinner(ShowResults results, ChildShows childShows) {
		Map<String, String> winnerMap = dao.getWinnerMapByDogAndContest(results.getOrderCode(), childShows.getId());
		//如果评价不为1则无成绩
		if (!("VP".equals(results.getAppraisal()) || "VP".equals(results.getAppraisal()))) {
			return;
		}
		//cc类和wb/wd
		String cc = null, wbWd = null;
		String classNo = String.valueOf(winnerMap.get("class_no"));
		String classPosition = winnerMap.get("classPosition");
		String genderTitle = "1".equals(results.getDogGender()) ? "D" : "B";
		//青年
		if ("3".equals(classNo)) {
			if ("1".equals(classPosition)) {
				cc = "JCC";
			} else if ("2".equals(classPosition)) {
				cc = "RJCC";
			}
		}
		if ("0".equals(childShows.getCacType())) {
			//cac
			String cacPosition = winnerMap.get("cacPosition");
			if ("1".equals(cacPosition)
					|| "1".equals(classPosition)) {
				wbWd = "W" + genderTitle;
				cc = "CC";
			} else if ("2".equals(cacPosition)
					|| "2".equals(classPosition)) {
				wbWd = "RW" + genderTitle;
				cc = "RCC";
			} else if ("6".equals(classNo) && "1".equals(classPosition)) {
				wbWd = "CH" + genderTitle;
				cc = "GCC";
			} else if ("10".equals(classNo) && "1".equals(classPosition)) {
				wbWd = "V" + genderTitle;
			}

		} else {
			//cacib
			String cacibPosition = winnerMap.get("cacibPosition");
			if ("1".equals(cacibPosition)
					|| "1".equals(classPosition)) {
				wbWd = "W" + genderTitle;
				cc = "CC";
			} else if ("2".equals(cacibPosition)
					|| "2".equals(classPosition)) {
				wbWd = "RW" + genderTitle;
				cc = "RCC";
			} else if ("3".equals(classNo) && "1".equals(classPosition)) {
				wbWd = "J" + genderTitle;
			} else if ("10".equals(classNo) && "1".equals(classPosition)) {
				wbWd = "V" + genderTitle;
			}

		}
		results.setResultCc(cc);
		results.setResultWb(wbWd);
		//bob类
		String bob = winnerMap.get("bob");
		if (StringUtils.isBlank(bob)) {
			bob = winnerMap.get("bos");
		}
		if (StringUtils.isBlank(bob)) {
			bob = winnerMap.get("bpbob");
		}
		if (StringUtils.isBlank(bob)) {
			bob = winnerMap.get("bpbos");
		}
		if (StringUtils.isBlank(bob)) {
			bob = winnerMap.get("pbob");
		}
		if (StringUtils.isBlank(bob)) {
			bob = winnerMap.get("pbos");
		}
		results.setResultBob(StringUtils.isBlank(bob) ? null : bob.toUpperCase());
		//bow类
		results.setResultBow(StringUtils.isBlank(winnerMap.get("bow")) ? null : winnerMap.get("bow").toUpperCase());
		//boj类
		String boj = winnerMap.get("boj");
		if (StringUtils.isBlank(boj)) {
			boj = winnerMap.get("jbos");
		}
		results.setResultBoj(StringUtils.isBlank(boj) ? null : boj.toUpperCase());
		//boh类
		results.setResultOhcBoh(StringUtils.isBlank(winnerMap.get("boh")) ? null : winnerMap.get("boh").toUpperCase());
		//big类
		String big = winnerMap.get("big");
		if (StringUtils.isBlank(big)) {
			big = winnerMap.get("bpbig");
		}
		if (StringUtils.isBlank(big)) {
			big = winnerMap.get("pbig");
		}
		results.setResultBig(StringUtils.isBlank(big) ? null : big.toUpperCase());
		//jbig类
		results.setResultJbig(StringUtils.isBlank(winnerMap.get("jbig")) ? null : winnerMap.get("jbig").toUpperCase());
		//ohcbig类
		results.setResultOhcBig(StringUtils.isBlank(winnerMap.get("ohcbig")) ? null : winnerMap.get("ohcbig").toUpperCase());
		//bis类
		String bis = winnerMap.get("bis");
		if (StringUtils.isBlank(big)) {
			bis = winnerMap.get("bpbis");
		}
		if (StringUtils.isBlank(big)) {
			bis = winnerMap.get("pbis");
		}
		results.setResultBis(StringUtils.isBlank(bis) ? null : bis.toUpperCase());
		//jbis类
		results.setResultJbis(StringUtils.isBlank(winnerMap.get("jbis")) ? null : winnerMap.get("jbis").toUpperCase());
		//ohcbis类
		results.setResultOhcBis(StringUtils.isBlank(winnerMap.get("ohcbis")) ? null : winnerMap.get("ohcbis").toUpperCase());
	}

	/**
	 * @Description 根据成绩获取狗信息
	 * @author yuanshuai
	 * @date 2020/11/13 15:34
	 */
	public ContestExhibit getApplyDogByWinner(ContestWinner winner, List<ContestExhibit> exhibitList) {
		for (ContestExhibit exhibit : exhibitList) {
			if (winner.getExhibitNo().equals(exhibit.getExhibitNo())
					&& winner.getClassNo().equals(exhibit.getContestNo())) {
				return exhibit;
			}
		}
		return null;
	}
}