package com.cku.oa.contest.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.contest.dao.ContestExhibitDao;
import com.cku.oa.contest.entity.ContestBreed;
import com.cku.oa.contest.entity.ContestExhibit;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.show.entity.ChildShows;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import static com.cku.restful.v1.contest.service.RestCkuContestService.CONTEST_MAIN;

/**
 * 赛场犬只Service
 *
 * @author yuanshuai
 * @version 2020-09-30
 */
@Service
@Transactional(readOnly = true)
public class ContestExhibitService extends CrudService<ContestExhibitDao, ContestExhibit> {

	@Autowired
	private ChildShowsDao childShowsDao;
	@Autowired
	private ContestBreedService contestBreedService;

	public ContestExhibit get(String id) {
		return super.get(id);
	}

	public List<ContestExhibit> findList(ContestExhibit contestExhibit) {
		return super.findList(contestExhibit);
	}

	public Page<ContestExhibit> findPage(Page<ContestExhibit> page, ContestExhibit contestExhibit) {
		return super.findPage(page, contestExhibit);
	}

	@Transactional(readOnly = false)
	public void save(ContestExhibit contestExhibit) {
		super.save(contestExhibit);
	}

	@Transactional(readOnly = false)
	public void delete(ContestExhibit contestExhibit) {
		super.delete(contestExhibit);
	}

	/**
	 * @Description： 导入赛场犬只
	 * @author: yuanshuai
	 * @date: 2020/09/30 15:36
	 */
	@Transactional(readOnly = false)
	public int importContestDog(MultipartFile file) throws Exception {
		int count = 0;
		try {
			//模版中需要开头空一行，从第3行开始读取，否则会少读一行
			ImportExcel ei = new ImportExcel(file, 1, 0);
			List<ContestExhibit> list = ei.getDataList(ContestExhibit.class);
			//判断成绩是否已经录入
			List<ContestExhibit> poList = getExhibitListByContest(list.get(0).getContestEventNo(), CONTEST_MAIN);
			if (!CollectionUtils.isEmpty(poList)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此场成绩已经录入，如需再次录入，请联系技术部处理");
			}
			//判断是否空表
			boolean flag = true;
			for (ContestExhibit contestExhibit : list) {
				//跳过无效记录
				if (StringUtils.isBlank(contestExhibit.getExhibitNo())) {
					continue;
				}
				flag = false;
				//查询子赛事信息
				ChildShows childShows = childShowsDao.getByShowCode(contestExhibit.getContestNo());
				if (childShows == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到为" + contestExhibit.getContestNo() + "的犬展信息！");
				}
				contestExhibit.setContestNo(childShows.getId());
				contestExhibit.setContestEventNo(childShows.getMainShowId());
				//查询犬种
				List<ContestBreed> breedList = contestBreedService.getByBreedCode(contestExhibit.getBreedNo());
				if (breedList == null || breedList.size() == 0) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到为" + contestExhibit.getBreedNo() + "的犬种信息！");
				}
				contestExhibit.setBreedNo(breedList.get(0).getBreedNo());
				//年龄组别
				contestExhibit.setClassNo(translationAgeGroup(contestExhibit.getClassNo()));
				if (StringUtils.isBlank(contestExhibit.getClassNo())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到秩序号为" + contestExhibit.getExhibitNo() + "的年龄组别信息！");
				}
				//血统证书
				if (StringUtils.isBlank(contestExhibit.getPedigreeCode())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到秩序号为" + contestExhibit.getExhibitNo() + "的血统证书信息！");
				}
				//boh
				if (StringUtils.isBlank(contestExhibit.getExhibitNo())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到秩序号为" + contestExhibit.getExhibitNo() + "的BOH信息！");
				}
				//设置默认值为1
				contestExhibit.setGrade("1");
				//写数据库
				super.save(contestExhibit);
				count++;
			}
			if (flag) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到有效记录！");
			}
		} catch (ZAException e) {
			throw e;
		} catch (Exception e) {
			logger.warn("赛场犬只导入出错！", e);
			throw new Exception(e);
		}
		return count;
	}

	/**
	 * @Description： 转译年龄组别
	 * @author: yuanshuai
	 * @date: 2020/10/12 16:46
	 */
	private String translationAgeGroup(String classNo) {
		String result = classNo;
		if (!StringUtils.isBlank(result)) {
			if (result.startsWith("特幼")) {
				result = "1";
			} else if (result.startsWith("幼小")) {
				result = "2";
			} else if (result.startsWith("青年")) {
				result = "3";
			} else if (result.startsWith("中间")) {
				result = "4";
			} else if (result.startsWith("冠军")) {
				result = "6";
			} else if (result.startsWith("工作")) {
				result = "7";
			} else if (result.startsWith("BBE")) {
				result = "8";
			} else if (result.startsWith("公开")) {
				result = "9";
			} else if (result.startsWith("老年")) {
				result = "10";
			} else {
				result = "";
			}
		}
		return result;
	}

	/**
	 * @Description： 导入赛场犬只模板
	 * @author: yuanshuai
	 * @date: 2020/09/30 15:36
	 */
	public List<ContestExhibit> importFileTemplate() {
		List<ContestExhibit> contestExhibitList = Lists.newArrayList();
		ContestExhibit contestExhibit = new ContestExhibit();
		contestExhibit.setContestNo("202001-天津-01");
		contestExhibit.setRaceLap("A");
		contestExhibit.setExhibitNo("023");
		contestExhibit.setClassNo("冠军公犬组");
		contestExhibit.setPedigreeCode("CKU-144482480/19");
		contestExhibit.setBoh("1(1为参加0，为不参加)");
		contestExhibit.setBreedNo("144");
		contestExhibitList.add(contestExhibit);
		return contestExhibitList;
	}

	/**
	 * @Description： 获得所有主赛事信息
	 * @author: yuanshuai
	 * @date: 2020/11/6 10:09
	 */
	public List<String> getAllContestEventList() {
		return dao.getAllContestEventList();
	}

	/**
	 * @Description： 根据主赛事编号获得犬只信息
	 * @author: yuanshuai
	 * @date: 2020/11/6 10:31
	 */
	public List<ContestExhibit> getExhibitListByContest(String contestId, String type) {
		return dao.getExhibitListByContest(contestId, type);
	}

	/**
	 * @Description： 修改成绩
	 * @author: yuanshuai
	 * @date: 2020/11/11 15:47
	 */
	@Transactional(readOnly = false)
	public int updateGrade(ContestExhibit contestExhibit) {
		contestExhibit.preUpdate();
		return dao.updateGrade(contestExhibit);
	}

	/**
	 * @Description 年龄组别转化
	 * @author yuanshuai
	 * @date 2020/11/13 15:46
	 */
	public static String getCurrentAgeGroup(String showCode, String showCodes, String ageGroups) {
		String ageGroup = null;
		String[] splitShowCodes = showCodes.split(",");
		String[] splitAgeGroups = ageGroups.split(",");
		for (int i = 0; i < splitShowCodes.length; i++) {
			if (showCode.equals(splitShowCodes[i])) {
				ageGroup = splitAgeGroups[i];
			}
		}
		return ageGroup;
	}
}