/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.banner.entity;

import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 开屏广告配置Entity
 * @author xx
 * @version 2023-08-08
 */
public class AppSplashAds extends DataEntity<AppSplashAds> {
	
	private static final long serialVersionUID = 1L;
	private String adName;		// 广告位名称
	private String status;		// 是否上架
	private Integer jumpType;		// 跳转类型
	private String jumpRoute;		// 跳转链接
	private Integer residentSeconds;		// 开屏保留时间
	private Date startDate;		// 开始时间
	private Date endDate;		// 结束时间
	private Integer priority;		// 优先级
	private Integer frequency;		// 弹窗频率
	private String fileUrl;		// 文件链接
	private String fileType;		// 文件类型
	private String programId;		// 小程序号
	private Date beginStartDate;		// 开始 开始时间
	private Date endStartDate;		// 结束 开始时间
	private Date beginEndDate;		// 开始 结束时间
	private Date endEndDate;		// 结束 结束时间
	
	public AppSplashAds() {
		super();
	}

	public AppSplashAds(String id){
		super(id);
	}

	@Length(min=1, max=64, message="广告位名称长度必须介于 1 和 64 之间")
	public String getAdName() {
		return adName;
	}

	public void setAdName(String adName) {
		this.adName = adName;
	}
	
	@Length(min=1, max=1, message="是否上架长度必须介于 1 和 1 之间")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	
	@NotNull(message="跳转类型不能为空")
	public Integer getJumpType() {
		return jumpType;
	}

	public void setJumpType(Integer jumpType) {
		this.jumpType = jumpType;
	}
	
	@Length(min=0, max=500, message="跳转链接长度必须介于 0 和 500 之间")
	public String getJumpRoute() {
		return jumpRoute;
	}

	public void setJumpRoute(String jumpRoute) {
		this.jumpRoute = jumpRoute;
	}
	
	public Integer getResidentSeconds() {
		return residentSeconds;
	}

	public void setResidentSeconds(Integer residentSeconds) {
		this.residentSeconds = residentSeconds;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="开始时间不能为空")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="结束时间不能为空")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	
	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	
	@NotNull(message="弹窗频率不能为空")
	public Integer getFrequency() {
		return frequency;
	}

	public void setFrequency(Integer frequency) {
		this.frequency = frequency;
	}
	
	@Length(min=0, max=200, message="文件链接长度必须介于 0 和 200 之间")
	public String getFileUrl() {
		return fileUrl;
	}

	public void setFileUrl(String fileUrl) {
		this.fileUrl = fileUrl;
	}
	
	@Length(min=0, max=64, message="文件类型长度必须介于 0 和 64 之间")
	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}
	
	public Date getBeginStartDate() {
		return beginStartDate;
	}

	public void setBeginStartDate(Date beginStartDate) {
		this.beginStartDate = beginStartDate;
	}
	
	public Date getEndStartDate() {
		return endStartDate;
	}

	public void setEndStartDate(Date endStartDate) {
		this.endStartDate = endStartDate;
	}
		
	public Date getBeginEndDate() {
		return beginEndDate;
	}

	public void setBeginEndDate(Date beginEndDate) {
		this.beginEndDate = beginEndDate;
	}
	
	public Date getEndEndDate() {
		return endEndDate;
	}

	public void setEndEndDate(Date endEndDate) {
		this.endEndDate = endEndDate;
	}
	
	@Length(min=0, max=64, message="小程序号长度必须介于 0 和 64 之间")
	public String getProgramId() {
		return programId;
	}

	public void setProgramId(String programId) {
		this.programId = programId;
	}
	
		
}