package com.cku.oa.appreciation.service;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import com.cku.oa.appreciation.vo.CoursesCoursewareRefRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.appreciation.entity.AppreciationCoursesCoursewareRef;
import com.cku.oa.appreciation.dao.AppreciationCoursesCoursewareRefDao;

/**
 * 鉴赏课Service
 *
 * @author xx
 * @version 2022-02-16
 */
@Service
@Transactional(readOnly = true)
public class AppreciationCoursesCoursewareRefService extends CrudService<AppreciationCoursesCoursewareRefDao, AppreciationCoursesCoursewareRef> {

	public AppreciationCoursesCoursewareRef get(String id) {
		return super.get(id);
	}

	public List<AppreciationCoursesCoursewareRef> findList(AppreciationCoursesCoursewareRef appreciationCoursesCoursewareRef) {
		return super.findList(appreciationCoursesCoursewareRef);
	}

	public Page<AppreciationCoursesCoursewareRef> findPage(Page<AppreciationCoursesCoursewareRef> page, AppreciationCoursesCoursewareRef appreciationCoursesCoursewareRef) {
		return super.findPage(page, appreciationCoursesCoursewareRef);
	}

	@Transactional(readOnly = false)
	public void save(AppreciationCoursesCoursewareRef appreciationCoursesCoursewareRef) {
		super.save(appreciationCoursesCoursewareRef);
	}

	@Transactional(readOnly = false)
	public void delete(AppreciationCoursesCoursewareRef appreciationCoursesCoursewareRef) {
		super.delete(appreciationCoursesCoursewareRef);
	}

	@Transactional(readOnly = false)
	public void relCoursesCourseware(CoursesCoursewareRefRequest request) {
		AppreciationCoursesCoursewareRef search = new AppreciationCoursesCoursewareRef();
		search.setCourseId(request.getCourseId());
		List<AppreciationCoursesCoursewareRef> currentList = findList(search);
		List<String> targetIdList = request.getCoursewareIds();
		//新增
		List<String> addList = targetIdList.stream()
				.filter(s -> currentList.stream().noneMatch(ref -> ref.getCoursewareId().equals(s)))
				.collect(Collectors.toList());
		addList.forEach(id ->{
			AppreciationCoursesCoursewareRef ref = new AppreciationCoursesCoursewareRef();
			ref.setCourseId(request.getCourseId());
			ref.setCoursewareId(id);
			save(ref);
		});
		//删除
		List<String> delList = currentList.stream()
				.filter(ref -> targetIdList.stream().noneMatch(s -> s.equals(ref.getCoursewareId())))
				.map(AppreciationCoursesCoursewareRef::getId)
				.collect(Collectors.toList());
		delList.forEach(id ->{
			delete(new AppreciationCoursesCoursewareRef(id));
		});
	}
}