/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.apidoc.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * api参数Entity
 * @author fanhuibin
 * @version 2016-09-06
 */
public class ApiParams extends DataEntity<ApiParams> {
	
	private static final long serialVersionUID = 1L;
	private String paramsName;		// params_name
	private String paramsType;		// params_type
	private String paramsLimit;		// params_limit
	private Date createTime;		// create_time
	private String interfaceId;		// interface_id
	
	public ApiParams() {
		super();
	}

	public ApiParams(String id){
		super(id);
	}

	@Length(min=0, max=50, message="params_name长度必须介于 0 和 50 之间")
	public String getParamsName() {
		return paramsName;
	}

	public void setParamsName(String paramsName) {
		this.paramsName = paramsName;
	}
	
	@Length(min=0, max=50, message="params_type长度必须介于 0 和 50 之间")
	public String getParamsType() {
		return paramsType;
	}

	public void setParamsType(String paramsType) {
		this.paramsType = paramsType;
	}
	
	@Length(min=0, max=100, message="params_limit长度必须介于 0 和 100 之间")
	public String getParamsLimit() {
		return paramsLimit;
	}

	public void setParamsLimit(String paramsLimit) {
		this.paramsLimit = paramsLimit;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	@Length(min=1, max=11, message="interface_id长度必须介于 1 和 11 之间")
	public String getInterfaceId() {
		return interfaceId;
	}

	public void setInterfaceId(String interfaceId) {
		this.interfaceId = interfaceId;
	}
	
}