//业务提醒列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //消息内容
        me.content = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //业务消息条数
        me.remindCount = ko.observable(0);
        //系统消息条数
        me.notifyCount = ko.observable(0);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findremindList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findremindList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findremindList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findremindList(false);
            }
            return false;
        }
        /**
         * 业务提醒查询方法
         */
        me.findremindList = function(isreset){
            if(isreset){
                me.pageNo(1);
                //if(util.isVal(me.content())==""){
                //    return;
                //}
            };
            var sendData = {};
            sendData["content"] = me.content();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'messagecenter/remind',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            me.listData(json.list);
                        }else{
                            me.listData([]);
                            layer.msg("业务提醒列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询业务提醒列表失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        me.getCount = function(){
            util.sendAjax({
                url:'messagecenter/getCount',
                data:{},
                async:false,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.notifyCount(json.notifyCount);
                        me.remindCount(json.remindCount);
                    }
                }
            });
        }
        $(function(){
            me.getCount();
            me.findremindList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
