//系统消息列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //消息内容
        me.title = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //业务消息条数
        me.remindCount = ko.observable(0);
        //系统消息条数
        me.notifyCount = ko.observable(0);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findnotifyList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findnotifyList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findnotifyList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findnotifyList(false);
            }
            return false;
        }
        /**
         * 转义 html标签
         * @param str
         * @returns {string}
         */
        me.html_decode = function(str){
            var s = str;
            if (str.length == 0) return "";
            s = s.replace(/&lt;/g, "<");
            s = s.replace(/&gt;/g, ">");
            s = s.replace(/&nbsp;/g, " ");
            s = s.replace(/&#39;/g, "\'");
            s = s.replace(/&quot;/g, "\"");
            //s = s.replace(/<br>/g, "\n");
            return s;
        }
        /**
         * 系统通知查询方法
         */
        me.findnotifyList = function(isreset){
            if(isreset){
                me.pageNo(1);
                //if(util.isVal(me.title())==""){
                //    return;
                //}
            };
            var sendData = {};
            sendData["title"] = me.title();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'messagecenter/notify',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0){
                            $.each(data.list,function(index,item){
                                item.content = me.html_decode(item.content);
                            });
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("系统通知列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }else{
                        layer.msg("查询系统通知列表失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        /**
         * 详情
         */
        me.notifyDetail = function(data, event) {
            var context = ko.contextFor(event.target);//获取绑定元素的上下文;event.target绑定View Model的DOM元素
            var index = context.$index();
            //详情弹窗
            var notifyLayer = layer.open({
                title:'消息详细',
                content: data.content,
                area: ['800px', '600px'],
                scrollbar: false,
                btn: ["确定"],
                yes: function(index, layero){
                    if(data.readFlag==0){
                        //详情更新
                        var updateData = {};
                        var id = data.id;
                        updateData["id"] = id;
                        util.sendAjax({
                            url:'messagecenter/notify',
                            data: JSON.stringify(updateData),
                            async:false,
                            type:'PUT',
                            cache:false,
                            success:function(json){
                                if(json.rc==0){
                                    me.findnotifyList();
                                }
                            }
                        });
                    }
                    layer.close(notifyLayer);
                }
            });
        };
        me.getCount = function(){
            util.sendAjax({
                url:'messagecenter/getCount',
                data:{},
                async:false,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.notifyCount(json.notifyCount);
                        me.remindCount(json.remindCount);
                    }
                }
            });
        }
        $(function(){
            me.getCount();
            me.findnotifyList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
