<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书查看</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctxSchools}/groomer/groomerQualificationCertificate/view?id=${groomerQualificationCertificate.id}">证书查看</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="groomerQualificationCertificate"  class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<h3>会员基本信息</h3>
	<div class="control-group">
		<label class="control-label">会员号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerQualificationCertificate.memberCode) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">取证日期：</label>
		<div class="controls">
				<fmt:formatDate value="${groomerQualificationCertificate.takeCertificateDate}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">证书编号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerQualificationCertificate.certificateCode) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">证书级别：</label>
		<div class="controls">
				${fns:getDictLabels(groomerQualificationCertificate.levelCn, 'groomer_test_level', '无')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">签发日期：</label>
		<div class="controls">
			<fmt:formatDate value="${groomerQualificationCertificate.issueDate}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<h3>赛事信息</h3>
	<div class="control-group">
		<label class="control-label">赛事名称：</label>
		<div class="controls">
				${fns:escapeHtml(groomerRegister.groomerShow.showName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">赛事编号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerRegister.showCode)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">参赛级别：</label>
		<div class="controls">
			${fns:getDictLabels(groomerRegister.showLevel, 'groomer_test_level', '无')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">成绩：</label>
		<div class="controls">
			${fns:getDictLabel(groomerRegister.grade, 'Grade', '')}
		</div>
	</div>

	<div class="form-actions">
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>