<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function toPage(url){
			loading('正在处理中，请稍等...');
			window.location.href = url;
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctxPartner}/hospital/birthList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
				<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>血统证书号</th>
				<th>申请日期</th>
				<th>办理日期</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.pedigreeCertified)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${empty dogBirthCertificate.chipInjectDate }">
							<fmt:formatDate value="${dogBirthCertificate.dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:when>
						<c:otherwise>
							<fmt:formatDate value="${dogBirthCertificate.chipInjectDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:otherwise>
					</c:choose>				
				</td>
				<td>
					<c:choose>
						<c:when test="${not empty dogBirthCertificate.dogChip.dogChipChangeId || not empty dogBirthCertificate.pedigreeCertified }">
							<font style="color:green">已办理</font>
						</c:when>
						<c:when test="${ empty dogBirthCertificate.dogChip.dogChipChangeId && empty dogBirthCertificate.pedigreeCertified }">
							<a style="color:red" href="javascript:void;" onclick="toPage('${ctxPartner}/hospital/dogChipForm?birthCode=${dogBirthCertificate.birthCerRegCode}');">办理</a>
						</c:when>
					</c:choose>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>