<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<style>
		label.cerror {
		    background: url(images/unchecked.gif) no-repeat 0 0;
		    padding-left: 18px;
		    padding-bottom: 2px;
		    font-weight: bold;
		    color: #ea5200;
		    margin-left: 10px;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					if ($(".cerror:visible").length > 0 || !$("#inputForm").valid()){
						return false;
					}
					else{
						loading('正在提交，请稍等...');
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$("#kennelName").blur(function(){
				var kennelName = encodeURI($("#kennelName").val());
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctxPartner}/clubMember/nameCheck?memberCode=${kennel.memberCode}&name="+kennelName,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != '0'){
	                		$("#nameError").html(data.msg);
							$("#nameError").show();
	                	}else{
	                		$("#nameError").hide();
	                	}
	                }
				})
			});
			
			$("#nameEn").blur(function(){
				validateEnName($(this).attr("id"),true);
			});
			
			$("#fciName").blur(function(){
				validateEnName($(this).attr("id"),true);
			});
			
			$("#fciNameBackup").blur(function(){
				validateEnName($(this).attr("id"),false);
			});
			
			function validateEnName(inputId,isValidBlank){
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctxPartner}/clubMember/nameEnCheck?memberCode=${kennel.memberCode}&isValidBlank="+isValidBlank+"&nameEn="+encodeURI($("#"+inputId).val()),
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != '0'){
	                		$("#"+inputId+"Error").html(data.msg);
	                		$("#"+inputId+"Error").show();
	                	}else{
	                		$("#"+inputId+"Error").hide();
	                	}
	                }
				})
			}
			var kennelName = $("#kennelName").val();
			if(kennelName.endsWith("犬舍")){
				$("#kennelName").val(kennelName.substring(0,kennelName.length-2));
			}
		});
	</script>
</head>
<body>
	<ul><h2><font color="red">犬舍信息修改</font></h2>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<form:form id="inputForm" modelAttribute="kennel" action="${ctxPartner}/clubMember/kennelEdit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input id="kennelName" path="name" htmlEscape="false" maxlength="4" minlength="2" required="true" class="input-xlarge required" title="请输入2-4个字的犬舍名称"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameError" style="display:none" class="cerror"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false"  minlength="3" maxlength="30" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameEnError" style="display:none" class="cerror"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍FCI英文名：</label>
			<div class="controls">
				<form:input path="fciName" htmlEscape="false" minlength="3" maxlength="30" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="fciNameError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍FCI备用名：</label>
			<div class="controls">
				<form:input path="fciNameBackup" htmlEscape="false"  minlength="3" maxlength="30" class="input-xlarge"/>
				<label id="fciNameBackupError" style="display:none" class="cerror"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false"  maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">犬舍中文审核：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>		
		<div class="control-group">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				<form:textarea path="reviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI犬舍审核：</label>
			<div class="controls">
				<form:select path="fciReviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				<form:textarea path="fciReviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div> --%>
		<%-- <div class="control-group">
			<label class="control-label">操作记录：</label>
			<div class="controls">
				<form:textarea path="fciReviewRemark" htmlEscape="false" rows="1" maxlength="500" class="input-xxlarge "/>
			</div>
		</div> --%>
		<div style="clear:both;"/>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit"  value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	</ul>
</body>
</html>