<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"会员导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });

			//显示导入错误提示
            var importError = "${importError}";
            var reg = new RegExp("##", "g")
            if (importError != null && importError != '' && typeof importError != 'undefined') {
                alert(importError.replace(reg, "\n"));
            }
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/sys/user/member/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/sys/user/member/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/user/member/">会员列表</a></li>
		<shiro:hasPermission name="sys:user:member:add"><li><a href="${ctx}/sys/user/member/form">添加会员</a></li></shiro:hasPermission>
		<shiro:hasPermission name="sys:user:member:tcadd"><li><a href="${ctx}/sys/user/member/tcform">淘宠会员注册</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="member" action="${ctx}/sys/user/member/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>电话：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>安全手机：</label>
				<form:input path="safeMobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>证件号：</label>
				<form:input path="cardNo" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>犬舍名称：</label>
				<form:input path="kennel.name" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>会员类型：</label>
				<form:select path="memberCardType" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>缴费状态：</label>
				<form:select path="paymentState" class="input-small">
					<form:option value="all">全部</form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>犬舍类型：</label>
				<form:select path="kennel.type" class="input-small">
					<form:option value="">全部</form:option>
					<form:option value="year" label="年度犬舍"/>
					<form:option value="permanent" label="永久犬舍"/>
					<form:option value="Fci" label="FCI犬舍"/>
				</form:select>
			</li>
<%--			<li>
				<label>审核状态：</label>
				<form:select path="reviewState" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('diploma_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>--%>
			<li>
				<label>会员站点：</label>
				<form:select path="user.userType" class="input-small">
					<form:option value="">全部</form:option>
					<form:option value="2" label="UC"/>
					<form:option value="4" label="DC"/>
					<form:option value="6" label="MC"/>
				</form:select>
			</li>

			<li><label>注册缴费时间：</label>
				<input name="firstStartTime" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.firstStartTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
				<input name="firstEndTime" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.firstEndTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="sys:user:member:import">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入会员信息"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>

	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>安全手机</th>
				<th>会员类型</th>
				<th>犬舍信息</th>
				<th>缴费状态</th>
				<th>冻结状态</th>
				<th>余额</th>
				<%--<th>犬舍打印</th>--%>
				<%--<th>FCI打印</th>--%>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
					<c:if test="${!empty member.kennelAlliance}">
						<img width="16px" height="16px" src="${ctxStatic }/images/you.gif"/>
					</c:if>
					<c:if test="${!empty member.groomerType}">
						<img width="16px" height="16px" src="${ctxStatic }/images/G.jpg"/>
					</c:if>
					<c:if test="${!empty member.tcbKennel}">
						<img width="16px" height="16px" src="${ctxStatic }/images/tao.jpg"/>
					</c:if>
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(member.safeMobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
				</td>
				<td>
					<c:if test="${empty member.kennel.id && member.memberType eq 'professional' && (member.freezeFlag=='0' || empty member.freezeFlag)}">
						<%-- <shiro:hasPermission name="kennel:kennel:add">
							<a href="${ctx}/kennel/kennel/form?memberCode=${member.memberCode}">
								${fns:escapeHtml("登记犬舍")}
							</a>
						</shiro:hasPermission> --%>
					</c:if>
					<c:if test="${not empty member.kennel.id && (member.memberType eq 'professional' || member.memberType eq 'breedProfessional') && (member.freezeFlag=='0' || empty member.freezeFlag)}">
						<shiro:hasPermission name="kennel:kennel:view">
							<a href="${ctx}/kennel/kennel/view?id=${member.kennel.id}">${fns:escapeHtml(member.kennel.name)}</a>
						</shiro:hasPermission>
						<shiro:hasPermission name="kennel:kennel:edit">
							<a href="${ctx}/kennel/kennel/editFrom?id=${member.kennel.id}">编辑</a>
						</shiro:hasPermission>
					</c:if>
				</td>
				<td style="color:${member.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td>
					<c:if test="${member.freezeFlag=='0' || empty member.freezeFlag}">
						<font style="color:green">未冻结</font>
					</c:if>
					<c:if test="${member.freezeFlag=='1' }">
							<font style="color:red">已冻结</font>
					</c:if>
				</td>
				<td>
					${member.accountBalance }
				</td>
				<%--<td>--%>
					<%--<c:if test="${member.kennel.paymentState=='2' && member.kennel.reviewState=='1' && member.kennel.type=='year' && (empty member.kennel.printState || member.kennel.printState=='0')}">--%>
						<%--<shiro:hasPermission name="kennel:kennel:print">--%>
							<%--<a href="${ctx}/kennel/kennel/print?id=${member.kennel.id}">打印</a>&nbsp;&nbsp;--%>
						<%--</shiro:hasPermission>--%>
					<%--</c:if>					--%>
					<%--<c:if test="${member.kennel.paymentState=='2' && member.kennel.reviewState=='1' && member.kennel.type=='year' && member.kennel.printState=='1'}">--%>
						<%--<shiro:hasPermission name="kennel:kennel:resetPrint">--%>
							<%--<a href="${ctx}/kennel/kennel/resetPrint?id=${member.kennel.id}&tz=2">重置打印</a>&nbsp;&nbsp;--%>
						<%--</shiro:hasPermission>--%>
						<%--<shiro:lacksPermission name="kennel:kennel:resetPrint">--%>
							<%--已打印--%>
						<%--</shiro:lacksPermission>--%>
					<%--</c:if>					--%>
				<%--</td>--%>
				<%----%>
				<%--<td>--%>
					<%--<c:if test="${member.kennel.paymentState=='2' && member.kennel.fciReviewState=='1' && (empty member.kennel.fciPrintState || member.kennel.fciPrintState=='0')}">--%>
						<%--<shiro:hasPermission name="kennel:kennel:print">--%>
							<%--<a href="${ctx}/kennel/kennel/fciPrint?id=${member.kennel.id}">打印</a>&nbsp;&nbsp;--%>
						<%--</shiro:hasPermission>--%>
					<%--</c:if>					--%>
					<%--<c:if test="${member.kennel.paymentState=='2' && member.kennel.fciReviewState=='1' && member.kennel.fciPrintState=='1'}">--%>
						<%--<shiro:hasPermission name="kennel:kennel:resetPrint">--%>
							<%--<a href="${ctx}/kennel/kennel/fciResetPrint?id=${member.kennel.id}&tz=2">重置打印</a>&nbsp;&nbsp;--%>
						<%--</shiro:hasPermission>--%>
						<%--<shiro:lacksPermission name="kennel:kennel:resetPrint">--%>
							<%--已打印--%>
						<%--</shiro:lacksPermission>--%>
					<%--</c:if>					--%>
				<%--</td>--%>
				<td>
					<shiro:hasPermission name="sys:user:member:view">
    					<a href="${ctx}/sys/user/member/view?id=${member.id}">查看</a>
    				</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:edit">
						<a href="${ctx}/sys/user/member/form?id=${member.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:cardEdit">
						<a href="javascript:;"  onclick="bind('${member.id}')">修改身份证</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:cardEditTime">
						<c:if test="${not empty member.memberEndDate || not empty member.kennel.endTime}">
							<a href="javascript:;"  onclick="bind1('${member.id}')">修改截止日期</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:delete">
						<a href="javascript:;" onclick="delMember('${member.id}');">删除</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:editMemberType">
						<a href="javascript:;" onclick="updateMemberType('${member.id}')">转会员类型</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:dogNoseEdit">
						<a href="javascript:;"  onclick="bind2('${member.id}')">鼻纹采集设置</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<script type="text/javascript">
		function bind(id){
			parent.layer.open({
				type: 2,
				title: ['修改会员身份证号码', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '350px'],
				content: "${ctx}/sys/user/member/editCard/form?id="+id,
			});

			return false;
		}
        function bind1(id){
            parent.layer.open({
                type: 2,
                title: ['修改截止日期', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['600px', '360px'],
                content: "${ctx}/sys/user/member/editCardTime/form?id="+id,
            });

            return false;
        }
		//
		function updateMemberType(id){
			parent.layer.open({
				type: 2,
				title: ['转会员类型', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '360px'],
				content: "${ctx}/sys/user/member/editMemberType/form?id="+id,
			});
			return false;
		}
		function bindUserCallback(data){
			window.location.reload();
		}
		
		function bind2(id){
			parent.layer.open({
				type: 2,
				title: ['鼻纹采集设置', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '350px'],
				content: "${ctx}/sys/user/member/dogNose/form?id="+id,
			});
			return false;
		}

		function delMember(memberId){
			var html1 = '<div style="margin:10px 10px 0px 10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'<span class="jbox-icon jbox-icon-info" style="position: absolute; top: 55px; left: 15px; width: 32px; height: 32px;"></span>'+
						'<span style="font-size:14px;">请先确定<span style="color:#e45656;">是否已解绑会员绑定的网站账号及登录手机号？</span></span>'+
						'</div>'+
						'<div style="margin:0 10px 20px 10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'	<div>&nbsp;如未解绑直接删除会员,会导致会员已绑定的手机号无法再次绑定</div>'+
						'	<div>&nbsp;如不确认是否已经解绑，请转到&nbsp;<a href="${ctx}/sys/user/member/bind">关联会员</a>&nbsp;功能确认</div>'+
						'</div>';
			var html2 = '<div style="margin:10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'<span class="jbox-icon jbox-icon-info" style="position: absolute; top: 55px; left: 15px; width: 32px; height: 32px;"></span>'+
						'<span style="font-size:14px;line-height: 25px;color:#303133;">确认要删除该用户会员信息表吗？</span>'+
						'</div>';
			
			var states = {};
			states.state1 = {
			    content: html1,
			    buttons: { '确定已解绑': 1, '取消': 0 },
			    buttonsFocus: 0,
			    submit: function (v, h, f) {
			        if (v == 0) {
			            return true;
			        }
			        else {
			            $.jBox.nextState();
			        }
			        return false;
			    }
			};
			states.state2 = {
			    content: html2,
			    buttons: { '确定': 1, '取消': 0 },
			    buttonsFocus: 0,
			    submit: function (v, o, f) {
			        if (v == 0) {
			            return true;
			        }
			        else {
			        	layer.load();
			            window.location.href = "${ctx}/sys/user/member/delete?id="+memberId;
			        }
			        return false;
			    }
			};
			$.jBox.open(states, '系统提示', 450, 'auto');
		}

	</script>
</body>
</html>