<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>单犬种俱乐部优惠券变更</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            var couponHint = document.getElementById("couponHint");
            if ('${type}' === 'up') {
                couponHint.innerHTML = "增加";
            } else {
                couponHint.innerHTML = "减少";
            }
        });

        function post() {
            var count = parseInt($("#changCouponNum").val());
            var type = '${type}';
            var canUseCount = parseInt('${org.memberCouponNumCanUse}');
            if (type === 'down'
                && count > canUseCount) {
                alert("删除优惠券的数量必须小于现有可用数量");
                return false;
            }
            if (type === 'up'
                && count <= 0) {
                alert("增加优惠券的数量必须大于0");
                return false;
            }
            $.ajax({
                type: "GET",
                url: "${ctx}/sys/singleOrg/changeCouponCount?id=" + '${org.id}'
                + "&type=" + type + "&count=" + count,
                dataType: "json",
                success: function (data) {
                    top.layer.msg(data.msg);
                    if (data.rc == 0) {
                        //1.5秒之后刷新页面
                        setTimeout(function () {
                            if (parent.document.getElementById("mainFrame").contentWindow.bindOrgCouponCallback != undefined) {
                                parent.document.getElementById("mainFrame").contentWindow.bindOrgCouponCallback(data);
                            }
                            var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
                            parent.layer.close(index);

                        }, 1500);
                    }
                }
            });
            return false;
        }

        function cancel() {
            var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
            parent.layer.close(index);
        }
    </script>
</head>
<body>
<div id="bindForm" style="padding-top:20px;">
    <form id="inputForm" action="#" method="post" class="form-horizontal">
        <div class="control-group">
            <label class="control-label">俱乐部名称：</label>
            <div class="controls">
                <input type="text" value="${org.name}" class="input-xlarge " readonly="readonly"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">俱乐部编号：</label>
            <div class="controls">
                <input type="text" value="${org.memberCode}" class="input-xlarge" readonly="readonly"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">会员费抵扣券数量：</label>
            <div class="controls">
                已用${org.memberCouponNum-org.memberCouponNumCanUse}张，总计${org.memberCouponNum}张
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">
                <span id="couponHint">修改</span>抵扣券数量：
            </label>
            <div class="controls">
                <input type="text" id="changCouponNum" value="0" class="input-xlarge"
                       onkeyup="this.value=this.value.replace(/\D/g,'')"/>
            </div>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
        <center>
            <br>
            <br>
            <button class="btn btn-primary" onclick="post();return false;">确认</button> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <button class="btn btn-default" onclick="cancel();return false;">取消</button>
        </center>
    </form>

</div>
</body>
</html>