<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片发放记录管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
	<li class="active"><a href="${ctx }/sys/orgChip/list?orgId=${orgChip.orgId}&postDate=<fmt:formatDate value="${orgChip.postDate}" pattern="yyyy-MM-dd"/>">物资明细</a></li>
</ul>
	<form:form id="searchForm" modelAttribute="orgChip" action="${ctx}/sys/orgChip/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input type="hidden" name="orgId" value="${orgChip.orgId }"/>
		<input type="hidden" name="postDate" value="<fmt:formatDate value="${orgChip.postDate }" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>芯片号</th>
				<th>机构名</th>
				<th>发放时间</th>
				<th>是否作废</th>
				<shiro:hasPermission name="sys:org:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="orgChip">
			<tr>
				<td>
					${orgChip.birthCerRegCode }
				</td>
				<td>
					${orgChip.chipCode }
				</td>
				<td>
					${orgChip.org.name}
				</td>
				<td>
					<fmt:formatDate value="${orgChip.postDate }" pattern="yyyy-MM-dd HH:mm:ss"/>
					
				</td>
				
				<td>
					${fns:getDictLabel(orgChip.invalid,"yes_no","") }
				</td>
				<shiro:hasPermission name="sys:org:edit"><td>
					<a href="${ctx}/sys/orgChip/form?id=${orgChip.id}">编辑</a>
					<a href="${ctx}/sys/orgChip/delete?id=${orgChip.id}" onclick="return confirmx('确认要删除该芯片发放记录吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>