<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>收件记录管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/expressReceive/">收件记录列表</a></li>
		<shiro:hasPermission name="sys:expressReceive:add"><li><a href="${ctx}/sys/expressReceive/form">收件记录添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="expressReceive" action="${ctx}/sys/expressReceive/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>运单编号：</label>
				<form:input path="expressNo" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员姓名：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>收件备注</label>
				<form:input path="receiveRemarks" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>发件日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${expressReceive.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${expressReceive.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>会员姓名</th>
				<th>快递类型</th>
				<th>快递名</th>
				<th>收件日期</th>
				<th>收件内容</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="expressReceive">
			<tr>
				<td><a href="${ctx}/sys/expressReceive/form?id=${expressReceive.id}">
					${expressReceive.memberCode}
				</a></td>
				<td>
					${expressReceive.memberName}
				</td>
				<td>
					${fns:getDictLabel(expressReceive.expressType,'express_receive_type','') }
				</td>
				<td>
					${fns:getDictLabel(expressReceive.expressName,'express_name','')}
				</td>
				<td>
					<fmt:formatDate value="${expressReceive.receiveDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${expressReceive.content}
				</td>
				<td><shiro:hasPermission name="sys:expressReceive:edit">
    				<a href="${ctx}/sys/expressReceive/form?id=${expressReceive.id}">修改</a></shiro:hasPermission>
    				<shiro:hasPermission name="sys:expressReceive:delete">
					<a href="${ctx}/sys/expressReceive/delete?id=${expressReceive.id}" onclick="return confirmx('确认要删除该收件记录吗？', this.href)">删除</a>
				</shiro:hasPermission></td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>