<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商城销售信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function mySubmit()
		{	
			document.getElementById("isOnSubmit").value = "1";
			document.getElementById("searchForm").submit();
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">商城销售信息</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/shop/shopStatistics" method="post" class="breadcrumb form-search">
		<ul class="ul-form">
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li><label>结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>商品名称：</label>
				<select id="name" name="name" class="input-small">
					<c:if test="${selectedId!='' && selectedId!=null}">
						<option value="${fns:escapeHtml(selectedId)}" selected>${fns:escapeHtml(selectedName)}</option>
					</c:if>
					<option value="">全部</option>					
					<c:forEach items="${list}" var="p">
						<option value="${fns:escapeHtml(p.id) }">${fns:escapeHtml(p.name) }</option>
					</c:forEach>
				</select>
			</li> 
			<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" onclick = "mySubmit()" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>商品名称(价格)</th>
				<th colspan="2">合作机构</th>
				<th colspan="2">会员中心</th>
				<th colspan="2">业务订单</th>	
				<th>总计</th>			
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="result">
			<tr>
				<td>
					${result.name}(${result.price})
				</td>
				<td>
					数量:<font color="green">${result.cku_count}</font> 
				</td>
				<td>
					金额:<font color="green">${result.cku_price}</font> 
				</td>
				<td>
					数量:<font color="green">${result.oa_count}</font>
				</td>
				<td>
					金额:<font color="green">${result.oa_price}</font> 
				</td>
				<td>
					数量:<font color="green"> ${result.order_count}</font>
				</td>
				<td>
					金额:<font color="green"> ${result.order_price}</font>
				</td>
				<td>
					总数:<font color="green"> ${result.cku_count+result.oa_count+result.order_count}</font>
				</td>	
				<td>
					金额:<font color="green"> ${result.cku_price+result.oa_price+result.order_price}</font>
				</td>			
			</tr>
		</c:forEach>
			<tr>
				<td>
					<b>合计</b>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
			</tr>
		</tbody>
	</table>
	<div class="alert" role="alert" style="text-align: left;">商品退回统计</div>



	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
		<tr>
			<th>商品名称(价格)</th>
			<th>总数</th>
		</tr>
		</thead>
		<tbody>
		<c:forEach items="${reback}" var="reb">
			<tr>
				<td>
				${reb.goodsName}(${reb.goodsPrice})
				</td>
				<td name="reBackNum">
				${reb.reBackNum}
				</td>
			</tr>
		</c:forEach>
		<tr>
			<td>
				合计
			</td>
			<td id="count">

			</td>
		</tr>
		</tbody>
		<script>
			$(function(){
				var reBackNumList = $("td[name='reBackNum']");
				var count = 0;
				for(var i=0;i<reBackNumList.length;i++){
					count +=parseInt(reBackNumList[i].innerText);
				}
				$("#count").html(count);
			})
		</script>
	</table>















<script type="text/javascript">
	if(document.getElementById('contentTable').getElementsByTagName('tr').length-1!=1)
	{
		calcTotal(document.getElementById('contentTable'),1,'数量');
		calcTotal(document.getElementById('contentTable'),2,'金额');
		calcTotal(document.getElementById('contentTable'),3,'数量');		
		calcTotal(document.getElementById('contentTable'),4,'金额');		
		calcTotal(document.getElementById('contentTable'),5,'数量');		
		calcTotal(document.getElementById('contentTable'),6,'金额');		
		calcTotal(document.getElementById('contentTable'),7,'总数');		
		calcTotal(document.getElementById('contentTable'),8,'总金额');		
	}
	function calcTotal(table,column,text){			
		var trs=table.getElementsByTagName('tr');		
		var start=1,//忽略第一行的表头
		end=trs.length-1;//忽略最后合计的一行
		var total = 0.00;    
		for(var i=start;i<end;i++){
			var td=trs[i].getElementsByTagName('td')[column];		
			var t=parseFloat(td.innerText.substring(3,td.innerText.length));
			if(t)total=accAdd(t,total);
		}
		trs[end].getElementsByTagName('td')[column].innerHTML='<b>'+text+'：'+total+'</b>';
	}
	
	function accAdd(arg1,arg2){
		var r1,r2,m;
		try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
		try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
		m=Math.pow(10,Math.max(r1,r2))
		return (arg1*m+arg2*m)/m
		}
	
</script>	
</body>
</html>