<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>大区报表</title>
<meta name="decorator" content="default" />
<script type="text/javascript">
	$(document).ready(function() {

	});
	function page(n, s) {
		$("#pageNo").val(n);
		$("#pageSize").val(s);
		$("#searchForm").submit();
		return false;
	}
</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/statistics/region/export/list">大区报表列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="regionExport"
		action="${ctx}/statistics/region/export/list" method="post"
		class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}" />
		<input id="pageSize" name="pageSize" type="hidden"
			value="${page.pageSize}" />
		<ul class="ul-form">
			<li class="btns"><input id="btnSubmit" class="btn btn-primary"
				type="submit" value="查询" /></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}" />
	<table id="contentTable"
		class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th style="text-align: center;">导出时间</th>
				<th style="text-align: center;">开始时间</th>
				<th style="text-align: center;">结束时间</th>
				<th style="text-align: center;">操作账号</th>
				<th style="text-align: center;">文件名称</th>
				<th style="text-align: center;">下载地址</th>
			</tr>
		</thead>
		<tbody>
			<c:forEach items="${page.list}" var="regionExport">
				<tr>
					<td><fmt:formatDate value="${regionExport.createDate}"
							pattern="yyyy-MM-dd HH:mm:ss" /></td>
					<td>${fns:escapeHtml(regionExport.startDate)}</td>
					<td>${fns:escapeHtml(regionExport.endDate)}</td>
					<td>${fns:escapeHtml(regionExport.loginName)}</td>
					<td>${fns:escapeHtml(regionExport.fileName)}</td>
					<td><c:if test="${not empty regionExport.url  }">
							<a href="${regionExport.url}">下载 </a>
						</c:if> <c:if test="${ empty regionExport.url  }">
							生成中
						</c:if></td>
				</tr>
			</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>