<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员消费信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctx}/statistics/member/regionalDistribution">会员分布信息</a></li>
		<li class="active"><a href="#">会员分地区消费信息</a></li>
		<li class=""><a href="${ctx}/statistics/member/memberConsumption">会员总消费统计</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/member/regionalConsumption" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>选择地区：</label>			
				<select id="province" name="province" class="input-small">
					<option value="">全国</option>					
					<c:forEach items="${province}" var="p">
						<option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</option>
					</c:forEach>
				</select>
			</li>
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li><label>结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>地区</th>
				<th>业务消费</th>
				<th>商城消费</th>
				<th>消费总计</th>				
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="result">
			<tr>
				<td>
					${fns:escapeHtml(result.province)}
				</td>
				<td>
					${result.oasum }
				</td>
				<td>
					${result.shopsum }
				</td>
				<td>
					${result.shopsum + result.oasum}
				</td>				
			</tr>
		</c:forEach>
		<c:if test="${selectedProvince=='' || selectedProvince==null}">
		<tr>
			<td>
				<b>合计</b>
			</td>			
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
		</tr>
		</c:if>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
<script type="text/javascript">
	if(document.getElementById('contentTable').getElementsByTagName('tr').length-1!=1)
	{
		calcTotal(document.getElementById('contentTable'),1,'合计');
		calcTotal(document.getElementById('contentTable'),2,'合计');
		calcTotal(document.getElementById('contentTable'),3,'总计');		
	}
	function calcTotal(table,column,text){			
		var trs=table.getElementsByTagName('tr');		
		var start=1,//忽略第一行的表头
		end=trs.length-1;//忽略最后合计的一行
		var total=0;    
		for(var i=start;i<end;i++){
			var td=trs[i].getElementsByTagName('td')[column];		
			var t=parseFloat(td.innerText.substring(0,td.innerText.length));
			if(t)total=accAdd(t,total);
		}
		trs[end].getElementsByTagName('td')[column].innerHTML='<b>'+text+'：'+total+'</b>';
	}
	function accAdd(arg1,arg2){
		var r1,r2,m;
		try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
		try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
		m=Math.pow(10,Math.max(r1,r2))
		return (arg1*m+arg2*m)/m
		}
</script>	
</body>
</html>