<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>香港赛事成绩表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/results/showResultsHk/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctxStatic}/modules/xlsx/香港成绩导入模板.xlsx">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/results/showResultsHk/">香港赛事成绩表列表</a></li>
		<shiro:hasPermission name="results:showResultsHk:edit"><li><a href="${ctx}/results/showResultsHk/form">香港赛事成绩表添加</a></li></shiro:hasPermission>
		<shiro:hasPermission name="results:showResultsHk:edit"><li><a href="${ctx}/results/showResultsHk/ranking">香港积分榜统计</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showResultsHk" action="${ctx}/results/showResultsHk/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>赛事名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主名：</label>
				<form:input path="dogOwnerName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬种：</label>
				 <form:select  path="fciCode" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${dogBreedList}" itemLabel="showEnName" itemValue="dogShowCode" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>年份：</label>
				<form:input path="year" htmlEscape="false" maxlength="4" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="results:showResultsHk:edit">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="成绩导入"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>赛事名称</th>
				<th>赛事编号</th>
				<th>BOB项成绩</th>
				<th>BIS项成绩</th>
				<th>BIG项成绩</th>
				<th>血统证书号</th>
				<th>犬名</th>
				<th>犬主名</th>
				<th>犬只性别</th>
				<th>犬种</th>
				<th>FCI代码</th>
				<th>年份</th>
				<th>本场积分</th>
				<shiro:hasPermission name="results:showResultsHk:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showResultsHk">
			<tr>
				<td>${showResultsHk.showName}
				</td>
				<td>
					${showResultsHk.showCode}
				</td>
				<td>
					${showResultsHk.resultBob}
				</td>
				<td>
					${showResultsHk.resultBis}
				</td>
				<td>
					${showResultsHk.resultBig}
				</td>
				<td>
					${showResultsHk.pedigreeCertified}
				</td>
				<td>
					${showResultsHk.dogName}
				</td>
				<td>
					${showResultsHk.dogOwnerName}
				</td>
				<td>
					${showResultsHk.dogGender}
				</td>
				<td>
					${showResultsHk.dogBreedCn}
				</td>
				<td>
					${showResultsHk.fciCode}
				</td>
				<td>
					${showResultsHk.year}
				</td>
				<td>
					${showResultsHk.showResult}
				</td>
				<shiro:hasPermission name="results:showResultsHk:edit"><td>
    				<a href="${ctx}/results/showResultsHk/form?id=${showResultsHk.id}">修改</a>
					<a href="${ctx}/results/showResultsHk/delete?id=${showResultsHk.id}" onclick="return confirmx('确认要删除该香港赛事成绩表吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>