<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展规范管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/ckuMatchRule/">犬展规范列表</a></li>
		<li class="active"><a href="${ctx}/show/ckuMatchRule/form?id=${ckuMatchRule.id}">犬展规范<shiro:hasPermission name="show:ckuMatchRule:edit">${not empty ckuMatchRule.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="show:ckuMatchRule:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="ckuMatchRule" action="${ctx}/show/ckuMatchRule/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">名称：</label>
			<div class="controls">
				<form:input path="ruleName" htmlEscape="false" maxlength="15" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">类型：</label>
			<div class="controls">
				<form:checkboxes path="typeArr" items="${fns:getDictList('match_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">序号：</label>
			<div class="controls">
				<form:input path="code" htmlEscape="false" type="number" min="0" maxlength="5" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">规则详情：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="ruleInfo" style="height:400px"   />
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="show:ckuMatchRule:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript" src="${ctxStatic }/wangEditor/js/wangEditor.min.js"></script>
	<script type="text/javascript">
		var editor = new wangEditor('ruleInfo');
		// 上传图片（举例）
		editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';

		editor.config.uploadImgFileName = 'editorImg';
		// 设置 headers（举例）
		editor.config.uploadHeaders = {
			'Accept' : 'text/x-json'
		};

		// 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		editor.config.hideLinkImg = true;
		editor.create();
	</script>
</body>
</html>