<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展裁判管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<script type="text/javascript" src="${ctxStatic }/ckeditor/ckeditor.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/judge/showJudge/">犬展裁判列表</a></li>
		<li class="active"><a href="${ctx}/judge/showJudge/view?id=${showJudge.id}">犬展裁判查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showJudge" action="${ctx}/judge/showJudge/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">裁判姓名：</label>
			<div class="controls">
				<form:input path="judgeName" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判图片：</label>
			<div class="controls">
					<img  style="max-width:200px;" src="${ctx }/sys/file/image/${showJudge.judgePicture }">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国秀展裁判照：</label>
			<div class="controls">
					<img  style="max-width:200px;" src="${ctx }/sys/file/image/${showJudge.showTypeJudgePicture }">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判介绍：</label>
			<div class="controls">
				<form:textarea id="introduce" htmlEscape="true" path="introduce" rows="4" readonly="true"  class="input-xxlarge"/>     
				<sys:ckeditor replace="introduce" uploadPath="/judge/showJudge " /> 
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判头衔：</label>
			<div class="controls">
				<form:input path="judgeTitle" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判国籍：</label>
			<div class="controls">
				<form:input path="citizenship" htmlEscape="false" maxlength="50" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判性别：</label>
			<div class="controls">
				<form:select path="judgeSex" class="input-small required" disabled="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('sex')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">头衔缩写：</label>
			<div class="controls">
				<form:input path="judgeTitleShort" htmlEscape="false" readonly="true" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" readonly="true" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>